// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * drive.
 */
@Fluent
public final class MicrosoftGraphDrive extends MicrosoftGraphBaseItemInner {
    /*
     * Describes the type of drive represented by this resource. OneDrive personal drives will return personal. OneDrive
     * for Business will return business. SharePoint document libraries will return documentLibrary. Read-only.
     */
    private String driveType;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet owner;

    /*
     * quota
     */
    private MicrosoftGraphQuota quota;

    /*
     * sharepointIds
     */
    private MicrosoftGraphSharepointIds sharePointIds;

    /*
     * systemFacet
     */
    private Map<String, Object> system;

    /*
     * The list of items the user is following. Only in OneDrive for Business.
     */
    private List<MicrosoftGraphDriveItem> following;

    /*
     * All items contained in the drive. Read-only. Nullable.
     */
    private List<MicrosoftGraphDriveItem> items;

    /*
     * list
     */
    private MicrosoftGraphList list;

    /*
     * driveItem
     */
    private MicrosoftGraphDriveItem root;

    /*
     * Collection of common folders available in OneDrive. Read-only. Nullable.
     */
    private List<MicrosoftGraphDriveItem> special;

    /*
     * drive
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphDrive class.
     */
    public MicrosoftGraphDrive() {
    }

    /**
     * Get the driveType property: Describes the type of drive represented by this resource. OneDrive personal drives
     * will return personal. OneDrive for Business will return business. SharePoint document libraries will return
     * documentLibrary. Read-only.
     * 
     * @return the driveType value.
     */
    public String driveType() {
        return this.driveType;
    }

    /**
     * Set the driveType property: Describes the type of drive represented by this resource. OneDrive personal drives
     * will return personal. OneDrive for Business will return business. SharePoint document libraries will return
     * documentLibrary. Read-only.
     * 
     * @param driveType the driveType value to set.
     * @return the MicrosoftGraphDrive object itself.
     */
    public MicrosoftGraphDrive withDriveType(String driveType) {
        this.driveType = driveType;
        return this;
    }

    /**
     * Get the owner property: identitySet.
     * 
     * @return the owner value.
     */
    public MicrosoftGraphIdentitySet owner() {
        return this.owner;
    }

    /**
     * Set the owner property: identitySet.
     * 
     * @param owner the owner value to set.
     * @return the MicrosoftGraphDrive object itself.
     */
    public MicrosoftGraphDrive withOwner(MicrosoftGraphIdentitySet owner) {
        this.owner = owner;
        return this;
    }

    /**
     * Get the quota property: quota.
     * 
     * @return the quota value.
     */
    public MicrosoftGraphQuota quota() {
        return this.quota;
    }

    /**
     * Set the quota property: quota.
     * 
     * @param quota the quota value to set.
     * @return the MicrosoftGraphDrive object itself.
     */
    public MicrosoftGraphDrive withQuota(MicrosoftGraphQuota quota) {
        this.quota = quota;
        return this;
    }

    /**
     * Get the sharePointIds property: sharepointIds.
     * 
     * @return the sharePointIds value.
     */
    public MicrosoftGraphSharepointIds sharePointIds() {
        return this.sharePointIds;
    }

    /**
     * Set the sharePointIds property: sharepointIds.
     * 
     * @param sharePointIds the sharePointIds value to set.
     * @return the MicrosoftGraphDrive object itself.
     */
    public MicrosoftGraphDrive withSharePointIds(MicrosoftGraphSharepointIds sharePointIds) {
        this.sharePointIds = sharePointIds;
        return this;
    }

    /**
     * Get the system property: systemFacet.
     * 
     * @return the system value.
     */
    public Map<String, Object> system() {
        return this.system;
    }

    /**
     * Set the system property: systemFacet.
     * 
     * @param system the system value to set.
     * @return the MicrosoftGraphDrive object itself.
     */
    public MicrosoftGraphDrive withSystem(Map<String, Object> system) {
        this.system = system;
        return this;
    }

    /**
     * Get the following property: The list of items the user is following. Only in OneDrive for Business.
     * 
     * @return the following value.
     */
    public List<MicrosoftGraphDriveItem> following() {
        return this.following;
    }

    /**
     * Set the following property: The list of items the user is following. Only in OneDrive for Business.
     * 
     * @param following the following value to set.
     * @return the MicrosoftGraphDrive object itself.
     */
    public MicrosoftGraphDrive withFollowing(List<MicrosoftGraphDriveItem> following) {
        this.following = following;
        return this;
    }

    /**
     * Get the items property: All items contained in the drive. Read-only. Nullable.
     * 
     * @return the items value.
     */
    public List<MicrosoftGraphDriveItem> items() {
        return this.items;
    }

    /**
     * Set the items property: All items contained in the drive. Read-only. Nullable.
     * 
     * @param items the items value to set.
     * @return the MicrosoftGraphDrive object itself.
     */
    public MicrosoftGraphDrive withItems(List<MicrosoftGraphDriveItem> items) {
        this.items = items;
        return this;
    }

    /**
     * Get the list property: list.
     * 
     * @return the list value.
     */
    public MicrosoftGraphList list() {
        return this.list;
    }

    /**
     * Set the list property: list.
     * 
     * @param list the list value to set.
     * @return the MicrosoftGraphDrive object itself.
     */
    public MicrosoftGraphDrive withList(MicrosoftGraphList list) {
        this.list = list;
        return this;
    }

    /**
     * Get the root property: driveItem.
     * 
     * @return the root value.
     */
    public MicrosoftGraphDriveItem root() {
        return this.root;
    }

    /**
     * Set the root property: driveItem.
     * 
     * @param root the root value to set.
     * @return the MicrosoftGraphDrive object itself.
     */
    public MicrosoftGraphDrive withRoot(MicrosoftGraphDriveItem root) {
        this.root = root;
        return this;
    }

    /**
     * Get the special property: Collection of common folders available in OneDrive. Read-only. Nullable.
     * 
     * @return the special value.
     */
    public List<MicrosoftGraphDriveItem> special() {
        return this.special;
    }

    /**
     * Set the special property: Collection of common folders available in OneDrive. Read-only. Nullable.
     * 
     * @param special the special value to set.
     * @return the MicrosoftGraphDrive object itself.
     */
    public MicrosoftGraphDrive withSpecial(List<MicrosoftGraphDriveItem> special) {
        this.special = special;
        return this;
    }

    /**
     * Get the additionalProperties property: drive.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: drive.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDrive object itself.
     */
    public MicrosoftGraphDrive withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withName(String name) {
        super.withName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withParentReference(MicrosoftGraphItemReference parentReference) {
        super.withParentReference(parentReference);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withWebUrl(String webUrl) {
        super.withWebUrl(webUrl);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withCreatedByUser(MicrosoftGraphUserInner createdByUser) {
        super.withCreatedByUser(createdByUser);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withLastModifiedByUser(MicrosoftGraphUserInner lastModifiedByUser) {
        super.withLastModifiedByUser(lastModifiedByUser);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphDrive withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (owner() != null) {
            owner().validate();
        }
        if (quota() != null) {
            quota().validate();
        }
        if (sharePointIds() != null) {
            sharePointIds().validate();
        }
        if (following() != null) {
            following().forEach(e -> e.validate());
        }
        if (items() != null) {
            items().forEach(e -> e.validate());
        }
        if (list() != null) {
            list().validate();
        }
        if (root() != null) {
            root().validate();
        }
        if (special() != null) {
            special().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("createdBy", createdBy());
        jsonWriter.writeStringField("createdDateTime",
            createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(createdDateTime()));
        jsonWriter.writeStringField("description", description());
        jsonWriter.writeStringField("eTag", etag());
        jsonWriter.writeJsonField("lastModifiedBy", lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime",
            lastModifiedDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(lastModifiedDateTime()));
        jsonWriter.writeStringField("name", name());
        jsonWriter.writeJsonField("parentReference", parentReference());
        jsonWriter.writeStringField("webUrl", webUrl());
        jsonWriter.writeJsonField("createdByUser", createdByUser());
        jsonWriter.writeJsonField("lastModifiedByUser", lastModifiedByUser());
        jsonWriter.writeStringField("driveType", this.driveType);
        jsonWriter.writeJsonField("owner", this.owner);
        jsonWriter.writeJsonField("quota", this.quota);
        jsonWriter.writeJsonField("sharePointIds", this.sharePointIds);
        jsonWriter.writeMapField("system", this.system, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeArrayField("following", this.following, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("items", this.items, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("list", this.list);
        jsonWriter.writeJsonField("root", this.root);
        jsonWriter.writeArrayField("special", this.special, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphDrive from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphDrive if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphDrive.
     */
    public static MicrosoftGraphDrive fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphDrive deserializedMicrosoftGraphDrive = new MicrosoftGraphDrive();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withId(reader.getString());
                } else if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withCreatedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withCreatedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withDescription(reader.getString());
                } else if ("eTag".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withEtag(reader.getString());
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withLastModifiedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withName(reader.getString());
                } else if ("parentReference".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withParentReference(MicrosoftGraphItemReference.fromJson(reader));
                } else if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withWebUrl(reader.getString());
                } else if ("createdByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withCreatedByUser(MicrosoftGraphUserInner.fromJson(reader));
                } else if ("lastModifiedByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.withLastModifiedByUser(MicrosoftGraphUserInner.fromJson(reader));
                } else if ("driveType".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.driveType = reader.getString();
                } else if ("owner".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.owner = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("quota".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.quota = MicrosoftGraphQuota.fromJson(reader);
                } else if ("sharePointIds".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.sharePointIds = MicrosoftGraphSharepointIds.fromJson(reader);
                } else if ("system".equals(fieldName)) {
                    Map<String, Object> system = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphDrive.system = system;
                } else if ("following".equals(fieldName)) {
                    List<MicrosoftGraphDriveItem> following
                        = reader.readArray(reader1 -> MicrosoftGraphDriveItem.fromJson(reader1));
                    deserializedMicrosoftGraphDrive.following = following;
                } else if ("items".equals(fieldName)) {
                    List<MicrosoftGraphDriveItem> items
                        = reader.readArray(reader1 -> MicrosoftGraphDriveItem.fromJson(reader1));
                    deserializedMicrosoftGraphDrive.items = items;
                } else if ("list".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.list = MicrosoftGraphList.fromJson(reader);
                } else if ("root".equals(fieldName)) {
                    deserializedMicrosoftGraphDrive.root = MicrosoftGraphDriveItem.fromJson(reader);
                } else if ("special".equals(fieldName)) {
                    List<MicrosoftGraphDriveItem> special
                        = reader.readArray(reader1 -> MicrosoftGraphDriveItem.fromJson(reader1));
                    deserializedMicrosoftGraphDrive.special = special;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphDrive.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphDrive;
        });
    }
}
