// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * onPremisesProvisioningError.
 */
@Fluent
public final class MicrosoftGraphOnPremisesProvisioningError
    implements JsonSerializable<MicrosoftGraphOnPremisesProvisioningError> {
    /*
     * Category of the provisioning error. Note: Currently, there is only one possible value. Possible value:
     * PropertyConflict - indicates a property value is not unique. Other objects contain the same value for the
     * property.
     */
    private String category;

    /*
     * The date and time at which the error occurred.
     */
    private OffsetDateTime occurredDateTime;

    /*
     * Name of the directory property causing the error. Current possible values: UserPrincipalName or ProxyAddress
     */
    private String propertyCausingError;

    /*
     * Value of the property causing the error.
     */
    private String value;

    /*
     * onPremisesProvisioningError
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOnPremisesProvisioningError class.
     */
    public MicrosoftGraphOnPremisesProvisioningError() {
    }

    /**
     * Get the category property: Category of the provisioning error. Note: Currently, there is only one possible value.
     * Possible value: PropertyConflict - indicates a property value is not unique. Other objects contain the same value
     * for the property.
     * 
     * @return the category value.
     */
    public String category() {
        return this.category;
    }

    /**
     * Set the category property: Category of the provisioning error. Note: Currently, there is only one possible value.
     * Possible value: PropertyConflict - indicates a property value is not unique. Other objects contain the same value
     * for the property.
     * 
     * @param category the category value to set.
     * @return the MicrosoftGraphOnPremisesProvisioningError object itself.
     */
    public MicrosoftGraphOnPremisesProvisioningError withCategory(String category) {
        this.category = category;
        return this;
    }

    /**
     * Get the occurredDateTime property: The date and time at which the error occurred.
     * 
     * @return the occurredDateTime value.
     */
    public OffsetDateTime occurredDateTime() {
        return this.occurredDateTime;
    }

    /**
     * Set the occurredDateTime property: The date and time at which the error occurred.
     * 
     * @param occurredDateTime the occurredDateTime value to set.
     * @return the MicrosoftGraphOnPremisesProvisioningError object itself.
     */
    public MicrosoftGraphOnPremisesProvisioningError withOccurredDateTime(OffsetDateTime occurredDateTime) {
        this.occurredDateTime = occurredDateTime;
        return this;
    }

    /**
     * Get the propertyCausingError property: Name of the directory property causing the error. Current possible values:
     * UserPrincipalName or ProxyAddress.
     * 
     * @return the propertyCausingError value.
     */
    public String propertyCausingError() {
        return this.propertyCausingError;
    }

    /**
     * Set the propertyCausingError property: Name of the directory property causing the error. Current possible values:
     * UserPrincipalName or ProxyAddress.
     * 
     * @param propertyCausingError the propertyCausingError value to set.
     * @return the MicrosoftGraphOnPremisesProvisioningError object itself.
     */
    public MicrosoftGraphOnPremisesProvisioningError withPropertyCausingError(String propertyCausingError) {
        this.propertyCausingError = propertyCausingError;
        return this;
    }

    /**
     * Get the value property: Value of the property causing the error.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Value of the property causing the error.
     * 
     * @param value the value value to set.
     * @return the MicrosoftGraphOnPremisesProvisioningError object itself.
     */
    public MicrosoftGraphOnPremisesProvisioningError withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the additionalProperties property: onPremisesProvisioningError.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: onPremisesProvisioningError.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOnPremisesProvisioningError object itself.
     */
    public MicrosoftGraphOnPremisesProvisioningError
        withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("category", this.category);
        jsonWriter.writeStringField("occurredDateTime",
            this.occurredDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.occurredDateTime));
        jsonWriter.writeStringField("propertyCausingError", this.propertyCausingError);
        jsonWriter.writeStringField("value", this.value);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOnPremisesProvisioningError from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOnPremisesProvisioningError if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOnPremisesProvisioningError.
     */
    public static MicrosoftGraphOnPremisesProvisioningError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOnPremisesProvisioningError deserializedMicrosoftGraphOnPremisesProvisioningError
                = new MicrosoftGraphOnPremisesProvisioningError();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("category".equals(fieldName)) {
                    deserializedMicrosoftGraphOnPremisesProvisioningError.category = reader.getString();
                } else if ("occurredDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOnPremisesProvisioningError.occurredDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("propertyCausingError".equals(fieldName)) {
                    deserializedMicrosoftGraphOnPremisesProvisioningError.propertyCausingError = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedMicrosoftGraphOnPremisesProvisioningError.value = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOnPremisesProvisioningError.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOnPremisesProvisioningError;
        });
    }
}
