// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * recentNotebook.
 */
@Fluent
public final class MicrosoftGraphRecentNotebook implements JsonSerializable<MicrosoftGraphRecentNotebook> {
    /*
     * The name of the notebook.
     */
    private String displayName;

    /*
     * The date and time when the notebook was last modified. The timestamp represents date and time information using
     * ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'. Read-only.
     */
    private OffsetDateTime lastAccessedTime;

    /*
     * recentNotebookLinks
     */
    private MicrosoftGraphRecentNotebookLinks links;

    /*
     * onenoteSourceService
     */
    private MicrosoftGraphOnenoteSourceService sourceService;

    /*
     * recentNotebook
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphRecentNotebook class.
     */
    public MicrosoftGraphRecentNotebook() {
    }

    /**
     * Get the displayName property: The name of the notebook.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name of the notebook.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphRecentNotebook object itself.
     */
    public MicrosoftGraphRecentNotebook withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the lastAccessedTime property: The date and time when the notebook was last modified. The timestamp
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Read-only.
     * 
     * @return the lastAccessedTime value.
     */
    public OffsetDateTime lastAccessedTime() {
        return this.lastAccessedTime;
    }

    /**
     * Set the lastAccessedTime property: The date and time when the notebook was last modified. The timestamp
     * represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC
     * on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'. Read-only.
     * 
     * @param lastAccessedTime the lastAccessedTime value to set.
     * @return the MicrosoftGraphRecentNotebook object itself.
     */
    public MicrosoftGraphRecentNotebook withLastAccessedTime(OffsetDateTime lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
        return this;
    }

    /**
     * Get the links property: recentNotebookLinks.
     * 
     * @return the links value.
     */
    public MicrosoftGraphRecentNotebookLinks links() {
        return this.links;
    }

    /**
     * Set the links property: recentNotebookLinks.
     * 
     * @param links the links value to set.
     * @return the MicrosoftGraphRecentNotebook object itself.
     */
    public MicrosoftGraphRecentNotebook withLinks(MicrosoftGraphRecentNotebookLinks links) {
        this.links = links;
        return this;
    }

    /**
     * Get the sourceService property: onenoteSourceService.
     * 
     * @return the sourceService value.
     */
    public MicrosoftGraphOnenoteSourceService sourceService() {
        return this.sourceService;
    }

    /**
     * Set the sourceService property: onenoteSourceService.
     * 
     * @param sourceService the sourceService value to set.
     * @return the MicrosoftGraphRecentNotebook object itself.
     */
    public MicrosoftGraphRecentNotebook withSourceService(MicrosoftGraphOnenoteSourceService sourceService) {
        this.sourceService = sourceService;
        return this;
    }

    /**
     * Get the additionalProperties property: recentNotebook.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: recentNotebook.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphRecentNotebook object itself.
     */
    public MicrosoftGraphRecentNotebook withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (links() != null) {
            links().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("lastAccessedTime",
            this.lastAccessedTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastAccessedTime));
        jsonWriter.writeJsonField("links", this.links);
        jsonWriter.writeStringField("sourceService", this.sourceService == null ? null : this.sourceService.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphRecentNotebook from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphRecentNotebook if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphRecentNotebook.
     */
    public static MicrosoftGraphRecentNotebook fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphRecentNotebook deserializedMicrosoftGraphRecentNotebook = new MicrosoftGraphRecentNotebook();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphRecentNotebook.displayName = reader.getString();
                } else if ("lastAccessedTime".equals(fieldName)) {
                    deserializedMicrosoftGraphRecentNotebook.lastAccessedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("links".equals(fieldName)) {
                    deserializedMicrosoftGraphRecentNotebook.links = MicrosoftGraphRecentNotebookLinks.fromJson(reader);
                } else if ("sourceService".equals(fieldName)) {
                    deserializedMicrosoftGraphRecentNotebook.sourceService
                        = MicrosoftGraphOnenoteSourceService.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphRecentNotebook.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphRecentNotebook;
        });
    }
}
