// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * recurrencePattern.
 */
@Fluent
public final class MicrosoftGraphRecurrencePattern implements JsonSerializable<MicrosoftGraphRecurrencePattern> {
    /*
     * The day of the month on which the event occurs. Required if type is absoluteMonthly or absoluteYearly.
     */
    private Integer dayOfMonth;

    /*
     * A collection of the days of the week on which the event occurs. The possible values are: sunday, monday, tuesday,
     * wednesday, thursday, friday, saturday. If type is relativeMonthly or relativeYearly, and daysOfWeek specifies
     * more than one day, the event falls on the first day that satisfies the pattern. Required if type is weekly,
     * relativeMonthly, or relativeYearly.
     */
    private List<MicrosoftGraphDayOfWeek> daysOfWeek;

    /*
     * dayOfWeek
     */
    private MicrosoftGraphDayOfWeek firstDayOfWeek;

    /*
     * weekIndex
     */
    private MicrosoftGraphWeekIndex index;

    /*
     * The number of units between occurrences, where units can be in days, weeks, months, or years, depending on the
     * type. Required.
     */
    private Integer interval;

    /*
     * The month in which the event occurs. This is a number from 1 to 12.
     */
    private Integer month;

    /*
     * recurrencePatternType
     */
    private MicrosoftGraphRecurrencePatternType type;

    /*
     * recurrencePattern
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphRecurrencePattern class.
     */
    public MicrosoftGraphRecurrencePattern() {
    }

    /**
     * Get the dayOfMonth property: The day of the month on which the event occurs. Required if type is absoluteMonthly
     * or absoluteYearly.
     * 
     * @return the dayOfMonth value.
     */
    public Integer dayOfMonth() {
        return this.dayOfMonth;
    }

    /**
     * Set the dayOfMonth property: The day of the month on which the event occurs. Required if type is absoluteMonthly
     * or absoluteYearly.
     * 
     * @param dayOfMonth the dayOfMonth value to set.
     * @return the MicrosoftGraphRecurrencePattern object itself.
     */
    public MicrosoftGraphRecurrencePattern withDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    /**
     * Get the daysOfWeek property: A collection of the days of the week on which the event occurs. The possible values
     * are: sunday, monday, tuesday, wednesday, thursday, friday, saturday. If type is relativeMonthly or
     * relativeYearly, and daysOfWeek specifies more than one day, the event falls on the first day that satisfies the
     * pattern. Required if type is weekly, relativeMonthly, or relativeYearly.
     * 
     * @return the daysOfWeek value.
     */
    public List<MicrosoftGraphDayOfWeek> daysOfWeek() {
        return this.daysOfWeek;
    }

    /**
     * Set the daysOfWeek property: A collection of the days of the week on which the event occurs. The possible values
     * are: sunday, monday, tuesday, wednesday, thursday, friday, saturday. If type is relativeMonthly or
     * relativeYearly, and daysOfWeek specifies more than one day, the event falls on the first day that satisfies the
     * pattern. Required if type is weekly, relativeMonthly, or relativeYearly.
     * 
     * @param daysOfWeek the daysOfWeek value to set.
     * @return the MicrosoftGraphRecurrencePattern object itself.
     */
    public MicrosoftGraphRecurrencePattern withDaysOfWeek(List<MicrosoftGraphDayOfWeek> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    /**
     * Get the firstDayOfWeek property: dayOfWeek.
     * 
     * @return the firstDayOfWeek value.
     */
    public MicrosoftGraphDayOfWeek firstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    /**
     * Set the firstDayOfWeek property: dayOfWeek.
     * 
     * @param firstDayOfWeek the firstDayOfWeek value to set.
     * @return the MicrosoftGraphRecurrencePattern object itself.
     */
    public MicrosoftGraphRecurrencePattern withFirstDayOfWeek(MicrosoftGraphDayOfWeek firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        return this;
    }

    /**
     * Get the index property: weekIndex.
     * 
     * @return the index value.
     */
    public MicrosoftGraphWeekIndex index() {
        return this.index;
    }

    /**
     * Set the index property: weekIndex.
     * 
     * @param index the index value to set.
     * @return the MicrosoftGraphRecurrencePattern object itself.
     */
    public MicrosoftGraphRecurrencePattern withIndex(MicrosoftGraphWeekIndex index) {
        this.index = index;
        return this;
    }

    /**
     * Get the interval property: The number of units between occurrences, where units can be in days, weeks, months, or
     * years, depending on the type. Required.
     * 
     * @return the interval value.
     */
    public Integer interval() {
        return this.interval;
    }

    /**
     * Set the interval property: The number of units between occurrences, where units can be in days, weeks, months, or
     * years, depending on the type. Required.
     * 
     * @param interval the interval value to set.
     * @return the MicrosoftGraphRecurrencePattern object itself.
     */
    public MicrosoftGraphRecurrencePattern withInterval(Integer interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the month property: The month in which the event occurs. This is a number from 1 to 12.
     * 
     * @return the month value.
     */
    public Integer month() {
        return this.month;
    }

    /**
     * Set the month property: The month in which the event occurs. This is a number from 1 to 12.
     * 
     * @param month the month value to set.
     * @return the MicrosoftGraphRecurrencePattern object itself.
     */
    public MicrosoftGraphRecurrencePattern withMonth(Integer month) {
        this.month = month;
        return this;
    }

    /**
     * Get the type property: recurrencePatternType.
     * 
     * @return the type value.
     */
    public MicrosoftGraphRecurrencePatternType type() {
        return this.type;
    }

    /**
     * Set the type property: recurrencePatternType.
     * 
     * @param type the type value to set.
     * @return the MicrosoftGraphRecurrencePattern object itself.
     */
    public MicrosoftGraphRecurrencePattern withType(MicrosoftGraphRecurrencePatternType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: recurrencePattern.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: recurrencePattern.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphRecurrencePattern object itself.
     */
    public MicrosoftGraphRecurrencePattern withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("dayOfMonth", this.dayOfMonth);
        jsonWriter.writeArrayField("daysOfWeek", this.daysOfWeek,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("firstDayOfWeek",
            this.firstDayOfWeek == null ? null : this.firstDayOfWeek.toString());
        jsonWriter.writeStringField("index", this.index == null ? null : this.index.toString());
        jsonWriter.writeNumberField("interval", this.interval);
        jsonWriter.writeNumberField("month", this.month);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphRecurrencePattern from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphRecurrencePattern if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphRecurrencePattern.
     */
    public static MicrosoftGraphRecurrencePattern fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphRecurrencePattern deserializedMicrosoftGraphRecurrencePattern
                = new MicrosoftGraphRecurrencePattern();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dayOfMonth".equals(fieldName)) {
                    deserializedMicrosoftGraphRecurrencePattern.dayOfMonth = reader.getNullable(JsonReader::getInt);
                } else if ("daysOfWeek".equals(fieldName)) {
                    List<MicrosoftGraphDayOfWeek> daysOfWeek
                        = reader.readArray(reader1 -> MicrosoftGraphDayOfWeek.fromString(reader1.getString()));
                    deserializedMicrosoftGraphRecurrencePattern.daysOfWeek = daysOfWeek;
                } else if ("firstDayOfWeek".equals(fieldName)) {
                    deserializedMicrosoftGraphRecurrencePattern.firstDayOfWeek
                        = MicrosoftGraphDayOfWeek.fromString(reader.getString());
                } else if ("index".equals(fieldName)) {
                    deserializedMicrosoftGraphRecurrencePattern.index
                        = MicrosoftGraphWeekIndex.fromString(reader.getString());
                } else if ("interval".equals(fieldName)) {
                    deserializedMicrosoftGraphRecurrencePattern.interval = reader.getNullable(JsonReader::getInt);
                } else if ("month".equals(fieldName)) {
                    deserializedMicrosoftGraphRecurrencePattern.month = reader.getNullable(JsonReader::getInt);
                } else if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphRecurrencePattern.type
                        = MicrosoftGraphRecurrencePatternType.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphRecurrencePattern.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphRecurrencePattern;
        });
    }
}
