// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * sharedInsight.
 */
@Fluent
public final class MicrosoftGraphSharedInsight extends MicrosoftGraphEntity {
    /*
     * sharingDetail
     */
    private MicrosoftGraphSharingDetail lastShared;

    /*
     * resourceReference
     */
    private MicrosoftGraphResourceReference resourceReference;

    /*
     * resourceVisualization
     */
    private MicrosoftGraphResourceVisualization resourceVisualization;

    /*
     * The sharingHistory property.
     */
    private List<MicrosoftGraphSharingDetail> sharingHistory;

    /*
     * entity
     */
    private MicrosoftGraphEntity lastSharedMethod;

    /*
     * entity
     */
    private MicrosoftGraphEntity resource;

    /*
     * sharedInsight
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSharedInsight class.
     */
    public MicrosoftGraphSharedInsight() {
    }

    /**
     * Get the lastShared property: sharingDetail.
     * 
     * @return the lastShared value.
     */
    public MicrosoftGraphSharingDetail lastShared() {
        return this.lastShared;
    }

    /**
     * Set the lastShared property: sharingDetail.
     * 
     * @param lastShared the lastShared value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withLastShared(MicrosoftGraphSharingDetail lastShared) {
        this.lastShared = lastShared;
        return this;
    }

    /**
     * Get the resourceReference property: resourceReference.
     * 
     * @return the resourceReference value.
     */
    public MicrosoftGraphResourceReference resourceReference() {
        return this.resourceReference;
    }

    /**
     * Set the resourceReference property: resourceReference.
     * 
     * @param resourceReference the resourceReference value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withResourceReference(MicrosoftGraphResourceReference resourceReference) {
        this.resourceReference = resourceReference;
        return this;
    }

    /**
     * Get the resourceVisualization property: resourceVisualization.
     * 
     * @return the resourceVisualization value.
     */
    public MicrosoftGraphResourceVisualization resourceVisualization() {
        return this.resourceVisualization;
    }

    /**
     * Set the resourceVisualization property: resourceVisualization.
     * 
     * @param resourceVisualization the resourceVisualization value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight
        withResourceVisualization(MicrosoftGraphResourceVisualization resourceVisualization) {
        this.resourceVisualization = resourceVisualization;
        return this;
    }

    /**
     * Get the sharingHistory property: The sharingHistory property.
     * 
     * @return the sharingHistory value.
     */
    public List<MicrosoftGraphSharingDetail> sharingHistory() {
        return this.sharingHistory;
    }

    /**
     * Set the sharingHistory property: The sharingHistory property.
     * 
     * @param sharingHistory the sharingHistory value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withSharingHistory(List<MicrosoftGraphSharingDetail> sharingHistory) {
        this.sharingHistory = sharingHistory;
        return this;
    }

    /**
     * Get the lastSharedMethod property: entity.
     * 
     * @return the lastSharedMethod value.
     */
    public MicrosoftGraphEntity lastSharedMethod() {
        return this.lastSharedMethod;
    }

    /**
     * Set the lastSharedMethod property: entity.
     * 
     * @param lastSharedMethod the lastSharedMethod value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withLastSharedMethod(MicrosoftGraphEntity lastSharedMethod) {
        this.lastSharedMethod = lastSharedMethod;
        return this;
    }

    /**
     * Get the resource property: entity.
     * 
     * @return the resource value.
     */
    public MicrosoftGraphEntity resource() {
        return this.resource;
    }

    /**
     * Set the resource property: entity.
     * 
     * @param resource the resource value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withResource(MicrosoftGraphEntity resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the additionalProperties property: sharedInsight.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: sharedInsight.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSharedInsight object itself.
     */
    public MicrosoftGraphSharedInsight withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSharedInsight withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (lastShared() != null) {
            lastShared().validate();
        }
        if (resourceReference() != null) {
            resourceReference().validate();
        }
        if (resourceVisualization() != null) {
            resourceVisualization().validate();
        }
        if (sharingHistory() != null) {
            sharingHistory().forEach(e -> e.validate());
        }
        if (lastSharedMethod() != null) {
            lastSharedMethod().validate();
        }
        if (resource() != null) {
            resource().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("lastShared", this.lastShared);
        jsonWriter.writeJsonField("resourceReference", this.resourceReference);
        jsonWriter.writeJsonField("resourceVisualization", this.resourceVisualization);
        jsonWriter.writeArrayField("sharingHistory", this.sharingHistory,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("lastSharedMethod", this.lastSharedMethod);
        jsonWriter.writeJsonField("resource", this.resource);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSharedInsight from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSharedInsight if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSharedInsight.
     */
    public static MicrosoftGraphSharedInsight fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSharedInsight deserializedMicrosoftGraphSharedInsight = new MicrosoftGraphSharedInsight();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.withId(reader.getString());
                } else if ("lastShared".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.lastShared = MicrosoftGraphSharingDetail.fromJson(reader);
                } else if ("resourceReference".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.resourceReference
                        = MicrosoftGraphResourceReference.fromJson(reader);
                } else if ("resourceVisualization".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.resourceVisualization
                        = MicrosoftGraphResourceVisualization.fromJson(reader);
                } else if ("sharingHistory".equals(fieldName)) {
                    List<MicrosoftGraphSharingDetail> sharingHistory
                        = reader.readArray(reader1 -> MicrosoftGraphSharingDetail.fromJson(reader1));
                    deserializedMicrosoftGraphSharedInsight.sharingHistory = sharingHistory;
                } else if ("lastSharedMethod".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.lastSharedMethod = MicrosoftGraphEntity.fromJson(reader);
                } else if ("resource".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.resource = MicrosoftGraphEntity.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSharedInsight.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSharedInsight;
        });
    }
}
