// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * sizeRange.
 */
@Fluent
public final class MicrosoftGraphSizeRange implements JsonSerializable<MicrosoftGraphSizeRange> {
    /*
     * The maximum size (in kilobytes) that an incoming message must have in order for a condition or exception to
     * apply.
     */
    private Integer maximumSize;

    /*
     * The minimum size (in kilobytes) that an incoming message must have in order for a condition or exception to
     * apply.
     */
    private Integer minimumSize;

    /*
     * sizeRange
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSizeRange class.
     */
    public MicrosoftGraphSizeRange() {
    }

    /**
     * Get the maximumSize property: The maximum size (in kilobytes) that an incoming message must have in order for a
     * condition or exception to apply.
     * 
     * @return the maximumSize value.
     */
    public Integer maximumSize() {
        return this.maximumSize;
    }

    /**
     * Set the maximumSize property: The maximum size (in kilobytes) that an incoming message must have in order for a
     * condition or exception to apply.
     * 
     * @param maximumSize the maximumSize value to set.
     * @return the MicrosoftGraphSizeRange object itself.
     */
    public MicrosoftGraphSizeRange withMaximumSize(Integer maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    /**
     * Get the minimumSize property: The minimum size (in kilobytes) that an incoming message must have in order for a
     * condition or exception to apply.
     * 
     * @return the minimumSize value.
     */
    public Integer minimumSize() {
        return this.minimumSize;
    }

    /**
     * Set the minimumSize property: The minimum size (in kilobytes) that an incoming message must have in order for a
     * condition or exception to apply.
     * 
     * @param minimumSize the minimumSize value to set.
     * @return the MicrosoftGraphSizeRange object itself.
     */
    public MicrosoftGraphSizeRange withMinimumSize(Integer minimumSize) {
        this.minimumSize = minimumSize;
        return this;
    }

    /**
     * Get the additionalProperties property: sizeRange.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: sizeRange.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSizeRange object itself.
     */
    public MicrosoftGraphSizeRange withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maximumSize", this.maximumSize);
        jsonWriter.writeNumberField("minimumSize", this.minimumSize);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSizeRange from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSizeRange if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSizeRange.
     */
    public static MicrosoftGraphSizeRange fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSizeRange deserializedMicrosoftGraphSizeRange = new MicrosoftGraphSizeRange();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maximumSize".equals(fieldName)) {
                    deserializedMicrosoftGraphSizeRange.maximumSize = reader.getNullable(JsonReader::getInt);
                } else if ("minimumSize".equals(fieldName)) {
                    deserializedMicrosoftGraphSizeRange.minimumSize = reader.getNullable(JsonReader::getInt);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSizeRange.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSizeRange;
        });
    }
}
