// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/**
 * subscribedSku.
 */
@Fluent
public final class MicrosoftGraphSubscribedSku extends MicrosoftGraphEntity {
    /*
     * For example, 'User' or 'Company'.
     */
    private String appliesTo;

    /*
     * Possible values are: Enabled, Warning, Suspended, Deleted, LockedOut.
     */
    private String capabilityStatus;

    /*
     * The number of licenses that have been assigned.
     */
    private Integer consumedUnits;

    /*
     * licenseUnitsDetail
     */
    private MicrosoftGraphLicenseUnitsDetail prepaidUnits;

    /*
     * Information about the service plans that are available with the SKU. Not nullable
     */
    private List<MicrosoftGraphServicePlanInfo> servicePlans;

    /*
     * The unique identifier (GUID) for the service SKU.
     */
    private UUID skuId;

    /*
     * The skuPartNumber property.
     */
    private String skuPartNumber;

    /*
     * subscribedSku
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSubscribedSku class.
     */
    public MicrosoftGraphSubscribedSku() {
    }

    /**
     * Get the appliesTo property: For example, 'User' or 'Company'.
     * 
     * @return the appliesTo value.
     */
    public String appliesTo() {
        return this.appliesTo;
    }

    /**
     * Set the appliesTo property: For example, 'User' or 'Company'.
     * 
     * @param appliesTo the appliesTo value to set.
     * @return the MicrosoftGraphSubscribedSku object itself.
     */
    public MicrosoftGraphSubscribedSku withAppliesTo(String appliesTo) {
        this.appliesTo = appliesTo;
        return this;
    }

    /**
     * Get the capabilityStatus property: Possible values are: Enabled, Warning, Suspended, Deleted, LockedOut.
     * 
     * @return the capabilityStatus value.
     */
    public String capabilityStatus() {
        return this.capabilityStatus;
    }

    /**
     * Set the capabilityStatus property: Possible values are: Enabled, Warning, Suspended, Deleted, LockedOut.
     * 
     * @param capabilityStatus the capabilityStatus value to set.
     * @return the MicrosoftGraphSubscribedSku object itself.
     */
    public MicrosoftGraphSubscribedSku withCapabilityStatus(String capabilityStatus) {
        this.capabilityStatus = capabilityStatus;
        return this;
    }

    /**
     * Get the consumedUnits property: The number of licenses that have been assigned.
     * 
     * @return the consumedUnits value.
     */
    public Integer consumedUnits() {
        return this.consumedUnits;
    }

    /**
     * Set the consumedUnits property: The number of licenses that have been assigned.
     * 
     * @param consumedUnits the consumedUnits value to set.
     * @return the MicrosoftGraphSubscribedSku object itself.
     */
    public MicrosoftGraphSubscribedSku withConsumedUnits(Integer consumedUnits) {
        this.consumedUnits = consumedUnits;
        return this;
    }

    /**
     * Get the prepaidUnits property: licenseUnitsDetail.
     * 
     * @return the prepaidUnits value.
     */
    public MicrosoftGraphLicenseUnitsDetail prepaidUnits() {
        return this.prepaidUnits;
    }

    /**
     * Set the prepaidUnits property: licenseUnitsDetail.
     * 
     * @param prepaidUnits the prepaidUnits value to set.
     * @return the MicrosoftGraphSubscribedSku object itself.
     */
    public MicrosoftGraphSubscribedSku withPrepaidUnits(MicrosoftGraphLicenseUnitsDetail prepaidUnits) {
        this.prepaidUnits = prepaidUnits;
        return this;
    }

    /**
     * Get the servicePlans property: Information about the service plans that are available with the SKU. Not nullable.
     * 
     * @return the servicePlans value.
     */
    public List<MicrosoftGraphServicePlanInfo> servicePlans() {
        return this.servicePlans;
    }

    /**
     * Set the servicePlans property: Information about the service plans that are available with the SKU. Not nullable.
     * 
     * @param servicePlans the servicePlans value to set.
     * @return the MicrosoftGraphSubscribedSku object itself.
     */
    public MicrosoftGraphSubscribedSku withServicePlans(List<MicrosoftGraphServicePlanInfo> servicePlans) {
        this.servicePlans = servicePlans;
        return this;
    }

    /**
     * Get the skuId property: The unique identifier (GUID) for the service SKU.
     * 
     * @return the skuId value.
     */
    public UUID skuId() {
        return this.skuId;
    }

    /**
     * Set the skuId property: The unique identifier (GUID) for the service SKU.
     * 
     * @param skuId the skuId value to set.
     * @return the MicrosoftGraphSubscribedSku object itself.
     */
    public MicrosoftGraphSubscribedSku withSkuId(UUID skuId) {
        this.skuId = skuId;
        return this;
    }

    /**
     * Get the skuPartNumber property: The skuPartNumber property.
     * 
     * @return the skuPartNumber value.
     */
    public String skuPartNumber() {
        return this.skuPartNumber;
    }

    /**
     * Set the skuPartNumber property: The skuPartNumber property.
     * 
     * @param skuPartNumber the skuPartNumber value to set.
     * @return the MicrosoftGraphSubscribedSku object itself.
     */
    public MicrosoftGraphSubscribedSku withSkuPartNumber(String skuPartNumber) {
        this.skuPartNumber = skuPartNumber;
        return this;
    }

    /**
     * Get the additionalProperties property: subscribedSku.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: subscribedSku.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSubscribedSku object itself.
     */
    public MicrosoftGraphSubscribedSku withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphSubscribedSku withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (prepaidUnits() != null) {
            prepaidUnits().validate();
        }
        if (servicePlans() != null) {
            servicePlans().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("appliesTo", this.appliesTo);
        jsonWriter.writeStringField("capabilityStatus", this.capabilityStatus);
        jsonWriter.writeNumberField("consumedUnits", this.consumedUnits);
        jsonWriter.writeJsonField("prepaidUnits", this.prepaidUnits);
        jsonWriter.writeArrayField("servicePlans", this.servicePlans, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("skuId", Objects.toString(this.skuId, null));
        jsonWriter.writeStringField("skuPartNumber", this.skuPartNumber);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSubscribedSku from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSubscribedSku if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSubscribedSku.
     */
    public static MicrosoftGraphSubscribedSku fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSubscribedSku deserializedMicrosoftGraphSubscribedSku = new MicrosoftGraphSubscribedSku();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscribedSku.withId(reader.getString());
                } else if ("appliesTo".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscribedSku.appliesTo = reader.getString();
                } else if ("capabilityStatus".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscribedSku.capabilityStatus = reader.getString();
                } else if ("consumedUnits".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscribedSku.consumedUnits = reader.getNullable(JsonReader::getInt);
                } else if ("prepaidUnits".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscribedSku.prepaidUnits
                        = MicrosoftGraphLicenseUnitsDetail.fromJson(reader);
                } else if ("servicePlans".equals(fieldName)) {
                    List<MicrosoftGraphServicePlanInfo> servicePlans
                        = reader.readArray(reader1 -> MicrosoftGraphServicePlanInfo.fromJson(reader1));
                    deserializedMicrosoftGraphSubscribedSku.servicePlans = servicePlans;
                } else if ("skuId".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscribedSku.skuId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("skuPartNumber".equals(fieldName)) {
                    deserializedMicrosoftGraphSubscribedSku.skuPartNumber = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSubscribedSku.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSubscribedSku;
        });
    }
}
