// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * todoTaskList.
 */
@Fluent
public final class MicrosoftGraphTodoTaskList extends MicrosoftGraphEntity {
    /*
     * The name of the task list.
     */
    private String displayName;

    /*
     * True if the user is owner of the given task list.
     */
    private Boolean isOwner;

    /*
     * True if the task list is shared with other users
     */
    private Boolean isShared;

    /*
     * wellknownListName
     */
    private MicrosoftGraphWellknownListName wellknownListName;

    /*
     * The collection of open extensions defined for the task list. Nullable.
     */
    private List<MicrosoftGraphExtension> extensions;

    /*
     * The tasks in this task list. Read-only. Nullable.
     */
    private List<MicrosoftGraphTodoTask> tasks;

    /*
     * todoTaskList
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTodoTaskList class.
     */
    public MicrosoftGraphTodoTaskList() {
    }

    /**
     * Get the displayName property: The name of the task list.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name of the task list.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphTodoTaskList object itself.
     */
    public MicrosoftGraphTodoTaskList withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the isOwner property: True if the user is owner of the given task list.
     * 
     * @return the isOwner value.
     */
    public Boolean isOwner() {
        return this.isOwner;
    }

    /**
     * Set the isOwner property: True if the user is owner of the given task list.
     * 
     * @param isOwner the isOwner value to set.
     * @return the MicrosoftGraphTodoTaskList object itself.
     */
    public MicrosoftGraphTodoTaskList withIsOwner(Boolean isOwner) {
        this.isOwner = isOwner;
        return this;
    }

    /**
     * Get the isShared property: True if the task list is shared with other users.
     * 
     * @return the isShared value.
     */
    public Boolean isShared() {
        return this.isShared;
    }

    /**
     * Set the isShared property: True if the task list is shared with other users.
     * 
     * @param isShared the isShared value to set.
     * @return the MicrosoftGraphTodoTaskList object itself.
     */
    public MicrosoftGraphTodoTaskList withIsShared(Boolean isShared) {
        this.isShared = isShared;
        return this;
    }

    /**
     * Get the wellknownListName property: wellknownListName.
     * 
     * @return the wellknownListName value.
     */
    public MicrosoftGraphWellknownListName wellknownListName() {
        return this.wellknownListName;
    }

    /**
     * Set the wellknownListName property: wellknownListName.
     * 
     * @param wellknownListName the wellknownListName value to set.
     * @return the MicrosoftGraphTodoTaskList object itself.
     */
    public MicrosoftGraphTodoTaskList withWellknownListName(MicrosoftGraphWellknownListName wellknownListName) {
        this.wellknownListName = wellknownListName;
        return this;
    }

    /**
     * Get the extensions property: The collection of open extensions defined for the task list. Nullable.
     * 
     * @return the extensions value.
     */
    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: The collection of open extensions defined for the task list. Nullable.
     * 
     * @param extensions the extensions value to set.
     * @return the MicrosoftGraphTodoTaskList object itself.
     */
    public MicrosoftGraphTodoTaskList withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the tasks property: The tasks in this task list. Read-only. Nullable.
     * 
     * @return the tasks value.
     */
    public List<MicrosoftGraphTodoTask> tasks() {
        return this.tasks;
    }

    /**
     * Set the tasks property: The tasks in this task list. Read-only. Nullable.
     * 
     * @param tasks the tasks value to set.
     * @return the MicrosoftGraphTodoTaskList object itself.
     */
    public MicrosoftGraphTodoTaskList withTasks(List<MicrosoftGraphTodoTask> tasks) {
        this.tasks = tasks;
        return this;
    }

    /**
     * Get the additionalProperties property: todoTaskList.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: todoTaskList.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTodoTaskList object itself.
     */
    public MicrosoftGraphTodoTaskList withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTodoTaskList withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (tasks() != null) {
            tasks().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeBooleanField("isOwner", this.isOwner);
        jsonWriter.writeBooleanField("isShared", this.isShared);
        jsonWriter.writeStringField("wellknownListName",
            this.wellknownListName == null ? null : this.wellknownListName.toString());
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("tasks", this.tasks, (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTodoTaskList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTodoTaskList if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTodoTaskList.
     */
    public static MicrosoftGraphTodoTaskList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTodoTaskList deserializedMicrosoftGraphTodoTaskList = new MicrosoftGraphTodoTaskList();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTaskList.withId(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTaskList.displayName = reader.getString();
                } else if ("isOwner".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTaskList.isOwner = reader.getNullable(JsonReader::getBoolean);
                } else if ("isShared".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTaskList.isShared = reader.getNullable(JsonReader::getBoolean);
                } else if ("wellknownListName".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTaskList.wellknownListName
                        = MicrosoftGraphWellknownListName.fromString(reader.getString());
                } else if ("extensions".equals(fieldName)) {
                    List<MicrosoftGraphExtension> extensions
                        = reader.readArray(reader1 -> MicrosoftGraphExtension.fromJson(reader1));
                    deserializedMicrosoftGraphTodoTaskList.extensions = extensions;
                } else if ("tasks".equals(fieldName)) {
                    List<MicrosoftGraphTodoTask> tasks
                        = reader.readArray(reader1 -> MicrosoftGraphTodoTask.fromJson(reader1));
                    deserializedMicrosoftGraphTodoTaskList.tasks = tasks;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTodoTaskList.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTodoTaskList;
        });
    }
}
