// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * workbookChartAxisTitleFormat.
 */
@Fluent
public final class MicrosoftGraphWorkbookChartAxisTitleFormat extends MicrosoftGraphEntity {
    /*
     * workbookChartFont
     */
    private MicrosoftGraphWorkbookChartFont font;

    /*
     * workbookChartAxisTitleFormat
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookChartAxisTitleFormat class.
     */
    public MicrosoftGraphWorkbookChartAxisTitleFormat() {
    }

    /**
     * Get the font property: workbookChartFont.
     * 
     * @return the font value.
     */
    public MicrosoftGraphWorkbookChartFont font() {
        return this.font;
    }

    /**
     * Set the font property: workbookChartFont.
     * 
     * @param font the font value to set.
     * @return the MicrosoftGraphWorkbookChartAxisTitleFormat object itself.
     */
    public MicrosoftGraphWorkbookChartAxisTitleFormat withFont(MicrosoftGraphWorkbookChartFont font) {
        this.font = font;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartAxisTitleFormat.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartAxisTitleFormat.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartAxisTitleFormat object itself.
     */
    public MicrosoftGraphWorkbookChartAxisTitleFormat
        withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookChartAxisTitleFormat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (font() != null) {
            font().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("font", this.font);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookChartAxisTitleFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookChartAxisTitleFormat if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookChartAxisTitleFormat.
     */
    public static MicrosoftGraphWorkbookChartAxisTitleFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookChartAxisTitleFormat deserializedMicrosoftGraphWorkbookChartAxisTitleFormat
                = new MicrosoftGraphWorkbookChartAxisTitleFormat();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxisTitleFormat.withId(reader.getString());
                } else if ("font".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartAxisTitleFormat.font
                        = MicrosoftGraphWorkbookChartFont.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookChartAxisTitleFormat.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookChartAxisTitleFormat;
        });
    }
}
