// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * workbookChartPoint.
 */
@Fluent
public final class MicrosoftGraphWorkbookChartPoint extends MicrosoftGraphEntity {
    /*
     * Json
     */
    private Map<String, Object> value;

    /*
     * workbookChartPointFormat
     */
    private MicrosoftGraphWorkbookChartPointFormat format;

    /*
     * workbookChartPoint
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphWorkbookChartPoint class.
     */
    public MicrosoftGraphWorkbookChartPoint() {
    }

    /**
     * Get the value property: Json.
     * 
     * @return the value value.
     */
    public Map<String, Object> value() {
        return this.value;
    }

    /**
     * Set the value property: Json.
     * 
     * @param value the value value to set.
     * @return the MicrosoftGraphWorkbookChartPoint object itself.
     */
    public MicrosoftGraphWorkbookChartPoint withValue(Map<String, Object> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the format property: workbookChartPointFormat.
     * 
     * @return the format value.
     */
    public MicrosoftGraphWorkbookChartPointFormat format() {
        return this.format;
    }

    /**
     * Set the format property: workbookChartPointFormat.
     * 
     * @param format the format value to set.
     * @return the MicrosoftGraphWorkbookChartPoint object itself.
     */
    public MicrosoftGraphWorkbookChartPoint withFormat(MicrosoftGraphWorkbookChartPointFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartPoint.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartPoint.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartPoint object itself.
     */
    public MicrosoftGraphWorkbookChartPoint withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphWorkbookChartPoint withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (format() != null) {
            format().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeMapField("value", this.value, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("format", this.format);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphWorkbookChartPoint from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphWorkbookChartPoint if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphWorkbookChartPoint.
     */
    public static MicrosoftGraphWorkbookChartPoint fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookChartPoint deserializedMicrosoftGraphWorkbookChartPoint
                = new MicrosoftGraphWorkbookChartPoint();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartPoint.withId(reader.getString());
                } else if ("value".equals(fieldName)) {
                    Map<String, Object> value = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphWorkbookChartPoint.value = value;
                } else if ("format".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookChartPoint.format
                        = MicrosoftGraphWorkbookChartPointFormat.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphWorkbookChartPoint.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphWorkbookChartPoint;
        });
    }
}
