// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.RoleManagementPolicyInner;
import java.io.IOException;
import java.util.List;

/**
 * Role management policy list operation result.
 */
@Fluent
public final class RoleManagementPolicyListResult implements JsonSerializable<RoleManagementPolicyListResult> {
    /*
     * Role management policy list.
     */
    private List<RoleManagementPolicyInner> value;

    /*
     * The URL to use for getting the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of RoleManagementPolicyListResult class.
     */
    public RoleManagementPolicyListResult() {
    }

    /**
     * Get the value property: Role management policy list.
     * 
     * @return the value value.
     */
    public List<RoleManagementPolicyInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Role management policy list.
     * 
     * @param value the value value to set.
     * @return the RoleManagementPolicyListResult object itself.
     */
    public RoleManagementPolicyListResult withValue(List<RoleManagementPolicyInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to use for getting the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the RoleManagementPolicyListResult object itself.
     */
    public RoleManagementPolicyListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleManagementPolicyListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleManagementPolicyListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleManagementPolicyListResult.
     */
    public static RoleManagementPolicyListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RoleManagementPolicyListResult deserializedRoleManagementPolicyListResult
                = new RoleManagementPolicyListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RoleManagementPolicyInner> value
                        = reader.readArray(reader1 -> RoleManagementPolicyInner.fromJson(reader1));
                    deserializedRoleManagementPolicyListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRoleManagementPolicyListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleManagementPolicyListResult;
        });
    }
}
