// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * audio.
 */
@Fluent
public final class MicrosoftGraphAudio implements JsonSerializable<MicrosoftGraphAudio> {
    /*
     * The title of the album for this audio file.
     */
    private String album;

    /*
     * The artist named on the album for the audio file.
     */
    private String albumArtist;

    /*
     * The performing artist for the audio file.
     */
    private String artist;

    /*
     * Bitrate expressed in kbps.
     */
    private Long bitrate;

    /*
     * The name of the composer of the audio file.
     */
    private String composers;

    /*
     * Copyright information for the audio file.
     */
    private String copyright;

    /*
     * The number of the disc this audio file came from.
     */
    private Integer disc;

    /*
     * The total number of discs in this album.
     */
    private Integer discCount;

    /*
     * Duration of the audio file, expressed in milliseconds
     */
    private Long duration;

    /*
     * The genre of this audio file.
     */
    private String genre;

    /*
     * Indicates if the file is protected with digital rights management.
     */
    private Boolean hasDrm;

    /*
     * Indicates if the file is encoded with a variable bitrate.
     */
    private Boolean isVariableBitrate;

    /*
     * The title of the audio file.
     */
    private String title;

    /*
     * The number of the track on the original disc for this audio file.
     */
    private Integer track;

    /*
     * The total number of tracks on the original disc for this audio file.
     */
    private Integer trackCount;

    /*
     * The year the audio file was recorded.
     */
    private Integer year;

    /*
     * audio
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphAudio class.
     */
    public MicrosoftGraphAudio() {
    }

    /**
     * Get the album property: The title of the album for this audio file.
     * 
     * @return the album value.
     */
    public String album() {
        return this.album;
    }

    /**
     * Set the album property: The title of the album for this audio file.
     * 
     * @param album the album value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withAlbum(String album) {
        this.album = album;
        return this;
    }

    /**
     * Get the albumArtist property: The artist named on the album for the audio file.
     * 
     * @return the albumArtist value.
     */
    public String albumArtist() {
        return this.albumArtist;
    }

    /**
     * Set the albumArtist property: The artist named on the album for the audio file.
     * 
     * @param albumArtist the albumArtist value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withAlbumArtist(String albumArtist) {
        this.albumArtist = albumArtist;
        return this;
    }

    /**
     * Get the artist property: The performing artist for the audio file.
     * 
     * @return the artist value.
     */
    public String artist() {
        return this.artist;
    }

    /**
     * Set the artist property: The performing artist for the audio file.
     * 
     * @param artist the artist value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withArtist(String artist) {
        this.artist = artist;
        return this;
    }

    /**
     * Get the bitrate property: Bitrate expressed in kbps.
     * 
     * @return the bitrate value.
     */
    public Long bitrate() {
        return this.bitrate;
    }

    /**
     * Set the bitrate property: Bitrate expressed in kbps.
     * 
     * @param bitrate the bitrate value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withBitrate(Long bitrate) {
        this.bitrate = bitrate;
        return this;
    }

    /**
     * Get the composers property: The name of the composer of the audio file.
     * 
     * @return the composers value.
     */
    public String composers() {
        return this.composers;
    }

    /**
     * Set the composers property: The name of the composer of the audio file.
     * 
     * @param composers the composers value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withComposers(String composers) {
        this.composers = composers;
        return this;
    }

    /**
     * Get the copyright property: Copyright information for the audio file.
     * 
     * @return the copyright value.
     */
    public String copyright() {
        return this.copyright;
    }

    /**
     * Set the copyright property: Copyright information for the audio file.
     * 
     * @param copyright the copyright value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withCopyright(String copyright) {
        this.copyright = copyright;
        return this;
    }

    /**
     * Get the disc property: The number of the disc this audio file came from.
     * 
     * @return the disc value.
     */
    public Integer disc() {
        return this.disc;
    }

    /**
     * Set the disc property: The number of the disc this audio file came from.
     * 
     * @param disc the disc value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withDisc(Integer disc) {
        this.disc = disc;
        return this;
    }

    /**
     * Get the discCount property: The total number of discs in this album.
     * 
     * @return the discCount value.
     */
    public Integer discCount() {
        return this.discCount;
    }

    /**
     * Set the discCount property: The total number of discs in this album.
     * 
     * @param discCount the discCount value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withDiscCount(Integer discCount) {
        this.discCount = discCount;
        return this;
    }

    /**
     * Get the duration property: Duration of the audio file, expressed in milliseconds.
     * 
     * @return the duration value.
     */
    public Long duration() {
        return this.duration;
    }

    /**
     * Set the duration property: Duration of the audio file, expressed in milliseconds.
     * 
     * @param duration the duration value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    /**
     * Get the genre property: The genre of this audio file.
     * 
     * @return the genre value.
     */
    public String genre() {
        return this.genre;
    }

    /**
     * Set the genre property: The genre of this audio file.
     * 
     * @param genre the genre value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withGenre(String genre) {
        this.genre = genre;
        return this;
    }

    /**
     * Get the hasDrm property: Indicates if the file is protected with digital rights management.
     * 
     * @return the hasDrm value.
     */
    public Boolean hasDrm() {
        return this.hasDrm;
    }

    /**
     * Set the hasDrm property: Indicates if the file is protected with digital rights management.
     * 
     * @param hasDrm the hasDrm value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withHasDrm(Boolean hasDrm) {
        this.hasDrm = hasDrm;
        return this;
    }

    /**
     * Get the isVariableBitrate property: Indicates if the file is encoded with a variable bitrate.
     * 
     * @return the isVariableBitrate value.
     */
    public Boolean isVariableBitrate() {
        return this.isVariableBitrate;
    }

    /**
     * Set the isVariableBitrate property: Indicates if the file is encoded with a variable bitrate.
     * 
     * @param isVariableBitrate the isVariableBitrate value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withIsVariableBitrate(Boolean isVariableBitrate) {
        this.isVariableBitrate = isVariableBitrate;
        return this;
    }

    /**
     * Get the title property: The title of the audio file.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: The title of the audio file.
     * 
     * @param title the title value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the track property: The number of the track on the original disc for this audio file.
     * 
     * @return the track value.
     */
    public Integer track() {
        return this.track;
    }

    /**
     * Set the track property: The number of the track on the original disc for this audio file.
     * 
     * @param track the track value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withTrack(Integer track) {
        this.track = track;
        return this;
    }

    /**
     * Get the trackCount property: The total number of tracks on the original disc for this audio file.
     * 
     * @return the trackCount value.
     */
    public Integer trackCount() {
        return this.trackCount;
    }

    /**
     * Set the trackCount property: The total number of tracks on the original disc for this audio file.
     * 
     * @param trackCount the trackCount value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withTrackCount(Integer trackCount) {
        this.trackCount = trackCount;
        return this;
    }

    /**
     * Get the year property: The year the audio file was recorded.
     * 
     * @return the year value.
     */
    public Integer year() {
        return this.year;
    }

    /**
     * Set the year property: The year the audio file was recorded.
     * 
     * @param year the year value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withYear(Integer year) {
        this.year = year;
        return this;
    }

    /**
     * Get the additionalProperties property: audio.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: audio.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAudio object itself.
     */
    public MicrosoftGraphAudio withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("album", this.album);
        jsonWriter.writeStringField("albumArtist", this.albumArtist);
        jsonWriter.writeStringField("artist", this.artist);
        jsonWriter.writeNumberField("bitrate", this.bitrate);
        jsonWriter.writeStringField("composers", this.composers);
        jsonWriter.writeStringField("copyright", this.copyright);
        jsonWriter.writeNumberField("disc", this.disc);
        jsonWriter.writeNumberField("discCount", this.discCount);
        jsonWriter.writeNumberField("duration", this.duration);
        jsonWriter.writeStringField("genre", this.genre);
        jsonWriter.writeBooleanField("hasDrm", this.hasDrm);
        jsonWriter.writeBooleanField("isVariableBitrate", this.isVariableBitrate);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeNumberField("track", this.track);
        jsonWriter.writeNumberField("trackCount", this.trackCount);
        jsonWriter.writeNumberField("year", this.year);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphAudio from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphAudio if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphAudio.
     */
    public static MicrosoftGraphAudio fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphAudio deserializedMicrosoftGraphAudio = new MicrosoftGraphAudio();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("album".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.album = reader.getString();
                } else if ("albumArtist".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.albumArtist = reader.getString();
                } else if ("artist".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.artist = reader.getString();
                } else if ("bitrate".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.bitrate = reader.getNullable(JsonReader::getLong);
                } else if ("composers".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.composers = reader.getString();
                } else if ("copyright".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.copyright = reader.getString();
                } else if ("disc".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.disc = reader.getNullable(JsonReader::getInt);
                } else if ("discCount".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.discCount = reader.getNullable(JsonReader::getInt);
                } else if ("duration".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.duration = reader.getNullable(JsonReader::getLong);
                } else if ("genre".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.genre = reader.getString();
                } else if ("hasDrm".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.hasDrm = reader.getNullable(JsonReader::getBoolean);
                } else if ("isVariableBitrate".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.isVariableBitrate = reader.getNullable(JsonReader::getBoolean);
                } else if ("title".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.title = reader.getString();
                } else if ("track".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.track = reader.getNullable(JsonReader::getInt);
                } else if ("trackCount".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.trackCount = reader.getNullable(JsonReader::getInt);
                } else if ("year".equals(fieldName)) {
                    deserializedMicrosoftGraphAudio.year = reader.getNullable(JsonReader::getInt);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphAudio.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphAudio;
        });
    }
}
