// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * baseItem.
 */
@Fluent
public class MicrosoftGraphBaseItemInner extends MicrosoftGraphEntity {
    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet createdBy;

    /*
     * Date and time of item creation. Read-only.
     */
    private OffsetDateTime createdDateTime;

    /*
     * Provides a user-visible description of the item. Optional.
     */
    private String description;

    /*
     * ETag for the item. Read-only.
     */
    private String etag;

    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet lastModifiedBy;

    /*
     * Date and time the item was last modified. Read-only.
     */
    private OffsetDateTime lastModifiedDateTime;

    /*
     * The name of the item. Read-write.
     */
    private String name;

    /*
     * itemReference
     */
    private MicrosoftGraphItemReference parentReference;

    /*
     * URL that displays the resource in the browser. Read-only.
     */
    private String webUrl;

    /*
     * Represents an Azure Active Directory user object.
     */
    private MicrosoftGraphUserInner createdByUser;

    /*
     * Represents an Azure Active Directory user object.
     */
    private MicrosoftGraphUserInner lastModifiedByUser;

    /*
     * baseItem
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphBaseItemInner class.
     */
    public MicrosoftGraphBaseItemInner() {
    }

    /**
     * Get the createdBy property: identitySet.
     * 
     * @return the createdBy value.
     */
    public MicrosoftGraphIdentitySet createdBy() {
        return this.createdBy;
    }

    /**
     * Set the createdBy property: identitySet.
     * 
     * @param createdBy the createdBy value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Get the createdDateTime property: Date and time of item creation. Read-only.
     * 
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: Date and time of item creation. Read-only.
     * 
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the description property: Provides a user-visible description of the item. Optional.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Provides a user-visible description of the item. Optional.
     * 
     * @param description the description value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the etag property: ETag for the item. Read-only.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: ETag for the item. Read-only.
     * 
     * @param etag the etag value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the lastModifiedBy property: identitySet.
     * 
     * @return the lastModifiedBy value.
     */
    public MicrosoftGraphIdentitySet lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Set the lastModifiedBy property: identitySet.
     * 
     * @param lastModifiedBy the lastModifiedBy value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    /**
     * Get the lastModifiedDateTime property: Date and time the item was last modified. Read-only.
     * 
     * @return the lastModifiedDateTime value.
     */
    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    /**
     * Set the lastModifiedDateTime property: Date and time the item was last modified. Read-only.
     * 
     * @param lastModifiedDateTime the lastModifiedDateTime value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    /**
     * Get the name property: The name of the item. Read-write.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the item. Read-write.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the parentReference property: itemReference.
     * 
     * @return the parentReference value.
     */
    public MicrosoftGraphItemReference parentReference() {
        return this.parentReference;
    }

    /**
     * Set the parentReference property: itemReference.
     * 
     * @param parentReference the parentReference value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withParentReference(MicrosoftGraphItemReference parentReference) {
        this.parentReference = parentReference;
        return this;
    }

    /**
     * Get the webUrl property: URL that displays the resource in the browser. Read-only.
     * 
     * @return the webUrl value.
     */
    public String webUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: URL that displays the resource in the browser. Read-only.
     * 
     * @param webUrl the webUrl value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the createdByUser property: Represents an Azure Active Directory user object.
     * 
     * @return the createdByUser value.
     */
    public MicrosoftGraphUserInner createdByUser() {
        return this.createdByUser;
    }

    /**
     * Set the createdByUser property: Represents an Azure Active Directory user object.
     * 
     * @param createdByUser the createdByUser value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withCreatedByUser(MicrosoftGraphUserInner createdByUser) {
        this.createdByUser = createdByUser;
        return this;
    }

    /**
     * Get the lastModifiedByUser property: Represents an Azure Active Directory user object.
     * 
     * @return the lastModifiedByUser value.
     */
    public MicrosoftGraphUserInner lastModifiedByUser() {
        return this.lastModifiedByUser;
    }

    /**
     * Set the lastModifiedByUser property: Represents an Azure Active Directory user object.
     * 
     * @param lastModifiedByUser the lastModifiedByUser value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withLastModifiedByUser(MicrosoftGraphUserInner lastModifiedByUser) {
        this.lastModifiedByUser = lastModifiedByUser;
        return this;
    }

    /**
     * Get the additionalProperties property: baseItem.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: baseItem.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphBaseItemInner object itself.
     */
    public MicrosoftGraphBaseItemInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphBaseItemInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (createdBy() != null) {
            createdBy().validate();
        }
        if (lastModifiedBy() != null) {
            lastModifiedBy().validate();
        }
        if (parentReference() != null) {
            parentReference().validate();
        }
        if (createdByUser() != null) {
            createdByUser().validate();
        }
        if (lastModifiedByUser() != null) {
            lastModifiedByUser().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("createdBy", this.createdBy);
        jsonWriter.writeStringField("createdDateTime",
            this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("eTag", this.etag);
        jsonWriter.writeJsonField("lastModifiedBy", this.lastModifiedBy);
        jsonWriter.writeStringField("lastModifiedDateTime",
            this.lastModifiedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("parentReference", this.parentReference);
        jsonWriter.writeStringField("webUrl", this.webUrl);
        jsonWriter.writeJsonField("createdByUser", this.createdByUser);
        jsonWriter.writeJsonField("lastModifiedByUser", this.lastModifiedByUser);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphBaseItemInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphBaseItemInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphBaseItemInner.
     */
    public static MicrosoftGraphBaseItemInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphBaseItemInner deserializedMicrosoftGraphBaseItemInner = new MicrosoftGraphBaseItemInner();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.withId(reader.getString());
                } else if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.createdBy = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.createdDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.description = reader.getString();
                } else if ("eTag".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.etag = reader.getString();
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.lastModifiedBy = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.lastModifiedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.name = reader.getString();
                } else if ("parentReference".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.parentReference
                        = MicrosoftGraphItemReference.fromJson(reader);
                } else if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.webUrl = reader.getString();
                } else if ("createdByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.createdByUser = MicrosoftGraphUserInner.fromJson(reader);
                } else if ("lastModifiedByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemInner.lastModifiedByUser
                        = MicrosoftGraphUserInner.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphBaseItemInner.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphBaseItemInner;
        });
    }
}
