// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * meetingParticipantInfo.
 */
@Fluent
public final class MicrosoftGraphMeetingParticipantInfo
    implements JsonSerializable<MicrosoftGraphMeetingParticipantInfo> {
    /*
     * identitySet
     */
    private MicrosoftGraphIdentitySet identity;

    /*
     * onlineMeetingRole
     */
    private MicrosoftGraphOnlineMeetingRole role;

    /*
     * User principal name of the participant.
     */
    private String upn;

    /*
     * meetingParticipantInfo
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphMeetingParticipantInfo class.
     */
    public MicrosoftGraphMeetingParticipantInfo() {
    }

    /**
     * Get the identity property: identitySet.
     * 
     * @return the identity value.
     */
    public MicrosoftGraphIdentitySet identity() {
        return this.identity;
    }

    /**
     * Set the identity property: identitySet.
     * 
     * @param identity the identity value to set.
     * @return the MicrosoftGraphMeetingParticipantInfo object itself.
     */
    public MicrosoftGraphMeetingParticipantInfo withIdentity(MicrosoftGraphIdentitySet identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the role property: onlineMeetingRole.
     * 
     * @return the role value.
     */
    public MicrosoftGraphOnlineMeetingRole role() {
        return this.role;
    }

    /**
     * Set the role property: onlineMeetingRole.
     * 
     * @param role the role value to set.
     * @return the MicrosoftGraphMeetingParticipantInfo object itself.
     */
    public MicrosoftGraphMeetingParticipantInfo withRole(MicrosoftGraphOnlineMeetingRole role) {
        this.role = role;
        return this;
    }

    /**
     * Get the upn property: User principal name of the participant.
     * 
     * @return the upn value.
     */
    public String upn() {
        return this.upn;
    }

    /**
     * Set the upn property: User principal name of the participant.
     * 
     * @param upn the upn value to set.
     * @return the MicrosoftGraphMeetingParticipantInfo object itself.
     */
    public MicrosoftGraphMeetingParticipantInfo withUpn(String upn) {
        this.upn = upn;
        return this;
    }

    /**
     * Get the additionalProperties property: meetingParticipantInfo.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: meetingParticipantInfo.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphMeetingParticipantInfo object itself.
     */
    public MicrosoftGraphMeetingParticipantInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identity", this.identity);
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("upn", this.upn);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphMeetingParticipantInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphMeetingParticipantInfo if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphMeetingParticipantInfo.
     */
    public static MicrosoftGraphMeetingParticipantInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphMeetingParticipantInfo deserializedMicrosoftGraphMeetingParticipantInfo
                = new MicrosoftGraphMeetingParticipantInfo();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("identity".equals(fieldName)) {
                    deserializedMicrosoftGraphMeetingParticipantInfo.identity
                        = MicrosoftGraphIdentitySet.fromJson(reader);
                } else if ("role".equals(fieldName)) {
                    deserializedMicrosoftGraphMeetingParticipantInfo.role
                        = MicrosoftGraphOnlineMeetingRole.fromString(reader.getString());
                } else if ("upn".equals(fieldName)) {
                    deserializedMicrosoftGraphMeetingParticipantInfo.upn = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphMeetingParticipantInfo.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphMeetingParticipantInfo;
        });
    }
}
