// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * meetingParticipants.
 */
@Fluent
public final class MicrosoftGraphMeetingParticipants implements JsonSerializable<MicrosoftGraphMeetingParticipants> {
    /*
     * The attendees property.
     */
    private List<MicrosoftGraphMeetingParticipantInfo> attendees;

    /*
     * meetingParticipantInfo
     */
    private MicrosoftGraphMeetingParticipantInfo organizer;

    /*
     * meetingParticipants
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphMeetingParticipants class.
     */
    public MicrosoftGraphMeetingParticipants() {
    }

    /**
     * Get the attendees property: The attendees property.
     * 
     * @return the attendees value.
     */
    public List<MicrosoftGraphMeetingParticipantInfo> attendees() {
        return this.attendees;
    }

    /**
     * Set the attendees property: The attendees property.
     * 
     * @param attendees the attendees value to set.
     * @return the MicrosoftGraphMeetingParticipants object itself.
     */
    public MicrosoftGraphMeetingParticipants withAttendees(List<MicrosoftGraphMeetingParticipantInfo> attendees) {
        this.attendees = attendees;
        return this;
    }

    /**
     * Get the organizer property: meetingParticipantInfo.
     * 
     * @return the organizer value.
     */
    public MicrosoftGraphMeetingParticipantInfo organizer() {
        return this.organizer;
    }

    /**
     * Set the organizer property: meetingParticipantInfo.
     * 
     * @param organizer the organizer value to set.
     * @return the MicrosoftGraphMeetingParticipants object itself.
     */
    public MicrosoftGraphMeetingParticipants withOrganizer(MicrosoftGraphMeetingParticipantInfo organizer) {
        this.organizer = organizer;
        return this;
    }

    /**
     * Get the additionalProperties property: meetingParticipants.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: meetingParticipants.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphMeetingParticipants object itself.
     */
    public MicrosoftGraphMeetingParticipants withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (attendees() != null) {
            attendees().forEach(e -> e.validate());
        }
        if (organizer() != null) {
            organizer().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("attendees", this.attendees, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("organizer", this.organizer);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphMeetingParticipants from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphMeetingParticipants if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphMeetingParticipants.
     */
    public static MicrosoftGraphMeetingParticipants fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphMeetingParticipants deserializedMicrosoftGraphMeetingParticipants
                = new MicrosoftGraphMeetingParticipants();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("attendees".equals(fieldName)) {
                    List<MicrosoftGraphMeetingParticipantInfo> attendees
                        = reader.readArray(reader1 -> MicrosoftGraphMeetingParticipantInfo.fromJson(reader1));
                    deserializedMicrosoftGraphMeetingParticipants.attendees = attendees;
                } else if ("organizer".equals(fieldName)) {
                    deserializedMicrosoftGraphMeetingParticipants.organizer
                        = MicrosoftGraphMeetingParticipantInfo.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphMeetingParticipants.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphMeetingParticipants;
        });
    }
}
