// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * pendingContentUpdate.
 */
@Fluent
public final class MicrosoftGraphPendingContentUpdate implements JsonSerializable<MicrosoftGraphPendingContentUpdate> {
    /*
     * Date and time the pending binary operation was queued in UTC time. Read-only.
     */
    private OffsetDateTime queuedDateTime;

    /*
     * pendingContentUpdate
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPendingContentUpdate class.
     */
    public MicrosoftGraphPendingContentUpdate() {
    }

    /**
     * Get the queuedDateTime property: Date and time the pending binary operation was queued in UTC time. Read-only.
     * 
     * @return the queuedDateTime value.
     */
    public OffsetDateTime queuedDateTime() {
        return this.queuedDateTime;
    }

    /**
     * Set the queuedDateTime property: Date and time the pending binary operation was queued in UTC time. Read-only.
     * 
     * @param queuedDateTime the queuedDateTime value to set.
     * @return the MicrosoftGraphPendingContentUpdate object itself.
     */
    public MicrosoftGraphPendingContentUpdate withQueuedDateTime(OffsetDateTime queuedDateTime) {
        this.queuedDateTime = queuedDateTime;
        return this;
    }

    /**
     * Get the additionalProperties property: pendingContentUpdate.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: pendingContentUpdate.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPendingContentUpdate object itself.
     */
    public MicrosoftGraphPendingContentUpdate withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queuedDateTime",
            this.queuedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.queuedDateTime));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPendingContentUpdate from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPendingContentUpdate if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPendingContentUpdate.
     */
    public static MicrosoftGraphPendingContentUpdate fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPendingContentUpdate deserializedMicrosoftGraphPendingContentUpdate
                = new MicrosoftGraphPendingContentUpdate();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("queuedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPendingContentUpdate.queuedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPendingContentUpdate.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPendingContentUpdate;
        });
    }
}
