// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * phone.
 */
@Fluent
public final class MicrosoftGraphPhone implements JsonSerializable<MicrosoftGraphPhone> {
    /*
     * The language property.
     */
    private String language;

    /*
     * The phone number.
     */
    private String number;

    /*
     * The region property.
     */
    private String region;

    /*
     * The type property.
     */
    private MicrosoftGraphPhoneType type;

    /*
     * phone
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPhone class.
     */
    public MicrosoftGraphPhone() {
    }

    /**
     * Get the language property: The language property.
     * 
     * @return the language value.
     */
    public String language() {
        return this.language;
    }

    /**
     * Set the language property: The language property.
     * 
     * @param language the language value to set.
     * @return the MicrosoftGraphPhone object itself.
     */
    public MicrosoftGraphPhone withLanguage(String language) {
        this.language = language;
        return this;
    }

    /**
     * Get the number property: The phone number.
     * 
     * @return the number value.
     */
    public String number() {
        return this.number;
    }

    /**
     * Set the number property: The phone number.
     * 
     * @param number the number value to set.
     * @return the MicrosoftGraphPhone object itself.
     */
    public MicrosoftGraphPhone withNumber(String number) {
        this.number = number;
        return this;
    }

    /**
     * Get the region property: The region property.
     * 
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Set the region property: The region property.
     * 
     * @param region the region value to set.
     * @return the MicrosoftGraphPhone object itself.
     */
    public MicrosoftGraphPhone withRegion(String region) {
        this.region = region;
        return this;
    }

    /**
     * Get the type property: The type property.
     * 
     * @return the type value.
     */
    public MicrosoftGraphPhoneType type() {
        return this.type;
    }

    /**
     * Set the type property: The type property.
     * 
     * @param type the type value to set.
     * @return the MicrosoftGraphPhone object itself.
     */
    public MicrosoftGraphPhone withType(MicrosoftGraphPhoneType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: phone.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: phone.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPhone object itself.
     */
    public MicrosoftGraphPhone withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeStringField("number", this.number);
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPhone from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPhone if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPhone.
     */
    public static MicrosoftGraphPhone fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPhone deserializedMicrosoftGraphPhone = new MicrosoftGraphPhone();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("language".equals(fieldName)) {
                    deserializedMicrosoftGraphPhone.language = reader.getString();
                } else if ("number".equals(fieldName)) {
                    deserializedMicrosoftGraphPhone.number = reader.getString();
                } else if ("region".equals(fieldName)) {
                    deserializedMicrosoftGraphPhone.region = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphPhone.type = MicrosoftGraphPhoneType.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPhone.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPhone;
        });
    }
}
