// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * post.
 */
@Fluent
public final class MicrosoftGraphPost extends MicrosoftGraphOutlookItem {
    /*
     * itemBody
     */
    private MicrosoftGraphItemBody body;

    /*
     * Unique ID of the conversation. Read-only.
     */
    private String conversationId;

    /*
     * Unique ID of the conversation thread. Read-only.
     */
    private String conversationThreadId;

    /*
     * recipient
     */
    private MicrosoftGraphRecipient from;

    /*
     * Indicates whether the post has at least one attachment. This is a default property.
     */
    private Boolean hasAttachments;

    /*
     * Conversation participants that were added to the thread as part of this post.
     */
    private List<MicrosoftGraphRecipient> newParticipants;

    /*
     * Specifies when the post was received. The DateTimeOffset type represents date and time information using ISO 8601
     * format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this:
     * '2014-01-01T00:00:00Z'
     */
    private OffsetDateTime receivedDateTime;

    /*
     * recipient
     */
    private MicrosoftGraphRecipient sender;

    /*
     * Read-only. Nullable.
     */
    private List<MicrosoftGraphAttachment> attachments;

    /*
     * The collection of open extensions defined for the post. Read-only. Nullable.
     */
    private List<MicrosoftGraphExtension> extensions;

    /*
     * post
     */
    private MicrosoftGraphPost inReplyTo;

    /*
     * The collection of multi-value extended properties defined for the post. Read-only. Nullable.
     */
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    /*
     * The collection of single-value extended properties defined for the post. Read-only. Nullable.
     */
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    /*
     * post
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPost class.
     */
    public MicrosoftGraphPost() {
    }

    /**
     * Get the body property: itemBody.
     * 
     * @return the body value.
     */
    public MicrosoftGraphItemBody body() {
        return this.body;
    }

    /**
     * Set the body property: itemBody.
     * 
     * @param body the body value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withBody(MicrosoftGraphItemBody body) {
        this.body = body;
        return this;
    }

    /**
     * Get the conversationId property: Unique ID of the conversation. Read-only.
     * 
     * @return the conversationId value.
     */
    public String conversationId() {
        return this.conversationId;
    }

    /**
     * Set the conversationId property: Unique ID of the conversation. Read-only.
     * 
     * @param conversationId the conversationId value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withConversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    /**
     * Get the conversationThreadId property: Unique ID of the conversation thread. Read-only.
     * 
     * @return the conversationThreadId value.
     */
    public String conversationThreadId() {
        return this.conversationThreadId;
    }

    /**
     * Set the conversationThreadId property: Unique ID of the conversation thread. Read-only.
     * 
     * @param conversationThreadId the conversationThreadId value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withConversationThreadId(String conversationThreadId) {
        this.conversationThreadId = conversationThreadId;
        return this;
    }

    /**
     * Get the from property: recipient.
     * 
     * @return the from value.
     */
    public MicrosoftGraphRecipient from() {
        return this.from;
    }

    /**
     * Set the from property: recipient.
     * 
     * @param from the from value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withFrom(MicrosoftGraphRecipient from) {
        this.from = from;
        return this;
    }

    /**
     * Get the hasAttachments property: Indicates whether the post has at least one attachment. This is a default
     * property.
     * 
     * @return the hasAttachments value.
     */
    public Boolean hasAttachments() {
        return this.hasAttachments;
    }

    /**
     * Set the hasAttachments property: Indicates whether the post has at least one attachment. This is a default
     * property.
     * 
     * @param hasAttachments the hasAttachments value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    /**
     * Get the newParticipants property: Conversation participants that were added to the thread as part of this post.
     * 
     * @return the newParticipants value.
     */
    public List<MicrosoftGraphRecipient> newParticipants() {
        return this.newParticipants;
    }

    /**
     * Set the newParticipants property: Conversation participants that were added to the thread as part of this post.
     * 
     * @param newParticipants the newParticipants value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withNewParticipants(List<MicrosoftGraphRecipient> newParticipants) {
        this.newParticipants = newParticipants;
        return this;
    }

    /**
     * Get the receivedDateTime property: Specifies when the post was received. The DateTimeOffset type represents date
     * and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014
     * would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @return the receivedDateTime value.
     */
    public OffsetDateTime receivedDateTime() {
        return this.receivedDateTime;
    }

    /**
     * Set the receivedDateTime property: Specifies when the post was received. The DateTimeOffset type represents date
     * and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014
     * would look like this: '2014-01-01T00:00:00Z'.
     * 
     * @param receivedDateTime the receivedDateTime value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withReceivedDateTime(OffsetDateTime receivedDateTime) {
        this.receivedDateTime = receivedDateTime;
        return this;
    }

    /**
     * Get the sender property: recipient.
     * 
     * @return the sender value.
     */
    public MicrosoftGraphRecipient sender() {
        return this.sender;
    }

    /**
     * Set the sender property: recipient.
     * 
     * @param sender the sender value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withSender(MicrosoftGraphRecipient sender) {
        this.sender = sender;
        return this;
    }

    /**
     * Get the attachments property: Read-only. Nullable.
     * 
     * @return the attachments value.
     */
    public List<MicrosoftGraphAttachment> attachments() {
        return this.attachments;
    }

    /**
     * Set the attachments property: Read-only. Nullable.
     * 
     * @param attachments the attachments value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withAttachments(List<MicrosoftGraphAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    /**
     * Get the extensions property: The collection of open extensions defined for the post. Read-only. Nullable.
     * 
     * @return the extensions value.
     */
    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: The collection of open extensions defined for the post. Read-only. Nullable.
     * 
     * @param extensions the extensions value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the inReplyTo property: post.
     * 
     * @return the inReplyTo value.
     */
    public MicrosoftGraphPost inReplyTo() {
        return this.inReplyTo;
    }

    /**
     * Set the inReplyTo property: post.
     * 
     * @param inReplyTo the inReplyTo value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withInReplyTo(MicrosoftGraphPost inReplyTo) {
        this.inReplyTo = inReplyTo;
        return this;
    }

    /**
     * Get the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * post. Read-only. Nullable.
     * 
     * @return the multiValueExtendedProperties value.
     */
    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    /**
     * Set the multiValueExtendedProperties property: The collection of multi-value extended properties defined for the
     * post. Read-only. Nullable.
     * 
     * @param multiValueExtendedProperties the multiValueExtendedProperties value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withMultiValueExtendedProperties(
        List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    /**
     * Get the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the post. Read-only. Nullable.
     * 
     * @return the singleValueExtendedProperties value.
     */
    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    /**
     * Set the singleValueExtendedProperties property: The collection of single-value extended properties defined for
     * the post. Read-only. Nullable.
     * 
     * @param singleValueExtendedProperties the singleValueExtendedProperties value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withSingleValueExtendedProperties(
        List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    /**
     * Get the additionalProperties property: post.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: post.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPost object itself.
     */
    public MicrosoftGraphPost withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPost withCategories(List<String> categories) {
        super.withCategories(categories);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPost withChangeKey(String changeKey) {
        super.withChangeKey(changeKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPost withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPost withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphPost withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (body() != null) {
            body().validate();
        }
        if (from() != null) {
            from().validate();
        }
        if (newParticipants() != null) {
            newParticipants().forEach(e -> e.validate());
        }
        if (sender() != null) {
            sender().validate();
        }
        if (attachments() != null) {
            attachments().forEach(e -> e.validate());
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (inReplyTo() != null) {
            inReplyTo().validate();
        }
        if (multiValueExtendedProperties() != null) {
            multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (singleValueExtendedProperties() != null) {
            singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeArrayField("categories", categories(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("changeKey", changeKey());
        jsonWriter.writeStringField("createdDateTime",
            createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(createdDateTime()));
        jsonWriter.writeStringField("lastModifiedDateTime",
            lastModifiedDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(lastModifiedDateTime()));
        jsonWriter.writeJsonField("body", this.body);
        jsonWriter.writeStringField("conversationId", this.conversationId);
        jsonWriter.writeStringField("conversationThreadId", this.conversationThreadId);
        jsonWriter.writeJsonField("from", this.from);
        jsonWriter.writeBooleanField("hasAttachments", this.hasAttachments);
        jsonWriter.writeArrayField("newParticipants", this.newParticipants,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("receivedDateTime",
            this.receivedDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.receivedDateTime));
        jsonWriter.writeJsonField("sender", this.sender);
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("inReplyTo", this.inReplyTo);
        jsonWriter.writeArrayField("multiValueExtendedProperties", this.multiValueExtendedProperties,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("singleValueExtendedProperties", this.singleValueExtendedProperties,
            (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPost from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPost if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPost.
     */
    public static MicrosoftGraphPost fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPost deserializedMicrosoftGraphPost = new MicrosoftGraphPost();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.withId(reader.getString());
                } else if ("categories".equals(fieldName)) {
                    List<String> categories = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphPost.withCategories(categories);
                } else if ("changeKey".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.withChangeKey(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.withCreatedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.withLastModifiedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("body".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.body = MicrosoftGraphItemBody.fromJson(reader);
                } else if ("conversationId".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.conversationId = reader.getString();
                } else if ("conversationThreadId".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.conversationThreadId = reader.getString();
                } else if ("from".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.from = MicrosoftGraphRecipient.fromJson(reader);
                } else if ("hasAttachments".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.hasAttachments = reader.getNullable(JsonReader::getBoolean);
                } else if ("newParticipants".equals(fieldName)) {
                    List<MicrosoftGraphRecipient> newParticipants
                        = reader.readArray(reader1 -> MicrosoftGraphRecipient.fromJson(reader1));
                    deserializedMicrosoftGraphPost.newParticipants = newParticipants;
                } else if ("receivedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.receivedDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("sender".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.sender = MicrosoftGraphRecipient.fromJson(reader);
                } else if ("attachments".equals(fieldName)) {
                    List<MicrosoftGraphAttachment> attachments
                        = reader.readArray(reader1 -> MicrosoftGraphAttachment.fromJson(reader1));
                    deserializedMicrosoftGraphPost.attachments = attachments;
                } else if ("extensions".equals(fieldName)) {
                    List<MicrosoftGraphExtension> extensions
                        = reader.readArray(reader1 -> MicrosoftGraphExtension.fromJson(reader1));
                    deserializedMicrosoftGraphPost.extensions = extensions;
                } else if ("inReplyTo".equals(fieldName)) {
                    deserializedMicrosoftGraphPost.inReplyTo = MicrosoftGraphPost.fromJson(reader);
                } else if ("multiValueExtendedProperties".equals(fieldName)) {
                    List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties
                        = reader.readArray(reader1 -> MicrosoftGraphMultiValueLegacyExtendedProperty.fromJson(reader1));
                    deserializedMicrosoftGraphPost.multiValueExtendedProperties = multiValueExtendedProperties;
                } else if ("singleValueExtendedProperties".equals(fieldName)) {
                    List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties = reader
                        .readArray(reader1 -> MicrosoftGraphSingleValueLegacyExtendedProperty.fromJson(reader1));
                    deserializedMicrosoftGraphPost.singleValueExtendedProperties = singleValueExtendedProperties;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPost.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPost;
        });
    }
}
