// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Operation.
 */
@Fluent
public final class ProviderOperation implements JsonSerializable<ProviderOperation> {
    /*
     * The operation name.
     */
    private String name;

    /*
     * The operation display name.
     */
    private String displayName;

    /*
     * The operation description.
     */
    private String description;

    /*
     * The operation origin.
     */
    private String origin;

    /*
     * The operation properties.
     */
    private Object properties;

    /*
     * The dataAction flag to specify the operation type.
     */
    private Boolean isDataAction;

    /**
     * Creates an instance of ProviderOperation class.
     */
    public ProviderOperation() {
    }

    /**
     * Get the name property: The operation name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The operation name.
     * 
     * @param name the name value to set.
     * @return the ProviderOperation object itself.
     */
    public ProviderOperation withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayName property: The operation display name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The operation display name.
     * 
     * @param displayName the displayName value to set.
     * @return the ProviderOperation object itself.
     */
    public ProviderOperation withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The operation description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The operation description.
     * 
     * @param description the description value to set.
     * @return the ProviderOperation object itself.
     */
    public ProviderOperation withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the origin property: The operation origin.
     * 
     * @return the origin value.
     */
    public String origin() {
        return this.origin;
    }

    /**
     * Set the origin property: The operation origin.
     * 
     * @param origin the origin value to set.
     * @return the ProviderOperation object itself.
     */
    public ProviderOperation withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    /**
     * Get the properties property: The operation properties.
     * 
     * @return the properties value.
     */
    public Object properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The operation properties.
     * 
     * @param properties the properties value to set.
     * @return the ProviderOperation object itself.
     */
    public ProviderOperation withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the isDataAction property: The dataAction flag to specify the operation type.
     * 
     * @return the isDataAction value.
     */
    public Boolean isDataAction() {
        return this.isDataAction;
    }

    /**
     * Set the isDataAction property: The dataAction flag to specify the operation type.
     * 
     * @param isDataAction the isDataAction value to set.
     * @return the ProviderOperation object itself.
     */
    public ProviderOperation withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeUntypedField("properties", this.properties);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProviderOperation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProviderOperation if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProviderOperation.
     */
    public static ProviderOperation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProviderOperation deserializedProviderOperation = new ProviderOperation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedProviderOperation.name = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedProviderOperation.displayName = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedProviderOperation.description = reader.getString();
                } else if ("origin".equals(fieldName)) {
                    deserializedProviderOperation.origin = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedProviderOperation.properties = reader.readUntyped();
                } else if ("isDataAction".equals(fieldName)) {
                    deserializedProviderOperation.isDataAction = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProviderOperation;
        });
    }
}
