/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPublicationFacet;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public class MicrosoftGraphBaseItemVersion
extends MicrosoftGraphEntity {
    private MicrosoftGraphIdentitySet lastModifiedBy;
    private OffsetDateTime lastModifiedDateTime;
    private MicrosoftGraphPublicationFacet publication;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphIdentitySet lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public MicrosoftGraphBaseItemVersion withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphBaseItemVersion withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public MicrosoftGraphPublicationFacet publication() {
        return this.publication;
    }

    public MicrosoftGraphBaseItemVersion withPublication(MicrosoftGraphPublicationFacet publication) {
        this.publication = publication;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphBaseItemVersion withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphBaseItemVersion withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.lastModifiedBy() != null) {
            this.lastModifiedBy().validate();
        }
        if (this.publication() != null) {
            this.publication().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy);
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeJsonField("publication", (JsonSerializable)this.publication);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphBaseItemVersion fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphBaseItemVersion)jsonReader.readObject(reader -> {
            MicrosoftGraphBaseItemVersion deserializedMicrosoftGraphBaseItemVersion = new MicrosoftGraphBaseItemVersion();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemVersion.withId(reader.getString());
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemVersion.lastModifiedBy = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemVersion.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("publication".equals(fieldName)) {
                    deserializedMicrosoftGraphBaseItemVersion.publication = MicrosoftGraphPublicationFacet.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphBaseItemVersion.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphBaseItemVersion;
        });
    }
}

