// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * physicalAddress.
 */
@Fluent
public final class MicrosoftGraphPhysicalAddress implements JsonSerializable<MicrosoftGraphPhysicalAddress> {
    /*
     * The city.
     */
    private String city;

    /*
     * The country or region. It's a free-format string value, for example, 'United States'.
     */
    private String countryOrRegion;

    /*
     * The postal code.
     */
    private String postalCode;

    /*
     * The state.
     */
    private String state;

    /*
     * The street.
     */
    private String street;

    /*
     * physicalAddress
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphPhysicalAddress class.
     */
    public MicrosoftGraphPhysicalAddress() {
    }

    /**
     * Get the city property: The city.
     * 
     * @return the city value.
     */
    public String city() {
        return this.city;
    }

    /**
     * Set the city property: The city.
     * 
     * @param city the city value to set.
     * @return the MicrosoftGraphPhysicalAddress object itself.
     */
    public MicrosoftGraphPhysicalAddress withCity(String city) {
        this.city = city;
        return this;
    }

    /**
     * Get the countryOrRegion property: The country or region. It's a free-format string value, for example, 'United
     * States'.
     * 
     * @return the countryOrRegion value.
     */
    public String countryOrRegion() {
        return this.countryOrRegion;
    }

    /**
     * Set the countryOrRegion property: The country or region. It's a free-format string value, for example, 'United
     * States'.
     * 
     * @param countryOrRegion the countryOrRegion value to set.
     * @return the MicrosoftGraphPhysicalAddress object itself.
     */
    public MicrosoftGraphPhysicalAddress withCountryOrRegion(String countryOrRegion) {
        this.countryOrRegion = countryOrRegion;
        return this;
    }

    /**
     * Get the postalCode property: The postal code.
     * 
     * @return the postalCode value.
     */
    public String postalCode() {
        return this.postalCode;
    }

    /**
     * Set the postalCode property: The postal code.
     * 
     * @param postalCode the postalCode value to set.
     * @return the MicrosoftGraphPhysicalAddress object itself.
     */
    public MicrosoftGraphPhysicalAddress withPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    /**
     * Get the state property: The state.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: The state.
     * 
     * @param state the state value to set.
     * @return the MicrosoftGraphPhysicalAddress object itself.
     */
    public MicrosoftGraphPhysicalAddress withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the street property: The street.
     * 
     * @return the street value.
     */
    public String street() {
        return this.street;
    }

    /**
     * Set the street property: The street.
     * 
     * @param street the street value to set.
     * @return the MicrosoftGraphPhysicalAddress object itself.
     */
    public MicrosoftGraphPhysicalAddress withStreet(String street) {
        this.street = street;
        return this;
    }

    /**
     * Get the additionalProperties property: physicalAddress.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: physicalAddress.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPhysicalAddress object itself.
     */
    public MicrosoftGraphPhysicalAddress withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("city", this.city);
        jsonWriter.writeStringField("countryOrRegion", this.countryOrRegion);
        jsonWriter.writeStringField("postalCode", this.postalCode);
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeStringField("street", this.street);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphPhysicalAddress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphPhysicalAddress if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphPhysicalAddress.
     */
    public static MicrosoftGraphPhysicalAddress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphPhysicalAddress deserializedMicrosoftGraphPhysicalAddress
                = new MicrosoftGraphPhysicalAddress();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("city".equals(fieldName)) {
                    deserializedMicrosoftGraphPhysicalAddress.city = reader.getString();
                } else if ("countryOrRegion".equals(fieldName)) {
                    deserializedMicrosoftGraphPhysicalAddress.countryOrRegion = reader.getString();
                } else if ("postalCode".equals(fieldName)) {
                    deserializedMicrosoftGraphPhysicalAddress.postalCode = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphPhysicalAddress.state = reader.getString();
                } else if ("street".equals(fieldName)) {
                    deserializedMicrosoftGraphPhysicalAddress.street = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphPhysicalAddress.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphPhysicalAddress;
        });
    }
}
