// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schedule info of the role assignment schedule.
 */
@Fluent
public final class RoleAssignmentScheduleRequestPropertiesScheduleInfo
    implements JsonSerializable<RoleAssignmentScheduleRequestPropertiesScheduleInfo> {
    /*
     * Start DateTime of the role assignment schedule.
     */
    private OffsetDateTime startDateTime;

    /*
     * Expiration of the role assignment schedule
     */
    private RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration expiration;

    /**
     * Creates an instance of RoleAssignmentScheduleRequestPropertiesScheduleInfo class.
     */
    public RoleAssignmentScheduleRequestPropertiesScheduleInfo() {
    }

    /**
     * Get the startDateTime property: Start DateTime of the role assignment schedule.
     * 
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: Start DateTime of the role assignment schedule.
     * 
     * @param startDateTime the startDateTime value to set.
     * @return the RoleAssignmentScheduleRequestPropertiesScheduleInfo object itself.
     */
    public RoleAssignmentScheduleRequestPropertiesScheduleInfo withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the expiration property: Expiration of the role assignment schedule.
     * 
     * @return the expiration value.
     */
    public RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration expiration() {
        return this.expiration;
    }

    /**
     * Set the expiration property: Expiration of the role assignment schedule.
     * 
     * @param expiration the expiration value to set.
     * @return the RoleAssignmentScheduleRequestPropertiesScheduleInfo object itself.
     */
    public RoleAssignmentScheduleRequestPropertiesScheduleInfo
        withExpiration(RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (expiration() != null) {
            expiration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startDateTime",
            this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeJsonField("expiration", this.expiration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RoleAssignmentScheduleRequestPropertiesScheduleInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RoleAssignmentScheduleRequestPropertiesScheduleInfo if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RoleAssignmentScheduleRequestPropertiesScheduleInfo.
     */
    public static RoleAssignmentScheduleRequestPropertiesScheduleInfo fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            RoleAssignmentScheduleRequestPropertiesScheduleInfo deserializedRoleAssignmentScheduleRequestPropertiesScheduleInfo
                = new RoleAssignmentScheduleRequestPropertiesScheduleInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startDateTime".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestPropertiesScheduleInfo.startDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("expiration".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestPropertiesScheduleInfo.expiration
                        = RoleAssignmentScheduleRequestPropertiesScheduleInfoExpiration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRoleAssignmentScheduleRequestPropertiesScheduleInfo;
        });
    }
}
