// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * internetMessageHeader.
 */
@Fluent
public final class MicrosoftGraphInternetMessageHeader
    implements JsonSerializable<MicrosoftGraphInternetMessageHeader> {
    /*
     * Represents the key in a key-value pair.
     */
    private String name;

    /*
     * The value in a key-value pair.
     */
    private String value;

    /*
     * internetMessageHeader
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphInternetMessageHeader class.
     */
    public MicrosoftGraphInternetMessageHeader() {
    }

    /**
     * Get the name property: Represents the key in a key-value pair.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Represents the key in a key-value pair.
     * 
     * @param name the name value to set.
     * @return the MicrosoftGraphInternetMessageHeader object itself.
     */
    public MicrosoftGraphInternetMessageHeader withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The value in a key-value pair.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value in a key-value pair.
     * 
     * @param value the value value to set.
     * @return the MicrosoftGraphInternetMessageHeader object itself.
     */
    public MicrosoftGraphInternetMessageHeader withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the additionalProperties property: internetMessageHeader.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: internetMessageHeader.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphInternetMessageHeader object itself.
     */
    public MicrosoftGraphInternetMessageHeader withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphInternetMessageHeader from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphInternetMessageHeader if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphInternetMessageHeader.
     */
    public static MicrosoftGraphInternetMessageHeader fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphInternetMessageHeader deserializedMicrosoftGraphInternetMessageHeader
                = new MicrosoftGraphInternetMessageHeader();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphInternetMessageHeader.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedMicrosoftGraphInternetMessageHeader.value = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphInternetMessageHeader.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphInternetMessageHeader;
        });
    }
}
