// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/**
 * licenseAssignmentState.
 */
@Fluent
public final class MicrosoftGraphLicenseAssignmentState
    implements JsonSerializable<MicrosoftGraphLicenseAssignmentState> {
    /*
     * The assignedByGroup property.
     */
    private String assignedByGroup;

    /*
     * The disabledPlans property.
     */
    private List<UUID> disabledPlans;

    /*
     * The error property.
     */
    private String error;

    /*
     * The skuId property.
     */
    private UUID skuId;

    /*
     * The state property.
     */
    private String state;

    /*
     * licenseAssignmentState
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphLicenseAssignmentState class.
     */
    public MicrosoftGraphLicenseAssignmentState() {
    }

    /**
     * Get the assignedByGroup property: The assignedByGroup property.
     * 
     * @return the assignedByGroup value.
     */
    public String assignedByGroup() {
        return this.assignedByGroup;
    }

    /**
     * Set the assignedByGroup property: The assignedByGroup property.
     * 
     * @param assignedByGroup the assignedByGroup value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withAssignedByGroup(String assignedByGroup) {
        this.assignedByGroup = assignedByGroup;
        return this;
    }

    /**
     * Get the disabledPlans property: The disabledPlans property.
     * 
     * @return the disabledPlans value.
     */
    public List<UUID> disabledPlans() {
        return this.disabledPlans;
    }

    /**
     * Set the disabledPlans property: The disabledPlans property.
     * 
     * @param disabledPlans the disabledPlans value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withDisabledPlans(List<UUID> disabledPlans) {
        this.disabledPlans = disabledPlans;
        return this;
    }

    /**
     * Get the error property: The error property.
     * 
     * @return the error value.
     */
    public String error() {
        return this.error;
    }

    /**
     * Set the error property: The error property.
     * 
     * @param error the error value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withError(String error) {
        this.error = error;
        return this;
    }

    /**
     * Get the skuId property: The skuId property.
     * 
     * @return the skuId value.
     */
    public UUID skuId() {
        return this.skuId;
    }

    /**
     * Set the skuId property: The skuId property.
     * 
     * @param skuId the skuId value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withSkuId(UUID skuId) {
        this.skuId = skuId;
        return this;
    }

    /**
     * Get the state property: The state property.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: The state property.
     * 
     * @param state the state value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the additionalProperties property: licenseAssignmentState.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: licenseAssignmentState.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("assignedByGroup", this.assignedByGroup);
        jsonWriter.writeArrayField("disabledPlans", this.disabledPlans,
            (writer, element) -> writer.writeString(Objects.toString(element, null)));
        jsonWriter.writeStringField("error", this.error);
        jsonWriter.writeStringField("skuId", Objects.toString(this.skuId, null));
        jsonWriter.writeStringField("state", this.state);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphLicenseAssignmentState from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphLicenseAssignmentState if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphLicenseAssignmentState.
     */
    public static MicrosoftGraphLicenseAssignmentState fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphLicenseAssignmentState deserializedMicrosoftGraphLicenseAssignmentState
                = new MicrosoftGraphLicenseAssignmentState();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("assignedByGroup".equals(fieldName)) {
                    deserializedMicrosoftGraphLicenseAssignmentState.assignedByGroup = reader.getString();
                } else if ("disabledPlans".equals(fieldName)) {
                    List<UUID> disabledPlans = reader.readArray(
                        reader1 -> reader1.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString())));
                    deserializedMicrosoftGraphLicenseAssignmentState.disabledPlans = disabledPlans;
                } else if ("error".equals(fieldName)) {
                    deserializedMicrosoftGraphLicenseAssignmentState.error = reader.getString();
                } else if ("skuId".equals(fieldName)) {
                    deserializedMicrosoftGraphLicenseAssignmentState.skuId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphLicenseAssignmentState.state = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphLicenseAssignmentState.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphLicenseAssignmentState;
        });
    }
}
