// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * openShift.
 */
@Fluent
public final class MicrosoftGraphOpenShift extends MicrosoftGraphChangeTrackedEntity {
    /*
     * openShiftItem
     */
    private MicrosoftGraphOpenShiftItem draftOpenShift;

    /*
     * ID for the scheduling group that the open shift belongs to.
     */
    private String schedulingGroupId;

    /*
     * openShiftItem
     */
    private MicrosoftGraphOpenShiftItem sharedOpenShift;

    /*
     * openShift
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphOpenShift class.
     */
    public MicrosoftGraphOpenShift() {
    }

    /**
     * Get the draftOpenShift property: openShiftItem.
     * 
     * @return the draftOpenShift value.
     */
    public MicrosoftGraphOpenShiftItem draftOpenShift() {
        return this.draftOpenShift;
    }

    /**
     * Set the draftOpenShift property: openShiftItem.
     * 
     * @param draftOpenShift the draftOpenShift value to set.
     * @return the MicrosoftGraphOpenShift object itself.
     */
    public MicrosoftGraphOpenShift withDraftOpenShift(MicrosoftGraphOpenShiftItem draftOpenShift) {
        this.draftOpenShift = draftOpenShift;
        return this;
    }

    /**
     * Get the schedulingGroupId property: ID for the scheduling group that the open shift belongs to.
     * 
     * @return the schedulingGroupId value.
     */
    public String schedulingGroupId() {
        return this.schedulingGroupId;
    }

    /**
     * Set the schedulingGroupId property: ID for the scheduling group that the open shift belongs to.
     * 
     * @param schedulingGroupId the schedulingGroupId value to set.
     * @return the MicrosoftGraphOpenShift object itself.
     */
    public MicrosoftGraphOpenShift withSchedulingGroupId(String schedulingGroupId) {
        this.schedulingGroupId = schedulingGroupId;
        return this;
    }

    /**
     * Get the sharedOpenShift property: openShiftItem.
     * 
     * @return the sharedOpenShift value.
     */
    public MicrosoftGraphOpenShiftItem sharedOpenShift() {
        return this.sharedOpenShift;
    }

    /**
     * Set the sharedOpenShift property: openShiftItem.
     * 
     * @param sharedOpenShift the sharedOpenShift value to set.
     * @return the MicrosoftGraphOpenShift object itself.
     */
    public MicrosoftGraphOpenShift withSharedOpenShift(MicrosoftGraphOpenShiftItem sharedOpenShift) {
        this.sharedOpenShift = sharedOpenShift;
        return this;
    }

    /**
     * Get the additionalProperties property: openShift.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: openShift.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOpenShift object itself.
     */
    public MicrosoftGraphOpenShift withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOpenShift withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOpenShift withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOpenShift withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphOpenShift withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (draftOpenShift() != null) {
            draftOpenShift().validate();
        }
        if (sharedOpenShift() != null) {
            sharedOpenShift().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("createdDateTime",
            createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(createdDateTime()));
        jsonWriter.writeJsonField("lastModifiedBy", lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime",
            lastModifiedDateTime() == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(lastModifiedDateTime()));
        jsonWriter.writeJsonField("draftOpenShift", this.draftOpenShift);
        jsonWriter.writeStringField("schedulingGroupId", this.schedulingGroupId);
        jsonWriter.writeJsonField("sharedOpenShift", this.sharedOpenShift);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphOpenShift from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphOpenShift if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphOpenShift.
     */
    public static MicrosoftGraphOpenShift fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphOpenShift deserializedMicrosoftGraphOpenShift = new MicrosoftGraphOpenShift();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.withId(reader.getString());
                } else if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.withCreatedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                } else if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.withLastModifiedDateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("draftOpenShift".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.draftOpenShift = MicrosoftGraphOpenShiftItem.fromJson(reader);
                } else if ("schedulingGroupId".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.schedulingGroupId = reader.getString();
                } else if ("sharedOpenShift".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShift.sharedOpenShift = MicrosoftGraphOpenShiftItem.fromJson(reader);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphOpenShift.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphOpenShift;
        });
    }
}
