// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * scoredEmailAddress.
 */
@Fluent
public final class MicrosoftGraphScoredEmailAddress implements JsonSerializable<MicrosoftGraphScoredEmailAddress> {
    /*
     * The email address.
     */
    private String address;

    /*
     * The itemId property.
     */
    private String itemId;

    /*
     * The relevance score of the email address. A relevance score is used as a sort key, in relation to the other
     * returned results. A higher relevance score value corresponds to a more relevant result. Relevance is determined
     * by the user’s communication and collaboration patterns and business relationships.
     */
    private Double relevanceScore;

    /*
     * selectionLikelihoodInfo
     */
    private MicrosoftGraphSelectionLikelihoodInfo selectionLikelihood;

    /*
     * scoredEmailAddress
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphScoredEmailAddress class.
     */
    public MicrosoftGraphScoredEmailAddress() {
    }

    /**
     * Get the address property: The email address.
     * 
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Set the address property: The email address.
     * 
     * @param address the address value to set.
     * @return the MicrosoftGraphScoredEmailAddress object itself.
     */
    public MicrosoftGraphScoredEmailAddress withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Get the itemId property: The itemId property.
     * 
     * @return the itemId value.
     */
    public String itemId() {
        return this.itemId;
    }

    /**
     * Set the itemId property: The itemId property.
     * 
     * @param itemId the itemId value to set.
     * @return the MicrosoftGraphScoredEmailAddress object itself.
     */
    public MicrosoftGraphScoredEmailAddress withItemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    /**
     * Get the relevanceScore property: The relevance score of the email address. A relevance score is used as a sort
     * key, in relation to the other returned results. A higher relevance score value corresponds to a more relevant
     * result. Relevance is determined by the user’s communication and collaboration patterns and business
     * relationships.
     * 
     * @return the relevanceScore value.
     */
    public Double relevanceScore() {
        return this.relevanceScore;
    }

    /**
     * Set the relevanceScore property: The relevance score of the email address. A relevance score is used as a sort
     * key, in relation to the other returned results. A higher relevance score value corresponds to a more relevant
     * result. Relevance is determined by the user’s communication and collaboration patterns and business
     * relationships.
     * 
     * @param relevanceScore the relevanceScore value to set.
     * @return the MicrosoftGraphScoredEmailAddress object itself.
     */
    public MicrosoftGraphScoredEmailAddress withRelevanceScore(Double relevanceScore) {
        this.relevanceScore = relevanceScore;
        return this;
    }

    /**
     * Get the selectionLikelihood property: selectionLikelihoodInfo.
     * 
     * @return the selectionLikelihood value.
     */
    public MicrosoftGraphSelectionLikelihoodInfo selectionLikelihood() {
        return this.selectionLikelihood;
    }

    /**
     * Set the selectionLikelihood property: selectionLikelihoodInfo.
     * 
     * @param selectionLikelihood the selectionLikelihood value to set.
     * @return the MicrosoftGraphScoredEmailAddress object itself.
     */
    public MicrosoftGraphScoredEmailAddress
        withSelectionLikelihood(MicrosoftGraphSelectionLikelihoodInfo selectionLikelihood) {
        this.selectionLikelihood = selectionLikelihood;
        return this;
    }

    /**
     * Get the additionalProperties property: scoredEmailAddress.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: scoredEmailAddress.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphScoredEmailAddress object itself.
     */
    public MicrosoftGraphScoredEmailAddress withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeStringField("itemId", this.itemId);
        jsonWriter.writeNumberField("relevanceScore", this.relevanceScore);
        jsonWriter.writeStringField("selectionLikelihood",
            this.selectionLikelihood == null ? null : this.selectionLikelihood.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphScoredEmailAddress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphScoredEmailAddress if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphScoredEmailAddress.
     */
    public static MicrosoftGraphScoredEmailAddress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphScoredEmailAddress deserializedMicrosoftGraphScoredEmailAddress
                = new MicrosoftGraphScoredEmailAddress();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("address".equals(fieldName)) {
                    deserializedMicrosoftGraphScoredEmailAddress.address = reader.getString();
                } else if ("itemId".equals(fieldName)) {
                    deserializedMicrosoftGraphScoredEmailAddress.itemId = reader.getString();
                } else if ("relevanceScore".equals(fieldName)) {
                    deserializedMicrosoftGraphScoredEmailAddress.relevanceScore
                        = reader.getNullable(JsonReader::getDouble);
                } else if ("selectionLikelihood".equals(fieldName)) {
                    deserializedMicrosoftGraphScoredEmailAddress.selectionLikelihood
                        = MicrosoftGraphSelectionLikelihoodInfo.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphScoredEmailAddress.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphScoredEmailAddress;
        });
    }
}
