// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * sharepointIds.
 */
@Fluent
public final class MicrosoftGraphSharepointIds implements JsonSerializable<MicrosoftGraphSharepointIds> {
    /*
     * The unique identifier (guid) for the item's list in SharePoint.
     */
    private String listId;

    /*
     * An integer identifier for the item within the containing list.
     */
    private String listItemId;

    /*
     * The unique identifier (guid) for the item within OneDrive for Business or a SharePoint site.
     */
    private String listItemUniqueId;

    /*
     * The unique identifier (guid) for the item's site collection (SPSite).
     */
    private String siteId;

    /*
     * The SharePoint URL for the site that contains the item.
     */
    private String siteUrl;

    /*
     * The unique identifier (guid) for the tenancy.
     */
    private String tenantId;

    /*
     * The unique identifier (guid) for the item's site (SPWeb).
     */
    private String webId;

    /*
     * sharepointIds
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSharepointIds class.
     */
    public MicrosoftGraphSharepointIds() {
    }

    /**
     * Get the listId property: The unique identifier (guid) for the item's list in SharePoint.
     * 
     * @return the listId value.
     */
    public String listId() {
        return this.listId;
    }

    /**
     * Set the listId property: The unique identifier (guid) for the item's list in SharePoint.
     * 
     * @param listId the listId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withListId(String listId) {
        this.listId = listId;
        return this;
    }

    /**
     * Get the listItemId property: An integer identifier for the item within the containing list.
     * 
     * @return the listItemId value.
     */
    public String listItemId() {
        return this.listItemId;
    }

    /**
     * Set the listItemId property: An integer identifier for the item within the containing list.
     * 
     * @param listItemId the listItemId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withListItemId(String listItemId) {
        this.listItemId = listItemId;
        return this;
    }

    /**
     * Get the listItemUniqueId property: The unique identifier (guid) for the item within OneDrive for Business or a
     * SharePoint site.
     * 
     * @return the listItemUniqueId value.
     */
    public String listItemUniqueId() {
        return this.listItemUniqueId;
    }

    /**
     * Set the listItemUniqueId property: The unique identifier (guid) for the item within OneDrive for Business or a
     * SharePoint site.
     * 
     * @param listItemUniqueId the listItemUniqueId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withListItemUniqueId(String listItemUniqueId) {
        this.listItemUniqueId = listItemUniqueId;
        return this;
    }

    /**
     * Get the siteId property: The unique identifier (guid) for the item's site collection (SPSite).
     * 
     * @return the siteId value.
     */
    public String siteId() {
        return this.siteId;
    }

    /**
     * Set the siteId property: The unique identifier (guid) for the item's site collection (SPSite).
     * 
     * @param siteId the siteId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    /**
     * Get the siteUrl property: The SharePoint URL for the site that contains the item.
     * 
     * @return the siteUrl value.
     */
    public String siteUrl() {
        return this.siteUrl;
    }

    /**
     * Set the siteUrl property: The SharePoint URL for the site that contains the item.
     * 
     * @param siteUrl the siteUrl value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
        return this;
    }

    /**
     * Get the tenantId property: The unique identifier (guid) for the tenancy.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The unique identifier (guid) for the tenancy.
     * 
     * @param tenantId the tenantId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the webId property: The unique identifier (guid) for the item's site (SPWeb).
     * 
     * @return the webId value.
     */
    public String webId() {
        return this.webId;
    }

    /**
     * Set the webId property: The unique identifier (guid) for the item's site (SPWeb).
     * 
     * @param webId the webId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withWebId(String webId) {
        this.webId = webId;
        return this;
    }

    /**
     * Get the additionalProperties property: sharepointIds.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: sharepointIds.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("listId", this.listId);
        jsonWriter.writeStringField("listItemId", this.listItemId);
        jsonWriter.writeStringField("listItemUniqueId", this.listItemUniqueId);
        jsonWriter.writeStringField("siteId", this.siteId);
        jsonWriter.writeStringField("siteUrl", this.siteUrl);
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("webId", this.webId);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSharepointIds from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSharepointIds if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSharepointIds.
     */
    public static MicrosoftGraphSharepointIds fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSharepointIds deserializedMicrosoftGraphSharepointIds = new MicrosoftGraphSharepointIds();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("listId".equals(fieldName)) {
                    deserializedMicrosoftGraphSharepointIds.listId = reader.getString();
                } else if ("listItemId".equals(fieldName)) {
                    deserializedMicrosoftGraphSharepointIds.listItemId = reader.getString();
                } else if ("listItemUniqueId".equals(fieldName)) {
                    deserializedMicrosoftGraphSharepointIds.listItemUniqueId = reader.getString();
                } else if ("siteId".equals(fieldName)) {
                    deserializedMicrosoftGraphSharepointIds.siteId = reader.getString();
                } else if ("siteUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphSharepointIds.siteUrl = reader.getString();
                } else if ("tenantId".equals(fieldName)) {
                    deserializedMicrosoftGraphSharepointIds.tenantId = reader.getString();
                } else if ("webId".equals(fieldName)) {
                    deserializedMicrosoftGraphSharepointIds.webId = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSharepointIds.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSharepointIds;
        });
    }
}
