// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * siteCollection.
 */
@Fluent
public final class MicrosoftGraphSiteCollection implements JsonSerializable<MicrosoftGraphSiteCollection> {
    /*
     * The geographic region code for where this site collection resides. Read-only.
     */
    private String dataLocationCode;

    /*
     * The hostname for the site collection. Read-only.
     */
    private String hostname;

    /*
     * root
     */
    private Map<String, Object> root;

    /*
     * siteCollection
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphSiteCollection class.
     */
    public MicrosoftGraphSiteCollection() {
    }

    /**
     * Get the dataLocationCode property: The geographic region code for where this site collection resides. Read-only.
     * 
     * @return the dataLocationCode value.
     */
    public String dataLocationCode() {
        return this.dataLocationCode;
    }

    /**
     * Set the dataLocationCode property: The geographic region code for where this site collection resides. Read-only.
     * 
     * @param dataLocationCode the dataLocationCode value to set.
     * @return the MicrosoftGraphSiteCollection object itself.
     */
    public MicrosoftGraphSiteCollection withDataLocationCode(String dataLocationCode) {
        this.dataLocationCode = dataLocationCode;
        return this;
    }

    /**
     * Get the hostname property: The hostname for the site collection. Read-only.
     * 
     * @return the hostname value.
     */
    public String hostname() {
        return this.hostname;
    }

    /**
     * Set the hostname property: The hostname for the site collection. Read-only.
     * 
     * @param hostname the hostname value to set.
     * @return the MicrosoftGraphSiteCollection object itself.
     */
    public MicrosoftGraphSiteCollection withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    /**
     * Get the root property: root.
     * 
     * @return the root value.
     */
    public Map<String, Object> root() {
        return this.root;
    }

    /**
     * Set the root property: root.
     * 
     * @param root the root value to set.
     * @return the MicrosoftGraphSiteCollection object itself.
     */
    public MicrosoftGraphSiteCollection withRoot(Map<String, Object> root) {
        this.root = root;
        return this;
    }

    /**
     * Get the additionalProperties property: siteCollection.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: siteCollection.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSiteCollection object itself.
     */
    public MicrosoftGraphSiteCollection withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataLocationCode", this.dataLocationCode);
        jsonWriter.writeStringField("hostname", this.hostname);
        jsonWriter.writeMapField("root", this.root, (writer, element) -> writer.writeUntyped(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphSiteCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphSiteCollection if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphSiteCollection.
     */
    public static MicrosoftGraphSiteCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphSiteCollection deserializedMicrosoftGraphSiteCollection = new MicrosoftGraphSiteCollection();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dataLocationCode".equals(fieldName)) {
                    deserializedMicrosoftGraphSiteCollection.dataLocationCode = reader.getString();
                } else if ("hostname".equals(fieldName)) {
                    deserializedMicrosoftGraphSiteCollection.hostname = reader.getString();
                } else if ("root".equals(fieldName)) {
                    Map<String, Object> root = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphSiteCollection.root = root;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphSiteCollection.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphSiteCollection;
        });
    }
}
