// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * teamMemberSettings.
 */
@Fluent
public final class MicrosoftGraphTeamMemberSettings implements JsonSerializable<MicrosoftGraphTeamMemberSettings> {
    /*
     * If set to true, members can add and remove apps.
     */
    private Boolean allowAddRemoveApps;

    /*
     * If set to true, members can add and update private channels.
     */
    private Boolean allowCreatePrivateChannels;

    /*
     * If set to true, members can add and update channels.
     */
    private Boolean allowCreateUpdateChannels;

    /*
     * If set to true, members can add, update, and remove connectors.
     */
    private Boolean allowCreateUpdateRemoveConnectors;

    /*
     * If set to true, members can add, update, and remove tabs.
     */
    private Boolean allowCreateUpdateRemoveTabs;

    /*
     * If set to true, members can delete channels.
     */
    private Boolean allowDeleteChannels;

    /*
     * teamMemberSettings
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTeamMemberSettings class.
     */
    public MicrosoftGraphTeamMemberSettings() {
    }

    /**
     * Get the allowAddRemoveApps property: If set to true, members can add and remove apps.
     * 
     * @return the allowAddRemoveApps value.
     */
    public Boolean allowAddRemoveApps() {
        return this.allowAddRemoveApps;
    }

    /**
     * Set the allowAddRemoveApps property: If set to true, members can add and remove apps.
     * 
     * @param allowAddRemoveApps the allowAddRemoveApps value to set.
     * @return the MicrosoftGraphTeamMemberSettings object itself.
     */
    public MicrosoftGraphTeamMemberSettings withAllowAddRemoveApps(Boolean allowAddRemoveApps) {
        this.allowAddRemoveApps = allowAddRemoveApps;
        return this;
    }

    /**
     * Get the allowCreatePrivateChannels property: If set to true, members can add and update private channels.
     * 
     * @return the allowCreatePrivateChannels value.
     */
    public Boolean allowCreatePrivateChannels() {
        return this.allowCreatePrivateChannels;
    }

    /**
     * Set the allowCreatePrivateChannels property: If set to true, members can add and update private channels.
     * 
     * @param allowCreatePrivateChannels the allowCreatePrivateChannels value to set.
     * @return the MicrosoftGraphTeamMemberSettings object itself.
     */
    public MicrosoftGraphTeamMemberSettings withAllowCreatePrivateChannels(Boolean allowCreatePrivateChannels) {
        this.allowCreatePrivateChannels = allowCreatePrivateChannels;
        return this;
    }

    /**
     * Get the allowCreateUpdateChannels property: If set to true, members can add and update channels.
     * 
     * @return the allowCreateUpdateChannels value.
     */
    public Boolean allowCreateUpdateChannels() {
        return this.allowCreateUpdateChannels;
    }

    /**
     * Set the allowCreateUpdateChannels property: If set to true, members can add and update channels.
     * 
     * @param allowCreateUpdateChannels the allowCreateUpdateChannels value to set.
     * @return the MicrosoftGraphTeamMemberSettings object itself.
     */
    public MicrosoftGraphTeamMemberSettings withAllowCreateUpdateChannels(Boolean allowCreateUpdateChannels) {
        this.allowCreateUpdateChannels = allowCreateUpdateChannels;
        return this;
    }

    /**
     * Get the allowCreateUpdateRemoveConnectors property: If set to true, members can add, update, and remove
     * connectors.
     * 
     * @return the allowCreateUpdateRemoveConnectors value.
     */
    public Boolean allowCreateUpdateRemoveConnectors() {
        return this.allowCreateUpdateRemoveConnectors;
    }

    /**
     * Set the allowCreateUpdateRemoveConnectors property: If set to true, members can add, update, and remove
     * connectors.
     * 
     * @param allowCreateUpdateRemoveConnectors the allowCreateUpdateRemoveConnectors value to set.
     * @return the MicrosoftGraphTeamMemberSettings object itself.
     */
    public MicrosoftGraphTeamMemberSettings
        withAllowCreateUpdateRemoveConnectors(Boolean allowCreateUpdateRemoveConnectors) {
        this.allowCreateUpdateRemoveConnectors = allowCreateUpdateRemoveConnectors;
        return this;
    }

    /**
     * Get the allowCreateUpdateRemoveTabs property: If set to true, members can add, update, and remove tabs.
     * 
     * @return the allowCreateUpdateRemoveTabs value.
     */
    public Boolean allowCreateUpdateRemoveTabs() {
        return this.allowCreateUpdateRemoveTabs;
    }

    /**
     * Set the allowCreateUpdateRemoveTabs property: If set to true, members can add, update, and remove tabs.
     * 
     * @param allowCreateUpdateRemoveTabs the allowCreateUpdateRemoveTabs value to set.
     * @return the MicrosoftGraphTeamMemberSettings object itself.
     */
    public MicrosoftGraphTeamMemberSettings withAllowCreateUpdateRemoveTabs(Boolean allowCreateUpdateRemoveTabs) {
        this.allowCreateUpdateRemoveTabs = allowCreateUpdateRemoveTabs;
        return this;
    }

    /**
     * Get the allowDeleteChannels property: If set to true, members can delete channels.
     * 
     * @return the allowDeleteChannels value.
     */
    public Boolean allowDeleteChannels() {
        return this.allowDeleteChannels;
    }

    /**
     * Set the allowDeleteChannels property: If set to true, members can delete channels.
     * 
     * @param allowDeleteChannels the allowDeleteChannels value to set.
     * @return the MicrosoftGraphTeamMemberSettings object itself.
     */
    public MicrosoftGraphTeamMemberSettings withAllowDeleteChannels(Boolean allowDeleteChannels) {
        this.allowDeleteChannels = allowDeleteChannels;
        return this;
    }

    /**
     * Get the additionalProperties property: teamMemberSettings.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: teamMemberSettings.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTeamMemberSettings object itself.
     */
    public MicrosoftGraphTeamMemberSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("allowAddRemoveApps", this.allowAddRemoveApps);
        jsonWriter.writeBooleanField("allowCreatePrivateChannels", this.allowCreatePrivateChannels);
        jsonWriter.writeBooleanField("allowCreateUpdateChannels", this.allowCreateUpdateChannels);
        jsonWriter.writeBooleanField("allowCreateUpdateRemoveConnectors", this.allowCreateUpdateRemoveConnectors);
        jsonWriter.writeBooleanField("allowCreateUpdateRemoveTabs", this.allowCreateUpdateRemoveTabs);
        jsonWriter.writeBooleanField("allowDeleteChannels", this.allowDeleteChannels);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTeamMemberSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTeamMemberSettings if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTeamMemberSettings.
     */
    public static MicrosoftGraphTeamMemberSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTeamMemberSettings deserializedMicrosoftGraphTeamMemberSettings
                = new MicrosoftGraphTeamMemberSettings();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowAddRemoveApps".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamMemberSettings.allowAddRemoveApps
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowCreatePrivateChannels".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamMemberSettings.allowCreatePrivateChannels
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowCreateUpdateChannels".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamMemberSettings.allowCreateUpdateChannels
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowCreateUpdateRemoveConnectors".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamMemberSettings.allowCreateUpdateRemoveConnectors
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowCreateUpdateRemoveTabs".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamMemberSettings.allowCreateUpdateRemoveTabs
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowDeleteChannels".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamMemberSettings.allowDeleteChannels
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTeamMemberSettings.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTeamMemberSettings;
        });
    }
}
