// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * teamsApp.
 */
@Fluent
public final class MicrosoftGraphTeamsApp extends MicrosoftGraphEntity {
    /*
     * The name of the catalog app provided by the app developer in the Microsoft Teams zip app package.
     */
    private String displayName;

    /*
     * teamsAppDistributionMethod
     */
    private MicrosoftGraphTeamsAppDistributionMethod distributionMethod;

    /*
     * The ID of the catalog provided by the app developer in the Microsoft Teams zip app package.
     */
    private String externalId;

    /*
     * The details for each version of the app.
     */
    private List<MicrosoftGraphTeamsAppDefinition> appDefinitions;

    /*
     * teamsApp
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTeamsApp class.
     */
    public MicrosoftGraphTeamsApp() {
    }

    /**
     * Get the displayName property: The name of the catalog app provided by the app developer in the Microsoft Teams
     * zip app package.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The name of the catalog app provided by the app developer in the Microsoft Teams
     * zip app package.
     * 
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphTeamsApp object itself.
     */
    public MicrosoftGraphTeamsApp withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the distributionMethod property: teamsAppDistributionMethod.
     * 
     * @return the distributionMethod value.
     */
    public MicrosoftGraphTeamsAppDistributionMethod distributionMethod() {
        return this.distributionMethod;
    }

    /**
     * Set the distributionMethod property: teamsAppDistributionMethod.
     * 
     * @param distributionMethod the distributionMethod value to set.
     * @return the MicrosoftGraphTeamsApp object itself.
     */
    public MicrosoftGraphTeamsApp withDistributionMethod(MicrosoftGraphTeamsAppDistributionMethod distributionMethod) {
        this.distributionMethod = distributionMethod;
        return this;
    }

    /**
     * Get the externalId property: The ID of the catalog provided by the app developer in the Microsoft Teams zip app
     * package.
     * 
     * @return the externalId value.
     */
    public String externalId() {
        return this.externalId;
    }

    /**
     * Set the externalId property: The ID of the catalog provided by the app developer in the Microsoft Teams zip app
     * package.
     * 
     * @param externalId the externalId value to set.
     * @return the MicrosoftGraphTeamsApp object itself.
     */
    public MicrosoftGraphTeamsApp withExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    /**
     * Get the appDefinitions property: The details for each version of the app.
     * 
     * @return the appDefinitions value.
     */
    public List<MicrosoftGraphTeamsAppDefinition> appDefinitions() {
        return this.appDefinitions;
    }

    /**
     * Set the appDefinitions property: The details for each version of the app.
     * 
     * @param appDefinitions the appDefinitions value to set.
     * @return the MicrosoftGraphTeamsApp object itself.
     */
    public MicrosoftGraphTeamsApp withAppDefinitions(List<MicrosoftGraphTeamsAppDefinition> appDefinitions) {
        this.appDefinitions = appDefinitions;
        return this;
    }

    /**
     * Get the additionalProperties property: teamsApp.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: teamsApp.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTeamsApp object itself.
     */
    public MicrosoftGraphTeamsApp withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MicrosoftGraphTeamsApp withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (appDefinitions() != null) {
            appDefinitions().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("distributionMethod",
            this.distributionMethod == null ? null : this.distributionMethod.toString());
        jsonWriter.writeStringField("externalId", this.externalId);
        jsonWriter.writeArrayField("appDefinitions", this.appDefinitions,
            (writer, element) -> writer.writeJson(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTeamsApp from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTeamsApp if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTeamsApp.
     */
    public static MicrosoftGraphTeamsApp fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTeamsApp deserializedMicrosoftGraphTeamsApp = new MicrosoftGraphTeamsApp();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsApp.withId(reader.getString());
                } else if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsApp.displayName = reader.getString();
                } else if ("distributionMethod".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsApp.distributionMethod
                        = MicrosoftGraphTeamsAppDistributionMethod.fromString(reader.getString());
                } else if ("externalId".equals(fieldName)) {
                    deserializedMicrosoftGraphTeamsApp.externalId = reader.getString();
                } else if ("appDefinitions".equals(fieldName)) {
                    List<MicrosoftGraphTeamsAppDefinition> appDefinitions
                        = reader.readArray(reader1 -> MicrosoftGraphTeamsAppDefinition.fromJson(reader1));
                    deserializedMicrosoftGraphTeamsApp.appDefinitions = appDefinitions;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTeamsApp.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTeamsApp;
        });
    }
}
