// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * timeRange.
 */
@Fluent
public final class MicrosoftGraphTimeRange implements JsonSerializable<MicrosoftGraphTimeRange> {
    /*
     * End time for the time range.
     */
    private String endTime;

    /*
     * Start time for the time range.
     */
    private String startTime;

    /*
     * timeRange
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphTimeRange class.
     */
    public MicrosoftGraphTimeRange() {
    }

    /**
     * Get the endTime property: End time for the time range.
     * 
     * @return the endTime value.
     */
    public String endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: End time for the time range.
     * 
     * @param endTime the endTime value to set.
     * @return the MicrosoftGraphTimeRange object itself.
     */
    public MicrosoftGraphTimeRange withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the startTime property: Start time for the time range.
     * 
     * @return the startTime value.
     */
    public String startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: Start time for the time range.
     * 
     * @param startTime the startTime value to set.
     * @return the MicrosoftGraphTimeRange object itself.
     */
    public MicrosoftGraphTimeRange withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the additionalProperties property: timeRange.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: timeRange.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTimeRange object itself.
     */
    public MicrosoftGraphTimeRange withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endTime", this.endTime);
        jsonWriter.writeStringField("startTime", this.startTime);
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphTimeRange from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphTimeRange if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphTimeRange.
     */
    public static MicrosoftGraphTimeRange fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphTimeRange deserializedMicrosoftGraphTimeRange = new MicrosoftGraphTimeRange();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("endTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeRange.endTime = reader.getString();
                } else if ("startTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTimeRange.startTime = reader.getString();
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphTimeRange.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphTimeRange;
        });
    }
}
