/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphImageInfo;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphVisualInfo
implements JsonSerializable<MicrosoftGraphVisualInfo> {
    private MicrosoftGraphImageInfo attribution;
    private String backgroundColor;
    private Map<String, Object> content;
    private String description;
    private String displayText;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphImageInfo attribution() {
        return this.attribution;
    }

    public MicrosoftGraphVisualInfo withAttribution(MicrosoftGraphImageInfo attribution) {
        this.attribution = attribution;
        return this;
    }

    public String backgroundColor() {
        return this.backgroundColor;
    }

    public MicrosoftGraphVisualInfo withBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public Map<String, Object> content() {
        return this.content;
    }

    public MicrosoftGraphVisualInfo withContent(Map<String, Object> content) {
        this.content = content;
        return this;
    }

    public String description() {
        return this.description;
    }

    public MicrosoftGraphVisualInfo withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayText() {
        return this.displayText;
    }

    public MicrosoftGraphVisualInfo withDisplayText(String displayText) {
        this.displayText = displayText;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphVisualInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.attribution() != null) {
            this.attribution().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("attribution", (JsonSerializable)this.attribution);
        jsonWriter.writeStringField("backgroundColor", this.backgroundColor);
        jsonWriter.writeMapField("content", this.content, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayText", this.displayText);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphVisualInfo fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphVisualInfo)jsonReader.readObject(reader -> {
            MicrosoftGraphVisualInfo deserializedMicrosoftGraphVisualInfo = new MicrosoftGraphVisualInfo();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("attribution".equals(fieldName)) {
                    deserializedMicrosoftGraphVisualInfo.attribution = MicrosoftGraphImageInfo.fromJson(reader);
                    continue;
                }
                if ("backgroundColor".equals(fieldName)) {
                    deserializedMicrosoftGraphVisualInfo.backgroundColor = reader.getString();
                    continue;
                }
                if ("content".equals(fieldName)) {
                    Map content;
                    deserializedMicrosoftGraphVisualInfo.content = content = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphVisualInfo.description = reader.getString();
                    continue;
                }
                if ("displayText".equals(fieldName)) {
                    deserializedMicrosoftGraphVisualInfo.displayText = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphVisualInfo.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphVisualInfo;
        });
    }
}

