/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphWorkbookCommentReply;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphWorkbookComment
extends MicrosoftGraphEntity {
    private String content;
    private String contentType;
    private List<MicrosoftGraphWorkbookCommentReply> replies;
    private Map<String, Object> additionalProperties;

    public String content() {
        return this.content;
    }

    public MicrosoftGraphWorkbookComment withContent(String content) {
        this.content = content;
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public MicrosoftGraphWorkbookComment withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public List<MicrosoftGraphWorkbookCommentReply> replies() {
        return this.replies;
    }

    public MicrosoftGraphWorkbookComment withReplies(List<MicrosoftGraphWorkbookCommentReply> replies) {
        this.replies = replies;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphWorkbookComment withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphWorkbookComment withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.replies() != null) {
            this.replies().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeArrayField("replies", this.replies, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphWorkbookComment fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphWorkbookComment)jsonReader.readObject(reader -> {
            MicrosoftGraphWorkbookComment deserializedMicrosoftGraphWorkbookComment = new MicrosoftGraphWorkbookComment();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookComment.withId(reader.getString());
                    continue;
                }
                if ("content".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookComment.content = reader.getString();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedMicrosoftGraphWorkbookComment.contentType = reader.getString();
                    continue;
                }
                if ("replies".equals(fieldName)) {
                    List replies;
                    deserializedMicrosoftGraphWorkbookComment.replies = replies = reader.readArray(reader1 -> MicrosoftGraphWorkbookCommentReply.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphWorkbookComment.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphWorkbookComment;
        });
    }
}

