/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyApprovalRule;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyAuthenticationContextRule;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyEnablementRule;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyExpirationRule;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyNotificationRule;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRuleTarget;
import com.azure.resourcemanager.authorization.models.RoleManagementPolicyRuleType;
import java.io.IOException;

public class RoleManagementPolicyRule
implements JsonSerializable<RoleManagementPolicyRule> {
    private RoleManagementPolicyRuleType ruleType = RoleManagementPolicyRuleType.fromString("RoleManagementPolicyRule");
    private String id;
    private RoleManagementPolicyRuleTarget target;

    public RoleManagementPolicyRuleType ruleType() {
        return this.ruleType;
    }

    public String id() {
        return this.id;
    }

    public RoleManagementPolicyRule withId(String id) {
        this.id = id;
        return this;
    }

    public RoleManagementPolicyRuleTarget target() {
        return this.target;
    }

    public RoleManagementPolicyRule withTarget(RoleManagementPolicyRuleTarget target) {
        this.target = target;
        return this;
    }

    public void validate() {
        if (this.target() != null) {
            this.target().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleType", this.ruleType == null ? null : this.ruleType.toString());
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("target", (JsonSerializable)this.target);
        return jsonWriter.writeEndObject();
    }

    public static RoleManagementPolicyRule fromJson(JsonReader jsonReader) throws IOException {
        return (RoleManagementPolicyRule)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                RoleManagementPolicyRule roleManagementPolicyRule;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("ruleType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("RoleManagementPolicyApprovalRule".equals(discriminatorValue)) {
                    roleManagementPolicyRule = RoleManagementPolicyApprovalRule.fromJson(readerToUse.reset());
                    return roleManagementPolicyRule;
                }
                if ("RoleManagementPolicyAuthenticationContextRule".equals(discriminatorValue)) {
                    roleManagementPolicyRule = RoleManagementPolicyAuthenticationContextRule.fromJson(readerToUse.reset());
                    return roleManagementPolicyRule;
                }
                if ("RoleManagementPolicyEnablementRule".equals(discriminatorValue)) {
                    roleManagementPolicyRule = RoleManagementPolicyEnablementRule.fromJson(readerToUse.reset());
                    return roleManagementPolicyRule;
                }
                if ("RoleManagementPolicyExpirationRule".equals(discriminatorValue)) {
                    roleManagementPolicyRule = RoleManagementPolicyExpirationRule.fromJson(readerToUse.reset());
                    return roleManagementPolicyRule;
                }
                if ("RoleManagementPolicyNotificationRule".equals(discriminatorValue)) {
                    roleManagementPolicyRule = RoleManagementPolicyNotificationRule.fromJson(readerToUse.reset());
                    return roleManagementPolicyRule;
                }
                roleManagementPolicyRule = RoleManagementPolicyRule.fromJsonKnownDiscriminator(readerToUse.reset());
                return roleManagementPolicyRule;
            }
        });
    }

    static RoleManagementPolicyRule fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (RoleManagementPolicyRule)jsonReader.readObject(reader -> {
            RoleManagementPolicyRule deserializedRoleManagementPolicyRule = new RoleManagementPolicyRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleType".equals(fieldName)) {
                    deserializedRoleManagementPolicyRule.ruleType = RoleManagementPolicyRuleType.fromString(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRoleManagementPolicyRule.id = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedRoleManagementPolicyRule.target = RoleManagementPolicyRuleTarget.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleManagementPolicyRule;
        });
    }
}

