// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * The ApplicationsCheckMemberObjectsRequestBody model.
 */
@Fluent
public final class ApplicationsCheckMemberObjectsRequestBody
    implements JsonSerializable<ApplicationsCheckMemberObjectsRequestBody> {
    /*
     * The ids property.
     */
    private List<String> ids;

    /*
     * Dictionary of <AnyObject>
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of ApplicationsCheckMemberObjectsRequestBody class.
     */
    public ApplicationsCheckMemberObjectsRequestBody() {
    }

    /**
     * Get the ids property: The ids property.
     * 
     * @return the ids value.
     */
    public List<String> ids() {
        return this.ids;
    }

    /**
     * Set the ids property: The ids property.
     * 
     * @param ids the ids value to set.
     * @return the ApplicationsCheckMemberObjectsRequestBody object itself.
     */
    public ApplicationsCheckMemberObjectsRequestBody withIds(List<String> ids) {
        this.ids = ids;
        return this;
    }

    /**
     * Get the additionalProperties property: Dictionary of &lt;AnyObject&gt;.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Dictionary of &lt;AnyObject&gt;.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the ApplicationsCheckMemberObjectsRequestBody object itself.
     */
    public ApplicationsCheckMemberObjectsRequestBody
        withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ids", this.ids, (writer, element) -> writer.writeString(element));
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationsCheckMemberObjectsRequestBody from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationsCheckMemberObjectsRequestBody if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationsCheckMemberObjectsRequestBody.
     */
    public static ApplicationsCheckMemberObjectsRequestBody fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationsCheckMemberObjectsRequestBody deserializedApplicationsCheckMemberObjectsRequestBody
                = new ApplicationsCheckMemberObjectsRequestBody();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ids".equals(fieldName)) {
                    List<String> ids = reader.readArray(reader1 -> reader1.getString());
                    deserializedApplicationsCheckMemberObjectsRequestBody.ids = ids;
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedApplicationsCheckMemberObjectsRequestBody.additionalProperties = additionalProperties;

            return deserializedApplicationsCheckMemberObjectsRequestBody;
        });
    }
}
