// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * automaticRepliesSetting.
 */
@Fluent
public final class MicrosoftGraphAutomaticRepliesSetting
    implements JsonSerializable<MicrosoftGraphAutomaticRepliesSetting> {
    /*
     * externalAudienceScope
     */
    private MicrosoftGraphExternalAudienceScope externalAudience;

    /*
     * The automatic reply to send to the specified external audience, if Status is AlwaysEnabled or Scheduled.
     */
    private String externalReplyMessage;

    /*
     * The automatic reply to send to the audience internal to the signed-in user's organization, if Status is
     * AlwaysEnabled or Scheduled.
     */
    private String internalReplyMessage;

    /*
     * dateTimeTimeZone
     */
    private MicrosoftGraphDateTimeZone scheduledEndDateTime;

    /*
     * dateTimeTimeZone
     */
    private MicrosoftGraphDateTimeZone scheduledStartDateTime;

    /*
     * automaticRepliesStatus
     */
    private MicrosoftGraphAutomaticRepliesStatus status;

    /*
     * automaticRepliesSetting
     */
    private Map<String, Object> additionalProperties;

    /**
     * Creates an instance of MicrosoftGraphAutomaticRepliesSetting class.
     */
    public MicrosoftGraphAutomaticRepliesSetting() {
    }

    /**
     * Get the externalAudience property: externalAudienceScope.
     * 
     * @return the externalAudience value.
     */
    public MicrosoftGraphExternalAudienceScope externalAudience() {
        return this.externalAudience;
    }

    /**
     * Set the externalAudience property: externalAudienceScope.
     * 
     * @param externalAudience the externalAudience value to set.
     * @return the MicrosoftGraphAutomaticRepliesSetting object itself.
     */
    public MicrosoftGraphAutomaticRepliesSetting
        withExternalAudience(MicrosoftGraphExternalAudienceScope externalAudience) {
        this.externalAudience = externalAudience;
        return this;
    }

    /**
     * Get the externalReplyMessage property: The automatic reply to send to the specified external audience, if Status
     * is AlwaysEnabled or Scheduled.
     * 
     * @return the externalReplyMessage value.
     */
    public String externalReplyMessage() {
        return this.externalReplyMessage;
    }

    /**
     * Set the externalReplyMessage property: The automatic reply to send to the specified external audience, if Status
     * is AlwaysEnabled or Scheduled.
     * 
     * @param externalReplyMessage the externalReplyMessage value to set.
     * @return the MicrosoftGraphAutomaticRepliesSetting object itself.
     */
    public MicrosoftGraphAutomaticRepliesSetting withExternalReplyMessage(String externalReplyMessage) {
        this.externalReplyMessage = externalReplyMessage;
        return this;
    }

    /**
     * Get the internalReplyMessage property: The automatic reply to send to the audience internal to the signed-in
     * user's organization, if Status is AlwaysEnabled or Scheduled.
     * 
     * @return the internalReplyMessage value.
     */
    public String internalReplyMessage() {
        return this.internalReplyMessage;
    }

    /**
     * Set the internalReplyMessage property: The automatic reply to send to the audience internal to the signed-in
     * user's organization, if Status is AlwaysEnabled or Scheduled.
     * 
     * @param internalReplyMessage the internalReplyMessage value to set.
     * @return the MicrosoftGraphAutomaticRepliesSetting object itself.
     */
    public MicrosoftGraphAutomaticRepliesSetting withInternalReplyMessage(String internalReplyMessage) {
        this.internalReplyMessage = internalReplyMessage;
        return this;
    }

    /**
     * Get the scheduledEndDateTime property: dateTimeTimeZone.
     * 
     * @return the scheduledEndDateTime value.
     */
    public MicrosoftGraphDateTimeZone scheduledEndDateTime() {
        return this.scheduledEndDateTime;
    }

    /**
     * Set the scheduledEndDateTime property: dateTimeTimeZone.
     * 
     * @param scheduledEndDateTime the scheduledEndDateTime value to set.
     * @return the MicrosoftGraphAutomaticRepliesSetting object itself.
     */
    public MicrosoftGraphAutomaticRepliesSetting
        withScheduledEndDateTime(MicrosoftGraphDateTimeZone scheduledEndDateTime) {
        this.scheduledEndDateTime = scheduledEndDateTime;
        return this;
    }

    /**
     * Get the scheduledStartDateTime property: dateTimeTimeZone.
     * 
     * @return the scheduledStartDateTime value.
     */
    public MicrosoftGraphDateTimeZone scheduledStartDateTime() {
        return this.scheduledStartDateTime;
    }

    /**
     * Set the scheduledStartDateTime property: dateTimeTimeZone.
     * 
     * @param scheduledStartDateTime the scheduledStartDateTime value to set.
     * @return the MicrosoftGraphAutomaticRepliesSetting object itself.
     */
    public MicrosoftGraphAutomaticRepliesSetting
        withScheduledStartDateTime(MicrosoftGraphDateTimeZone scheduledStartDateTime) {
        this.scheduledStartDateTime = scheduledStartDateTime;
        return this;
    }

    /**
     * Get the status property: automaticRepliesStatus.
     * 
     * @return the status value.
     */
    public MicrosoftGraphAutomaticRepliesStatus status() {
        return this.status;
    }

    /**
     * Set the status property: automaticRepliesStatus.
     * 
     * @param status the status value to set.
     * @return the MicrosoftGraphAutomaticRepliesSetting object itself.
     */
    public MicrosoftGraphAutomaticRepliesSetting withStatus(MicrosoftGraphAutomaticRepliesStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the additionalProperties property: automaticRepliesSetting.
     * 
     * @return the additionalProperties value.
     */
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: automaticRepliesSetting.
     * 
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAutomaticRepliesSetting object itself.
     */
    public MicrosoftGraphAutomaticRepliesSetting withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scheduledEndDateTime() != null) {
            scheduledEndDateTime().validate();
        }
        if (scheduledStartDateTime() != null) {
            scheduledStartDateTime().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("externalAudience",
            this.externalAudience == null ? null : this.externalAudience.toString());
        jsonWriter.writeStringField("externalReplyMessage", this.externalReplyMessage);
        jsonWriter.writeStringField("internalReplyMessage", this.internalReplyMessage);
        jsonWriter.writeJsonField("scheduledEndDateTime", this.scheduledEndDateTime);
        jsonWriter.writeJsonField("scheduledStartDateTime", this.scheduledStartDateTime);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MicrosoftGraphAutomaticRepliesSetting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MicrosoftGraphAutomaticRepliesSetting if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MicrosoftGraphAutomaticRepliesSetting.
     */
    public static MicrosoftGraphAutomaticRepliesSetting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphAutomaticRepliesSetting deserializedMicrosoftGraphAutomaticRepliesSetting
                = new MicrosoftGraphAutomaticRepliesSetting();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("externalAudience".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.externalAudience
                        = MicrosoftGraphExternalAudienceScope.fromString(reader.getString());
                } else if ("externalReplyMessage".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.externalReplyMessage = reader.getString();
                } else if ("internalReplyMessage".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.internalReplyMessage = reader.getString();
                } else if ("scheduledEndDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.scheduledEndDateTime
                        = MicrosoftGraphDateTimeZone.fromJson(reader);
                } else if ("scheduledStartDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.scheduledStartDateTime
                        = MicrosoftGraphDateTimeZone.fromJson(reader);
                } else if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphAutomaticRepliesSetting.status
                        = MicrosoftGraphAutomaticRepliesStatus.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedMicrosoftGraphAutomaticRepliesSetting.additionalProperties = additionalProperties;

            return deserializedMicrosoftGraphAutomaticRepliesSetting;
        });
    }
}
