// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.ProviderOperation;
import com.azure.resourcemanager.authorization.models.ResourceType;
import java.io.IOException;
import java.util.List;

/**
 * Provider Operations metadata.
 */
@Fluent
public final class ProviderOperationsMetadataInner implements JsonSerializable<ProviderOperationsMetadataInner> {
    /*
     * The provider id.
     */
    private String id;

    /*
     * The provider name.
     */
    private String name;

    /*
     * The provider type.
     */
    private String type;

    /*
     * The provider display name.
     */
    private String displayName;

    /*
     * The provider resource types
     */
    private List<ResourceType> resourceTypes;

    /*
     * The provider operations.
     */
    private List<ProviderOperation> operations;

    /**
     * Creates an instance of ProviderOperationsMetadataInner class.
     */
    public ProviderOperationsMetadataInner() {
    }

    /**
     * Get the id property: The provider id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The provider id.
     * 
     * @param id the id value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The provider name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The provider name.
     * 
     * @param name the name value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The provider type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The provider type.
     * 
     * @param type the type value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the displayName property: The provider display name.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The provider display name.
     * 
     * @param displayName the displayName value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the resourceTypes property: The provider resource types.
     * 
     * @return the resourceTypes value.
     */
    public List<ResourceType> resourceTypes() {
        return this.resourceTypes;
    }

    /**
     * Set the resourceTypes property: The provider resource types.
     * 
     * @param resourceTypes the resourceTypes value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withResourceTypes(List<ResourceType> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    /**
     * Get the operations property: The provider operations.
     * 
     * @return the operations value.
     */
    public List<ProviderOperation> operations() {
        return this.operations;
    }

    /**
     * Set the operations property: The provider operations.
     * 
     * @param operations the operations value to set.
     * @return the ProviderOperationsMetadataInner object itself.
     */
    public ProviderOperationsMetadataInner withOperations(List<ProviderOperation> operations) {
        this.operations = operations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceTypes() != null) {
            resourceTypes().forEach(e -> e.validate());
        }
        if (operations() != null) {
            operations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeArrayField("resourceTypes", this.resourceTypes, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProviderOperationsMetadataInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProviderOperationsMetadataInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProviderOperationsMetadataInner.
     */
    public static ProviderOperationsMetadataInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProviderOperationsMetadataInner deserializedProviderOperationsMetadataInner
                = new ProviderOperationsMetadataInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedProviderOperationsMetadataInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedProviderOperationsMetadataInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedProviderOperationsMetadataInner.type = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedProviderOperationsMetadataInner.displayName = reader.getString();
                } else if ("resourceTypes".equals(fieldName)) {
                    List<ResourceType> resourceTypes = reader.readArray(reader1 -> ResourceType.fromJson(reader1));
                    deserializedProviderOperationsMetadataInner.resourceTypes = resourceTypes;
                } else if ("operations".equals(fieldName)) {
                    List<ProviderOperation> operations
                        = reader.readArray(reader1 -> ProviderOperation.fromJson(reader1));
                    deserializedProviderOperationsMetadataInner.operations = operations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProviderOperationsMetadataInner;
        });
    }
}
