// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryExpand;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectorySelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAdministrativeUnitInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DirectoriesClient. */
public interface DirectoriesClient {
    /**
     * Get administrativeUnits from directory.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return administrativeUnits from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphAdministrativeUnitInner> listAdministrativeUnitsAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryOrderby> orderby,
        List<DirectorySelect> select,
        List<DirectoryExpand> expand);

    /**
     * Get administrativeUnits from directory.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return administrativeUnits from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphAdministrativeUnitInner> listAdministrativeUnitsAsync();

    /**
     * Get administrativeUnits from directory.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return administrativeUnits from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphAdministrativeUnitInner> listAdministrativeUnits();

    /**
     * Get administrativeUnits from directory.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return administrativeUnits from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphAdministrativeUnitInner> listAdministrativeUnits(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryOrderby> orderby,
        List<DirectorySelect> select,
        List<DirectoryExpand> expand,
        Context context);

    /**
     * Create new navigation property to administrativeUnits for directory.
     *
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphAdministrativeUnitInner>> createAdministrativeUnitsWithResponseAsync(
        MicrosoftGraphAdministrativeUnitInner body);

    /**
     * Create new navigation property to administrativeUnits for directory.
     *
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphAdministrativeUnitInner> createAdministrativeUnitsAsync(
        MicrosoftGraphAdministrativeUnitInner body);

    /**
     * Create new navigation property to administrativeUnits for directory.
     *
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphAdministrativeUnitInner createAdministrativeUnits(MicrosoftGraphAdministrativeUnitInner body);

    /**
     * Create new navigation property to administrativeUnits for directory.
     *
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphAdministrativeUnitInner> createAdministrativeUnitsWithResponse(
        MicrosoftGraphAdministrativeUnitInner body, Context context);

    /**
     * Get administrativeUnits from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return administrativeUnits from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphAdministrativeUnitInner>> getAdministrativeUnitsWithResponseAsync(
        String administrativeUnitId, List<DirectorySelect> select, List<DirectoryExpand> expand);

    /**
     * Get administrativeUnits from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return administrativeUnits from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphAdministrativeUnitInner> getAdministrativeUnitsAsync(
        String administrativeUnitId, List<DirectorySelect> select, List<DirectoryExpand> expand);

    /**
     * Get administrativeUnits from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return administrativeUnits from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphAdministrativeUnitInner> getAdministrativeUnitsAsync(String administrativeUnitId);

    /**
     * Get administrativeUnits from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return administrativeUnits from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphAdministrativeUnitInner getAdministrativeUnits(String administrativeUnitId);

    /**
     * Get administrativeUnits from directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return administrativeUnits from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphAdministrativeUnitInner> getAdministrativeUnitsWithResponse(
        String administrativeUnitId, List<DirectorySelect> select, List<DirectoryExpand> expand, Context context);

    /**
     * Update the navigation property administrativeUnits in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateAdministrativeUnitsWithResponseAsync(
        String administrativeUnitId, MicrosoftGraphAdministrativeUnitInner body);

    /**
     * Update the navigation property administrativeUnits in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateAdministrativeUnitsAsync(String administrativeUnitId, MicrosoftGraphAdministrativeUnitInner body);

    /**
     * Update the navigation property administrativeUnits in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateAdministrativeUnits(String administrativeUnitId, MicrosoftGraphAdministrativeUnitInner body);

    /**
     * Update the navigation property administrativeUnits in directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateAdministrativeUnitsWithResponse(
        String administrativeUnitId, MicrosoftGraphAdministrativeUnitInner body, Context context);

    /**
     * Delete navigation property administrativeUnits for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteAdministrativeUnitsWithResponseAsync(String administrativeUnitId, String ifMatch);

    /**
     * Delete navigation property administrativeUnits for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAdministrativeUnitsAsync(String administrativeUnitId, String ifMatch);

    /**
     * Delete navigation property administrativeUnits for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAdministrativeUnitsAsync(String administrativeUnitId);

    /**
     * Delete navigation property administrativeUnits for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAdministrativeUnits(String administrativeUnitId);

    /**
     * Delete navigation property administrativeUnits for directory.
     *
     * @param administrativeUnitId key: id of administrativeUnit.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteAdministrativeUnitsWithResponse(String administrativeUnitId, String ifMatch, Context context);

    /**
     * Get deletedItems from directory.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deletedItems from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listDeletedItemsAsync(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryOrderby> orderby,
        List<DirectorySelect> select,
        List<String> expand);

    /**
     * Get deletedItems from directory.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deletedItems from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listDeletedItemsAsync();

    /**
     * Get deletedItems from directory.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deletedItems from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listDeletedItems();

    /**
     * Get deletedItems from directory.
     *
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deletedItems from directory.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listDeletedItems(
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryOrderby> orderby,
        List<DirectorySelect> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to deletedItems for directory.
     *
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDirectoryObjectInner>> createDeletedItemsWithResponseAsync(
        MicrosoftGraphDirectoryObjectInner body);

    /**
     * Create new navigation property to deletedItems for directory.
     *
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDirectoryObjectInner> createDeletedItemsAsync(MicrosoftGraphDirectoryObjectInner body);

    /**
     * Create new navigation property to deletedItems for directory.
     *
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDirectoryObjectInner createDeletedItems(MicrosoftGraphDirectoryObjectInner body);

    /**
     * Create new navigation property to deletedItems for directory.
     *
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDirectoryObjectInner> createDeletedItemsWithResponse(
        MicrosoftGraphDirectoryObjectInner body, Context context);

    /**
     * Get deletedItems from directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deletedItems from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDirectoryObjectInner>> getDeletedItemsWithResponseAsync(
        String directoryObjectId, List<DirectorySelect> select, List<String> expand);

    /**
     * Get deletedItems from directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deletedItems from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDirectoryObjectInner> getDeletedItemsAsync(
        String directoryObjectId, List<DirectorySelect> select, List<String> expand);

    /**
     * Get deletedItems from directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deletedItems from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDirectoryObjectInner> getDeletedItemsAsync(String directoryObjectId);

    /**
     * Get deletedItems from directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deletedItems from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDirectoryObjectInner getDeletedItems(String directoryObjectId);

    /**
     * Get deletedItems from directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return deletedItems from directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDirectoryObjectInner> getDeletedItemsWithResponse(
        String directoryObjectId, List<DirectorySelect> select, List<String> expand, Context context);

    /**
     * Update the navigation property deletedItems in directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateDeletedItemsWithResponseAsync(
        String directoryObjectId, MicrosoftGraphDirectoryObjectInner body);

    /**
     * Update the navigation property deletedItems in directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateDeletedItemsAsync(String directoryObjectId, MicrosoftGraphDirectoryObjectInner body);

    /**
     * Update the navigation property deletedItems in directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateDeletedItems(String directoryObjectId, MicrosoftGraphDirectoryObjectInner body);

    /**
     * Update the navigation property deletedItems in directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateDeletedItemsWithResponse(
        String directoryObjectId, MicrosoftGraphDirectoryObjectInner body, Context context);

    /**
     * Delete navigation property deletedItems for directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteDeletedItemsWithResponseAsync(String directoryObjectId, String ifMatch);

    /**
     * Delete navigation property deletedItems for directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteDeletedItemsAsync(String directoryObjectId, String ifMatch);

    /**
     * Delete navigation property deletedItems for directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteDeletedItemsAsync(String directoryObjectId);

    /**
     * Delete navigation property deletedItems for directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteDeletedItems(String directoryObjectId);

    /**
     * Delete navigation property deletedItems for directory.
     *
     * @param directoryObjectId key: id of directoryObject.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteDeletedItemsWithResponse(String directoryObjectId, String ifMatch, Context context);
}
