// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesGetAvailableExtensionPropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesGetByIdsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesSelect;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryRolesValidatePropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryRoleInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScopedRoleMembershipInner;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DirectoryRolesClient. */
public interface DirectoryRolesClient {
    /**
     * Get members from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(
        String directoryRoleId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRolesOrderby> orderby,
        List<DirectoryRolesSelect> select,
        List<String> expand);

    /**
     * Get members from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String directoryRoleId);

    /**
     * Get members from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String directoryRoleId);

    /**
     * Get members from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return members from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(
        String directoryRoleId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRolesOrderby> orderby,
        List<DirectoryRolesSelect> select,
        List<String> expand,
        Context context);

    /**
     * Get ref of members from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefMembersAsync(
        String directoryRoleId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRolesOrderby> orderby);

    /**
     * Get ref of members from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefMembersAsync(String directoryRoleId);

    /**
     * Get ref of members from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefMembers(String directoryRoleId);

    /**
     * Get ref of members from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of members from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefMembers(
        String directoryRoleId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRolesOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to members for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefMembersWithResponseAsync(
        String directoryRoleId, Map<String, Object> body);

    /**
     * Create new navigation property ref to members for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefMembersAsync(String directoryRoleId, Map<String, Object> body);

    /**
     * Create new navigation property ref to members for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefMembers(String directoryRoleId, Map<String, Object> body);

    /**
     * Create new navigation property ref to members for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefMembersWithResponse(
        String directoryRoleId, Map<String, Object> body, Context context);

    /**
     * Invoke action checkMemberGroups.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(
        String directoryRoleId, DirectoryRolesCheckMemberGroupsRequestBody body);

    /**
     * Invoke action checkMemberGroups.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<String>> checkMemberGroupsAsync(String directoryRoleId, DirectoryRolesCheckMemberGroupsRequestBody body);

    /**
     * Invoke action checkMemberGroups.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<String> checkMemberGroups(String directoryRoleId, DirectoryRolesCheckMemberGroupsRequestBody body);

    /**
     * Invoke action checkMemberGroups.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<String>> checkMemberGroupsWithResponse(
        String directoryRoleId, DirectoryRolesCheckMemberGroupsRequestBody body, Context context);

    /**
     * Invoke action checkMemberObjects.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(
        String directoryRoleId, DirectoryRolesCheckMemberObjectsRequestBody body);

    /**
     * Invoke action checkMemberObjects.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<String>> checkMemberObjectsAsync(
        String directoryRoleId, DirectoryRolesCheckMemberObjectsRequestBody body);

    /**
     * Invoke action checkMemberObjects.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<String> checkMemberObjects(String directoryRoleId, DirectoryRolesCheckMemberObjectsRequestBody body);

    /**
     * Invoke action checkMemberObjects.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<String>> checkMemberObjectsWithResponse(
        String directoryRoleId, DirectoryRolesCheckMemberObjectsRequestBody body, Context context);

    /**
     * Invoke action getMemberGroups.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(
        String directoryRoleId, DirectoryRolesGetMemberGroupsRequestBody body);

    /**
     * Invoke action getMemberGroups.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<String>> getMemberGroupsAsync(String directoryRoleId, DirectoryRolesGetMemberGroupsRequestBody body);

    /**
     * Invoke action getMemberGroups.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<String> getMemberGroups(String directoryRoleId, DirectoryRolesGetMemberGroupsRequestBody body);

    /**
     * Invoke action getMemberGroups.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<String>> getMemberGroupsWithResponse(
        String directoryRoleId, DirectoryRolesGetMemberGroupsRequestBody body, Context context);

    /**
     * Invoke action getMemberObjects.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(
        String directoryRoleId, DirectoryRolesGetMemberObjectsRequestBody body);

    /**
     * Invoke action getMemberObjects.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<String>> getMemberObjectsAsync(String directoryRoleId, DirectoryRolesGetMemberObjectsRequestBody body);

    /**
     * Invoke action getMemberObjects.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<String> getMemberObjects(String directoryRoleId, DirectoryRolesGetMemberObjectsRequestBody body);

    /**
     * Invoke action getMemberObjects.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<String>> getMemberObjectsWithResponse(
        String directoryRoleId, DirectoryRolesGetMemberObjectsRequestBody body, Context context);

    /**
     * Invoke action restore.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String directoryRoleId);

    /**
     * Invoke action restore.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String directoryRoleId);

    /**
     * Invoke action restore.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDirectoryObjectInner restore(String directoryRoleId);

    /**
     * Invoke action restore.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String directoryRoleId, Context context);

    /**
     * Get scopedMembers from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedMembers from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedMembersAsync(
        String directoryRoleId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRolesOrderby> orderby,
        List<DirectoryRolesSelect> select,
        List<String> expand);

    /**
     * Get scopedMembers from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedMembers from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedMembersAsync(String directoryRoleId);

    /**
     * Get scopedMembers from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedMembers from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedMembers(String directoryRoleId);

    /**
     * Get scopedMembers from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedMembers from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedMembers(
        String directoryRoleId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<DirectoryRolesOrderby> orderby,
        List<DirectoryRolesSelect> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to scopedMembers for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedMembersWithResponseAsync(
        String directoryRoleId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Create new navigation property to scopedMembers for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphScopedRoleMembershipInner> createScopedMembersAsync(
        String directoryRoleId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Create new navigation property to scopedMembers for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphScopedRoleMembershipInner createScopedMembers(
        String directoryRoleId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Create new navigation property to scopedMembers for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedRoleMembership.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphScopedRoleMembershipInner> createScopedMembersWithResponse(
        String directoryRoleId, MicrosoftGraphScopedRoleMembershipInner body, Context context);

    /**
     * Get scopedMembers from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedMembers from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedMembersWithResponseAsync(
        String directoryRoleId, String scopedRoleMembershipId, List<DirectoryRolesSelect> select, List<String> expand);

    /**
     * Get scopedMembers from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedMembers from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedMembersAsync(
        String directoryRoleId, String scopedRoleMembershipId, List<DirectoryRolesSelect> select, List<String> expand);

    /**
     * Get scopedMembers from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedMembers from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedMembersAsync(
        String directoryRoleId, String scopedRoleMembershipId);

    /**
     * Get scopedMembers from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedMembers from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphScopedRoleMembershipInner getScopedMembers(String directoryRoleId, String scopedRoleMembershipId);

    /**
     * Get scopedMembers from directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return scopedMembers from directoryRoles.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphScopedRoleMembershipInner> getScopedMembersWithResponse(
        String directoryRoleId,
        String scopedRoleMembershipId,
        List<DirectoryRolesSelect> select,
        List<String> expand,
        Context context);

    /**
     * Update the navigation property scopedMembers in directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateScopedMembersWithResponseAsync(
        String directoryRoleId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Update the navigation property scopedMembers in directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateScopedMembersAsync(
        String directoryRoleId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Update the navigation property scopedMembers in directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateScopedMembers(
        String directoryRoleId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body);

    /**
     * Update the navigation property scopedMembers in directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateScopedMembersWithResponse(
        String directoryRoleId,
        String scopedRoleMembershipId,
        MicrosoftGraphScopedRoleMembershipInner body,
        Context context);

    /**
     * Delete navigation property scopedMembers for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteScopedMembersWithResponseAsync(
        String directoryRoleId, String scopedRoleMembershipId, String ifMatch);

    /**
     * Delete navigation property scopedMembers for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteScopedMembersAsync(String directoryRoleId, String scopedRoleMembershipId, String ifMatch);

    /**
     * Delete navigation property scopedMembers for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteScopedMembersAsync(String directoryRoleId, String scopedRoleMembershipId);

    /**
     * Delete navigation property scopedMembers for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteScopedMembers(String directoryRoleId, String scopedRoleMembershipId);

    /**
     * Delete navigation property scopedMembers for directoryRoles.
     *
     * @param directoryRoleId key: id of directoryRole.
     * @param scopedRoleMembershipId key: id of scopedRoleMembership.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteScopedMembersWithResponse(
        String directoryRoleId, String scopedRoleMembershipId, String ifMatch, Context context);

    /**
     * Invoke function delta.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<MicrosoftGraphDirectoryRoleInner>>> deltaWithResponseAsync();

    /**
     * Invoke function delta.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<MicrosoftGraphDirectoryRoleInner>> deltaAsync();

    /**
     * Invoke function delta.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<MicrosoftGraphDirectoryRoleInner> delta();

    /**
     * Invoke function delta.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<MicrosoftGraphDirectoryRoleInner>> deltaWithResponse(Context context);

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(
        DirectoryRolesGetAvailableExtensionPropertiesRequestBody body);

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesAsync(
        DirectoryRolesGetAvailableExtensionPropertiesRequestBody body);

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<MicrosoftGraphExtensionPropertyInner> getAvailableExtensionProperties(
        DirectoryRolesGetAvailableExtensionPropertiesRequestBody body);

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesWithResponse(
        DirectoryRolesGetAvailableExtensionPropertiesRequestBody body, Context context);

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(
        DirectoryRolesGetByIdsRequestBody body);

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<MicrosoftGraphDirectoryObjectInner>> getByIdsAsync(DirectoryRolesGetByIdsRequestBody body);

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<MicrosoftGraphDirectoryObjectInner> getByIds(DirectoryRolesGetByIdsRequestBody body);

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<MicrosoftGraphDirectoryObjectInner>> getByIdsWithResponse(
        DirectoryRolesGetByIdsRequestBody body, Context context);

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> validatePropertiesWithResponseAsync(DirectoryRolesValidatePropertiesRequestBody body);

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> validatePropertiesAsync(DirectoryRolesValidatePropertiesRequestBody body);

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void validateProperties(DirectoryRolesValidatePropertiesRequestBody body);

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> validatePropertiesWithResponse(DirectoryRolesValidatePropertiesRequestBody body, Context context);
}
