// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAppRoleAssignmentInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphClaimsMappingPolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDelegatedPermissionClassificationInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEndpointInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphHomeRealmDiscoveryPolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphKeyCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOAuth2PermissionGrantInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPasswordCredentialInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphServicePrincipalInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTokenIssuancePolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTokenLifetimePolicyInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsAddKeyRequestBodyInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsAddPasswordRequestBodyInner;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsExpand;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsGetAvailableExtensionPropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsGetByIdsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsRemoveKeyRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsRemovePasswordRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsSelect;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsValidatePropertiesRequestBody;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ServicePrincipalsClient. */
public interface ServicePrincipalsClient {
    /**
     * Get appRoleAssignedTo from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignedTo from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignedToAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get appRoleAssignedTo from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignedTo from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignedToAsync(String servicePrincipalId);

    /**
     * Get appRoleAssignedTo from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignedTo from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignedTo(String servicePrincipalId);

    /**
     * Get appRoleAssignedTo from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignedTo from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignedTo(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to appRoleAssignedTo for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignedToWithResponseAsync(
        String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Create new navigation property to appRoleAssignedTo for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignedToAsync(
        String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Create new navigation property to appRoleAssignedTo for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphAppRoleAssignmentInner createAppRoleAssignedTo(
        String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Create new navigation property to appRoleAssignedTo for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignedToWithResponse(
        String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body, Context context);

    /**
     * Get appRoleAssignedTo from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignedTo from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignedToWithResponseAsync(
        String servicePrincipalId,
        String appRoleAssignmentId,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get appRoleAssignedTo from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignedTo from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignedToAsync(
        String servicePrincipalId,
        String appRoleAssignmentId,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get appRoleAssignedTo from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignedTo from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignedToAsync(
        String servicePrincipalId, String appRoleAssignmentId);

    /**
     * Get appRoleAssignedTo from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignedTo from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphAppRoleAssignmentInner getAppRoleAssignedTo(String servicePrincipalId, String appRoleAssignmentId);

    /**
     * Get appRoleAssignedTo from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignedTo from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignedToWithResponse(
        String servicePrincipalId,
        String appRoleAssignmentId,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Update the navigation property appRoleAssignedTo in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateAppRoleAssignedToWithResponseAsync(
        String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Update the navigation property appRoleAssignedTo in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateAppRoleAssignedToAsync(
        String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Update the navigation property appRoleAssignedTo in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateAppRoleAssignedTo(
        String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Update the navigation property appRoleAssignedTo in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateAppRoleAssignedToWithResponse(
        String servicePrincipalId,
        String appRoleAssignmentId,
        MicrosoftGraphAppRoleAssignmentInner body,
        Context context);

    /**
     * Delete navigation property appRoleAssignedTo for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteAppRoleAssignedToWithResponseAsync(
        String servicePrincipalId, String appRoleAssignmentId, String ifMatch);

    /**
     * Delete navigation property appRoleAssignedTo for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAppRoleAssignedToAsync(String servicePrincipalId, String appRoleAssignmentId, String ifMatch);

    /**
     * Delete navigation property appRoleAssignedTo for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAppRoleAssignedToAsync(String servicePrincipalId, String appRoleAssignmentId);

    /**
     * Delete navigation property appRoleAssignedTo for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAppRoleAssignedTo(String servicePrincipalId, String appRoleAssignmentId);

    /**
     * Delete navigation property appRoleAssignedTo for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteAppRoleAssignedToWithResponse(
        String servicePrincipalId, String appRoleAssignmentId, String ifMatch, Context context);

    /**
     * Get appRoleAssignments from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get appRoleAssignments from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(String servicePrincipalId);

    /**
     * Get appRoleAssignments from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignments(String servicePrincipalId);

    /**
     * Get appRoleAssignments from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignments(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to appRoleAssignments for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignmentsWithResponseAsync(
        String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Create new navigation property to appRoleAssignments for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignmentsAsync(
        String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Create new navigation property to appRoleAssignments for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphAppRoleAssignmentInner createAppRoleAssignments(
        String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Create new navigation property to appRoleAssignments for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignmentsWithResponse(
        String servicePrincipalId, MicrosoftGraphAppRoleAssignmentInner body, Context context);

    /**
     * Get appRoleAssignments from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignmentsWithResponseAsync(
        String servicePrincipalId,
        String appRoleAssignmentId,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get appRoleAssignments from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsAsync(
        String servicePrincipalId,
        String appRoleAssignmentId,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get appRoleAssignments from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsAsync(
        String servicePrincipalId, String appRoleAssignmentId);

    /**
     * Get appRoleAssignments from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphAppRoleAssignmentInner getAppRoleAssignments(String servicePrincipalId, String appRoleAssignmentId);

    /**
     * Get appRoleAssignments from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return appRoleAssignments from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsWithResponse(
        String servicePrincipalId,
        String appRoleAssignmentId,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Update the navigation property appRoleAssignments in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateAppRoleAssignmentsWithResponseAsync(
        String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Update the navigation property appRoleAssignments in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateAppRoleAssignmentsAsync(
        String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Update the navigation property appRoleAssignments in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateAppRoleAssignments(
        String servicePrincipalId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body);

    /**
     * Update the navigation property appRoleAssignments in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateAppRoleAssignmentsWithResponse(
        String servicePrincipalId,
        String appRoleAssignmentId,
        MicrosoftGraphAppRoleAssignmentInner body,
        Context context);

    /**
     * Delete navigation property appRoleAssignments for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteAppRoleAssignmentsWithResponseAsync(
        String servicePrincipalId, String appRoleAssignmentId, String ifMatch);

    /**
     * Delete navigation property appRoleAssignments for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAppRoleAssignmentsAsync(String servicePrincipalId, String appRoleAssignmentId, String ifMatch);

    /**
     * Delete navigation property appRoleAssignments for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAppRoleAssignmentsAsync(String servicePrincipalId, String appRoleAssignmentId);

    /**
     * Delete navigation property appRoleAssignments for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAppRoleAssignments(String servicePrincipalId, String appRoleAssignmentId);

    /**
     * Delete navigation property appRoleAssignments for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param appRoleAssignmentId key: id of appRoleAssignment.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteAppRoleAssignmentsWithResponse(
        String servicePrincipalId, String appRoleAssignmentId, String ifMatch, Context context);

    /**
     * Get claimsMappingPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return claimsMappingPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphClaimsMappingPolicyInner> listClaimsMappingPoliciesAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<ServicePrincipalsExpand> expand);

    /**
     * Get claimsMappingPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return claimsMappingPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphClaimsMappingPolicyInner> listClaimsMappingPoliciesAsync(String servicePrincipalId);

    /**
     * Get claimsMappingPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return claimsMappingPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphClaimsMappingPolicyInner> listClaimsMappingPolicies(String servicePrincipalId);

    /**
     * Get claimsMappingPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return claimsMappingPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphClaimsMappingPolicyInner> listClaimsMappingPolicies(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<ServicePrincipalsExpand> expand,
        Context context);

    /**
     * Get ref of claimsMappingPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of claimsMappingPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefClaimsMappingPoliciesAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby);

    /**
     * Get ref of claimsMappingPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of claimsMappingPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefClaimsMappingPoliciesAsync(String servicePrincipalId);

    /**
     * Get ref of claimsMappingPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of claimsMappingPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefClaimsMappingPolicies(String servicePrincipalId);

    /**
     * Get ref of claimsMappingPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of claimsMappingPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefClaimsMappingPolicies(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to claimsMappingPolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefClaimsMappingPoliciesWithResponseAsync(
        String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to claimsMappingPolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefClaimsMappingPoliciesAsync(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to claimsMappingPolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefClaimsMappingPolicies(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to claimsMappingPolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefClaimsMappingPoliciesWithResponse(
        String servicePrincipalId, Map<String, Object> body, Context context);

    /**
     * Get createdObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listCreatedObjectsAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get createdObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listCreatedObjectsAsync(String servicePrincipalId);

    /**
     * Get createdObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listCreatedObjects(String servicePrincipalId);

    /**
     * Get createdObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return createdObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listCreatedObjects(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Get ref of createdObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefCreatedObjectsAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby);

    /**
     * Get ref of createdObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefCreatedObjectsAsync(String servicePrincipalId);

    /**
     * Get ref of createdObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefCreatedObjects(String servicePrincipalId);

    /**
     * Get ref of createdObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of createdObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefCreatedObjects(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to createdObjects for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefCreatedObjectsWithResponseAsync(
        String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to createdObjects for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefCreatedObjectsAsync(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to createdObjects for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefCreatedObjects(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to createdObjects for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefCreatedObjectsWithResponse(
        String servicePrincipalId, Map<String, Object> body, Context context);

    /**
     * Get delegatedPermissionClassifications from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassifications from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDelegatedPermissionClassificationInner> listDelegatedPermissionClassificationsAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get delegatedPermissionClassifications from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassifications from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDelegatedPermissionClassificationInner> listDelegatedPermissionClassificationsAsync(
        String servicePrincipalId);

    /**
     * Get delegatedPermissionClassifications from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassifications from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDelegatedPermissionClassificationInner> listDelegatedPermissionClassifications(
        String servicePrincipalId);

    /**
     * Get delegatedPermissionClassifications from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassifications from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDelegatedPermissionClassificationInner> listDelegatedPermissionClassifications(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to delegatedPermissionClassifications for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassification.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDelegatedPermissionClassificationInner>>
        createDelegatedPermissionClassificationsWithResponseAsync(
            String servicePrincipalId, MicrosoftGraphDelegatedPermissionClassificationInner body);

    /**
     * Create new navigation property to delegatedPermissionClassifications for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassification.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDelegatedPermissionClassificationInner> createDelegatedPermissionClassificationsAsync(
        String servicePrincipalId, MicrosoftGraphDelegatedPermissionClassificationInner body);

    /**
     * Create new navigation property to delegatedPermissionClassifications for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassification.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDelegatedPermissionClassificationInner createDelegatedPermissionClassifications(
        String servicePrincipalId, MicrosoftGraphDelegatedPermissionClassificationInner body);

    /**
     * Create new navigation property to delegatedPermissionClassifications for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassification.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDelegatedPermissionClassificationInner> createDelegatedPermissionClassificationsWithResponse(
        String servicePrincipalId, MicrosoftGraphDelegatedPermissionClassificationInner body, Context context);

    /**
     * Get delegatedPermissionClassifications from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassifications from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDelegatedPermissionClassificationInner>>
        getDelegatedPermissionClassificationsWithResponseAsync(
            String servicePrincipalId,
            String delegatedPermissionClassificationId,
            List<ServicePrincipalsSelect> select,
            List<String> expand);

    /**
     * Get delegatedPermissionClassifications from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassifications from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDelegatedPermissionClassificationInner> getDelegatedPermissionClassificationsAsync(
        String servicePrincipalId,
        String delegatedPermissionClassificationId,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get delegatedPermissionClassifications from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassifications from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDelegatedPermissionClassificationInner> getDelegatedPermissionClassificationsAsync(
        String servicePrincipalId, String delegatedPermissionClassificationId);

    /**
     * Get delegatedPermissionClassifications from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassifications from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDelegatedPermissionClassificationInner getDelegatedPermissionClassifications(
        String servicePrincipalId, String delegatedPermissionClassificationId);

    /**
     * Get delegatedPermissionClassifications from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return delegatedPermissionClassifications from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDelegatedPermissionClassificationInner> getDelegatedPermissionClassificationsWithResponse(
        String servicePrincipalId,
        String delegatedPermissionClassificationId,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Update the navigation property delegatedPermissionClassifications in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateDelegatedPermissionClassificationsWithResponseAsync(
        String servicePrincipalId,
        String delegatedPermissionClassificationId,
        MicrosoftGraphDelegatedPermissionClassificationInner body);

    /**
     * Update the navigation property delegatedPermissionClassifications in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateDelegatedPermissionClassificationsAsync(
        String servicePrincipalId,
        String delegatedPermissionClassificationId,
        MicrosoftGraphDelegatedPermissionClassificationInner body);

    /**
     * Update the navigation property delegatedPermissionClassifications in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateDelegatedPermissionClassifications(
        String servicePrincipalId,
        String delegatedPermissionClassificationId,
        MicrosoftGraphDelegatedPermissionClassificationInner body);

    /**
     * Update the navigation property delegatedPermissionClassifications in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateDelegatedPermissionClassificationsWithResponse(
        String servicePrincipalId,
        String delegatedPermissionClassificationId,
        MicrosoftGraphDelegatedPermissionClassificationInner body,
        Context context);

    /**
     * Delete navigation property delegatedPermissionClassifications for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteDelegatedPermissionClassificationsWithResponseAsync(
        String servicePrincipalId, String delegatedPermissionClassificationId, String ifMatch);

    /**
     * Delete navigation property delegatedPermissionClassifications for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteDelegatedPermissionClassificationsAsync(
        String servicePrincipalId, String delegatedPermissionClassificationId, String ifMatch);

    /**
     * Delete navigation property delegatedPermissionClassifications for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteDelegatedPermissionClassificationsAsync(
        String servicePrincipalId, String delegatedPermissionClassificationId);

    /**
     * Delete navigation property delegatedPermissionClassifications for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteDelegatedPermissionClassifications(
        String servicePrincipalId, String delegatedPermissionClassificationId);

    /**
     * Delete navigation property delegatedPermissionClassifications for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param delegatedPermissionClassificationId key: id of delegatedPermissionClassification.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteDelegatedPermissionClassificationsWithResponse(
        String servicePrincipalId, String delegatedPermissionClassificationId, String ifMatch, Context context);

    /**
     * Get endpoints from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return endpoints from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphEndpointInner> listEndpointsAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get endpoints from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return endpoints from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphEndpointInner> listEndpointsAsync(String servicePrincipalId);

    /**
     * Get endpoints from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return endpoints from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphEndpointInner> listEndpoints(String servicePrincipalId);

    /**
     * Get endpoints from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return endpoints from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphEndpointInner> listEndpoints(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Create new navigation property to endpoints for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphEndpointInner>> createEndpointsWithResponseAsync(
        String servicePrincipalId, MicrosoftGraphEndpointInner body);

    /**
     * Create new navigation property to endpoints for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphEndpointInner> createEndpointsAsync(String servicePrincipalId, MicrosoftGraphEndpointInner body);

    /**
     * Create new navigation property to endpoints for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphEndpointInner createEndpoints(String servicePrincipalId, MicrosoftGraphEndpointInner body);

    /**
     * Create new navigation property to endpoints for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphEndpointInner> createEndpointsWithResponse(
        String servicePrincipalId, MicrosoftGraphEndpointInner body, Context context);

    /**
     * Get endpoints from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return endpoints from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphEndpointInner>> getEndpointsWithResponseAsync(
        String servicePrincipalId, String endpointId, List<ServicePrincipalsSelect> select, List<String> expand);

    /**
     * Get endpoints from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return endpoints from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphEndpointInner> getEndpointsAsync(
        String servicePrincipalId, String endpointId, List<ServicePrincipalsSelect> select, List<String> expand);

    /**
     * Get endpoints from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return endpoints from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphEndpointInner> getEndpointsAsync(String servicePrincipalId, String endpointId);

    /**
     * Get endpoints from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return endpoints from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphEndpointInner getEndpoints(String servicePrincipalId, String endpointId);

    /**
     * Get endpoints from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return endpoints from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphEndpointInner> getEndpointsWithResponse(
        String servicePrincipalId,
        String endpointId,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Update the navigation property endpoints in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> updateEndpointsWithResponseAsync(
        String servicePrincipalId, String endpointId, MicrosoftGraphEndpointInner body);

    /**
     * Update the navigation property endpoints in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> updateEndpointsAsync(String servicePrincipalId, String endpointId, MicrosoftGraphEndpointInner body);

    /**
     * Update the navigation property endpoints in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @param body New navigation property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void updateEndpoints(String servicePrincipalId, String endpointId, MicrosoftGraphEndpointInner body);

    /**
     * Update the navigation property endpoints in servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @param body New navigation property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> updateEndpointsWithResponse(
        String servicePrincipalId, String endpointId, MicrosoftGraphEndpointInner body, Context context);

    /**
     * Delete navigation property endpoints for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteEndpointsWithResponseAsync(String servicePrincipalId, String endpointId, String ifMatch);

    /**
     * Delete navigation property endpoints for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteEndpointsAsync(String servicePrincipalId, String endpointId, String ifMatch);

    /**
     * Delete navigation property endpoints for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteEndpointsAsync(String servicePrincipalId, String endpointId);

    /**
     * Delete navigation property endpoints for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteEndpoints(String servicePrincipalId, String endpointId);

    /**
     * Delete navigation property endpoints for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param endpointId key: id of endpoint.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteEndpointsWithResponse(
        String servicePrincipalId, String endpointId, String ifMatch, Context context);

    /**
     * Get homeRealmDiscoveryPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return homeRealmDiscoveryPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPoliciesAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<ServicePrincipalsExpand> expand);

    /**
     * Get homeRealmDiscoveryPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return homeRealmDiscoveryPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPoliciesAsync(
        String servicePrincipalId);

    /**
     * Get homeRealmDiscoveryPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return homeRealmDiscoveryPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPolicies(
        String servicePrincipalId);

    /**
     * Get homeRealmDiscoveryPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return homeRealmDiscoveryPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphHomeRealmDiscoveryPolicyInner> listHomeRealmDiscoveryPolicies(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<ServicePrincipalsExpand> expand,
        Context context);

    /**
     * Get ref of homeRealmDiscoveryPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of homeRealmDiscoveryPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefHomeRealmDiscoveryPoliciesAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby);

    /**
     * Get ref of homeRealmDiscoveryPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of homeRealmDiscoveryPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefHomeRealmDiscoveryPoliciesAsync(String servicePrincipalId);

    /**
     * Get ref of homeRealmDiscoveryPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of homeRealmDiscoveryPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefHomeRealmDiscoveryPolicies(String servicePrincipalId);

    /**
     * Get ref of homeRealmDiscoveryPolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of homeRealmDiscoveryPolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefHomeRealmDiscoveryPolicies(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to homeRealmDiscoveryPolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefHomeRealmDiscoveryPoliciesWithResponseAsync(
        String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to homeRealmDiscoveryPolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefHomeRealmDiscoveryPoliciesAsync(
        String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to homeRealmDiscoveryPolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefHomeRealmDiscoveryPolicies(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to homeRealmDiscoveryPolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefHomeRealmDiscoveryPoliciesWithResponse(
        String servicePrincipalId, Map<String, Object> body, Context context);

    /**
     * Get memberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get memberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String servicePrincipalId);

    /**
     * Get memberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String servicePrincipalId);

    /**
     * Get memberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Get ref of memberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefMemberOfAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby);

    /**
     * Get ref of memberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefMemberOfAsync(String servicePrincipalId);

    /**
     * Get ref of memberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefMemberOf(String servicePrincipalId);

    /**
     * Get ref of memberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefMemberOf(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to memberOf for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(
        String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to memberOf for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefMemberOfAsync(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to memberOf for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefMemberOf(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to memberOf for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefMemberOfWithResponse(
        String servicePrincipalId, Map<String, Object> body, Context context);

    /**
     * Invoke action addKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphKeyCredentialInner>> addKeyWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body);

    /**
     * Invoke action addKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphKeyCredentialInner> addKeyAsync(
        String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body);

    /**
     * Invoke action addKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphKeyCredentialInner addKey(String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body);

    /**
     * Invoke action addKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return keyCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphKeyCredentialInner> addKeyWithResponse(
        String servicePrincipalId, ServicePrincipalsAddKeyRequestBodyInner body, Context context);

    /**
     * Invoke action addPassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphPasswordCredentialInner>> addPasswordWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body);

    /**
     * Invoke action addPassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphPasswordCredentialInner> addPasswordAsync(
        String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body);

    /**
     * Invoke action addPassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphPasswordCredentialInner addPassword(
        String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body);

    /**
     * Invoke action addPassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return passwordCredential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphPasswordCredentialInner> addPasswordWithResponse(
        String servicePrincipalId, ServicePrincipalsAddPasswordRequestBodyInner body, Context context);

    /**
     * Invoke action checkMemberGroups.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsCheckMemberGroupsRequestBody body);

    /**
     * Invoke action checkMemberGroups.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<String>> checkMemberGroupsAsync(
        String servicePrincipalId, ServicePrincipalsCheckMemberGroupsRequestBody body);

    /**
     * Invoke action checkMemberGroups.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<String> checkMemberGroups(String servicePrincipalId, ServicePrincipalsCheckMemberGroupsRequestBody body);

    /**
     * Invoke action checkMemberGroups.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<String>> checkMemberGroupsWithResponse(
        String servicePrincipalId, ServicePrincipalsCheckMemberGroupsRequestBody body, Context context);

    /**
     * Invoke action checkMemberObjects.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsCheckMemberObjectsRequestBody body);

    /**
     * Invoke action checkMemberObjects.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<String>> checkMemberObjectsAsync(
        String servicePrincipalId, ServicePrincipalsCheckMemberObjectsRequestBody body);

    /**
     * Invoke action checkMemberObjects.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<String> checkMemberObjects(String servicePrincipalId, ServicePrincipalsCheckMemberObjectsRequestBody body);

    /**
     * Invoke action checkMemberObjects.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<String>> checkMemberObjectsWithResponse(
        String servicePrincipalId, ServicePrincipalsCheckMemberObjectsRequestBody body, Context context);

    /**
     * Invoke action getMemberGroups.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsGetMemberGroupsRequestBody body);

    /**
     * Invoke action getMemberGroups.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<String>> getMemberGroupsAsync(
        String servicePrincipalId, ServicePrincipalsGetMemberGroupsRequestBody body);

    /**
     * Invoke action getMemberGroups.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<String> getMemberGroups(String servicePrincipalId, ServicePrincipalsGetMemberGroupsRequestBody body);

    /**
     * Invoke action getMemberGroups.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<String>> getMemberGroupsWithResponse(
        String servicePrincipalId, ServicePrincipalsGetMemberGroupsRequestBody body, Context context);

    /**
     * Invoke action getMemberObjects.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsGetMemberObjectsRequestBody body);

    /**
     * Invoke action getMemberObjects.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<String>> getMemberObjectsAsync(
        String servicePrincipalId, ServicePrincipalsGetMemberObjectsRequestBody body);

    /**
     * Invoke action getMemberObjects.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<String> getMemberObjects(String servicePrincipalId, ServicePrincipalsGetMemberObjectsRequestBody body);

    /**
     * Invoke action getMemberObjects.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<String>> getMemberObjectsWithResponse(
        String servicePrincipalId, ServicePrincipalsGetMemberObjectsRequestBody body, Context context);

    /**
     * Invoke action removeKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> removeKeyWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsRemoveKeyRequestBody body);

    /**
     * Invoke action removeKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> removeKeyAsync(String servicePrincipalId, ServicePrincipalsRemoveKeyRequestBody body);

    /**
     * Invoke action removeKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void removeKey(String servicePrincipalId, ServicePrincipalsRemoveKeyRequestBody body);

    /**
     * Invoke action removeKey.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> removeKeyWithResponse(
        String servicePrincipalId, ServicePrincipalsRemoveKeyRequestBody body, Context context);

    /**
     * Invoke action removePassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> removePasswordWithResponseAsync(
        String servicePrincipalId, ServicePrincipalsRemovePasswordRequestBody body);

    /**
     * Invoke action removePassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> removePasswordAsync(String servicePrincipalId, ServicePrincipalsRemovePasswordRequestBody body);

    /**
     * Invoke action removePassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void removePassword(String servicePrincipalId, ServicePrincipalsRemovePasswordRequestBody body);

    /**
     * Invoke action removePassword.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> removePasswordWithResponse(
        String servicePrincipalId, ServicePrincipalsRemovePasswordRequestBody body, Context context);

    /**
     * Invoke action restore.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String servicePrincipalId);

    /**
     * Invoke action restore.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String servicePrincipalId);

    /**
     * Invoke action restore.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MicrosoftGraphDirectoryObjectInner restore(String servicePrincipalId);

    /**
     * Invoke action restore.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String servicePrincipalId, Context context);

    /**
     * Get oauth2PermissionGrants from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return oauth2PermissionGrants from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrantsAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get oauth2PermissionGrants from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return oauth2PermissionGrants from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrantsAsync(String servicePrincipalId);

    /**
     * Get oauth2PermissionGrants from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return oauth2PermissionGrants from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrants(String servicePrincipalId);

    /**
     * Get oauth2PermissionGrants from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return oauth2PermissionGrants from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrants(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Get ref of oauth2PermissionGrants from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of oauth2PermissionGrants from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefOauth2PermissionGrantsAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby);

    /**
     * Get ref of oauth2PermissionGrants from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of oauth2PermissionGrants from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefOauth2PermissionGrantsAsync(String servicePrincipalId);

    /**
     * Get ref of oauth2PermissionGrants from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of oauth2PermissionGrants from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefOauth2PermissionGrants(String servicePrincipalId);

    /**
     * Get ref of oauth2PermissionGrants from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of oauth2PermissionGrants from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefOauth2PermissionGrants(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to oauth2PermissionGrants for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefOauth2PermissionGrantsWithResponseAsync(
        String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to oauth2PermissionGrants for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefOauth2PermissionGrantsAsync(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to oauth2PermissionGrants for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefOauth2PermissionGrants(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to oauth2PermissionGrants for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefOauth2PermissionGrantsWithResponse(
        String servicePrincipalId, Map<String, Object> body, Context context);

    /**
     * Get ownedObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ownedObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnedObjectsAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get ownedObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ownedObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnedObjectsAsync(String servicePrincipalId);

    /**
     * Get ownedObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ownedObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwnedObjects(String servicePrincipalId);

    /**
     * Get ownedObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ownedObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwnedObjects(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Get ref of ownedObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of ownedObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefOwnedObjectsAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby);

    /**
     * Get ref of ownedObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of ownedObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefOwnedObjectsAsync(String servicePrincipalId);

    /**
     * Get ref of ownedObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of ownedObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefOwnedObjects(String servicePrincipalId);

    /**
     * Get ref of ownedObjects from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of ownedObjects from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefOwnedObjects(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to ownedObjects for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefOwnedObjectsWithResponseAsync(
        String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to ownedObjects for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefOwnedObjectsAsync(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to ownedObjects for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefOwnedObjects(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to ownedObjects for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefOwnedObjectsWithResponse(
        String servicePrincipalId, Map<String, Object> body, Context context);

    /**
     * Get owners from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return owners from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnersAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get owners from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return owners from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnersAsync(String servicePrincipalId);

    /**
     * Get owners from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return owners from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwners(String servicePrincipalId);

    /**
     * Get owners from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return owners from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwners(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Get ref of owners from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of owners from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefOwnersAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby);

    /**
     * Get ref of owners from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of owners from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefOwnersAsync(String servicePrincipalId);

    /**
     * Get ref of owners from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of owners from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefOwners(String servicePrincipalId);

    /**
     * Get ref of owners from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of owners from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefOwners(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to owners for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefOwnersWithResponseAsync(
        String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to owners for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefOwnersAsync(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to owners for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefOwners(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to owners for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefOwnersWithResponse(
        String servicePrincipalId, Map<String, Object> body, Context context);

    /**
     * Get tokenIssuancePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tokenIssuancePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphTokenIssuancePolicyInner> listTokenIssuancePoliciesAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<ServicePrincipalsExpand> expand);

    /**
     * Get tokenIssuancePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tokenIssuancePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphTokenIssuancePolicyInner> listTokenIssuancePoliciesAsync(String servicePrincipalId);

    /**
     * Get tokenIssuancePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tokenIssuancePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphTokenIssuancePolicyInner> listTokenIssuancePolicies(String servicePrincipalId);

    /**
     * Get tokenIssuancePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tokenIssuancePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphTokenIssuancePolicyInner> listTokenIssuancePolicies(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<ServicePrincipalsExpand> expand,
        Context context);

    /**
     * Get ref of tokenIssuancePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of tokenIssuancePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefTokenIssuancePoliciesAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby);

    /**
     * Get ref of tokenIssuancePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of tokenIssuancePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefTokenIssuancePoliciesAsync(String servicePrincipalId);

    /**
     * Get ref of tokenIssuancePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of tokenIssuancePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefTokenIssuancePolicies(String servicePrincipalId);

    /**
     * Get ref of tokenIssuancePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of tokenIssuancePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefTokenIssuancePolicies(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to tokenIssuancePolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefTokenIssuancePoliciesWithResponseAsync(
        String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to tokenIssuancePolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefTokenIssuancePoliciesAsync(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to tokenIssuancePolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefTokenIssuancePolicies(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to tokenIssuancePolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefTokenIssuancePoliciesWithResponse(
        String servicePrincipalId, Map<String, Object> body, Context context);

    /**
     * Get tokenLifetimePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tokenLifetimePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphTokenLifetimePolicyInner> listTokenLifetimePoliciesAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<ServicePrincipalsExpand> expand);

    /**
     * Get tokenLifetimePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tokenLifetimePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphTokenLifetimePolicyInner> listTokenLifetimePoliciesAsync(String servicePrincipalId);

    /**
     * Get tokenLifetimePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tokenLifetimePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphTokenLifetimePolicyInner> listTokenLifetimePolicies(String servicePrincipalId);

    /**
     * Get tokenLifetimePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return tokenLifetimePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphTokenLifetimePolicyInner> listTokenLifetimePolicies(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<ServicePrincipalsExpand> expand,
        Context context);

    /**
     * Get ref of tokenLifetimePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of tokenLifetimePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefTokenLifetimePoliciesAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby);

    /**
     * Get ref of tokenLifetimePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of tokenLifetimePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefTokenLifetimePoliciesAsync(String servicePrincipalId);

    /**
     * Get ref of tokenLifetimePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of tokenLifetimePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefTokenLifetimePolicies(String servicePrincipalId);

    /**
     * Get ref of tokenLifetimePolicies from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of tokenLifetimePolicies from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefTokenLifetimePolicies(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to tokenLifetimePolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefTokenLifetimePoliciesWithResponseAsync(
        String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to tokenLifetimePolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefTokenLifetimePoliciesAsync(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to tokenLifetimePolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefTokenLifetimePolicies(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to tokenLifetimePolicies for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefTokenLifetimePoliciesWithResponse(
        String servicePrincipalId, Map<String, Object> body, Context context);

    /**
     * Get transitiveMemberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand);

    /**
     * Get transitiveMemberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String servicePrincipalId);

    /**
     * Get transitiveMemberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String servicePrincipalId);

    /**
     * Get transitiveMemberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        List<ServicePrincipalsSelect> select,
        List<String> expand,
        Context context);

    /**
     * Get ref of transitiveMemberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefTransitiveMemberOfAsync(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby);

    /**
     * Get ref of transitiveMemberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<String> listRefTransitiveMemberOfAsync(String servicePrincipalId);

    /**
     * Get ref of transitiveMemberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefTransitiveMemberOf(String servicePrincipalId);

    /**
     * Get ref of transitiveMemberOf from servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from servicePrincipals.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<String> listRefTransitiveMemberOf(
        String servicePrincipalId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ServicePrincipalsOrderby> orderby,
        Context context);

    /**
     * Create new navigation property ref to transitiveMemberOf for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(
        String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to transitiveMemberOf for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Map<String, Object>> createRefTransitiveMemberOfAsync(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to transitiveMemberOf for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Map<String, Object> createRefTransitiveMemberOf(String servicePrincipalId, Map<String, Object> body);

    /**
     * Create new navigation property ref to transitiveMemberOf for servicePrincipals.
     *
     * @param servicePrincipalId key: id of servicePrincipal.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Map<String, Object>> createRefTransitiveMemberOfWithResponse(
        String servicePrincipalId, Map<String, Object> body, Context context);

    /**
     * Invoke function delta.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<MicrosoftGraphServicePrincipalInner>>> deltaWithResponseAsync();

    /**
     * Invoke function delta.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<MicrosoftGraphServicePrincipalInner>> deltaAsync();

    /**
     * Invoke function delta.
     *
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<MicrosoftGraphServicePrincipalInner> delta();

    /**
     * Invoke function delta.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<MicrosoftGraphServicePrincipalInner>> deltaWithResponse(Context context);

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(
        ServicePrincipalsGetAvailableExtensionPropertiesRequestBody body);

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesAsync(
        ServicePrincipalsGetAvailableExtensionPropertiesRequestBody body);

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<MicrosoftGraphExtensionPropertyInner> getAvailableExtensionProperties(
        ServicePrincipalsGetAvailableExtensionPropertiesRequestBody body);

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesWithResponse(
        ServicePrincipalsGetAvailableExtensionPropertiesRequestBody body, Context context);

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(
        ServicePrincipalsGetByIdsRequestBody body);

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<MicrosoftGraphDirectoryObjectInner>> getByIdsAsync(ServicePrincipalsGetByIdsRequestBody body);

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<MicrosoftGraphDirectoryObjectInner> getByIds(ServicePrincipalsGetByIdsRequestBody body);

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<MicrosoftGraphDirectoryObjectInner>> getByIdsWithResponse(
        ServicePrincipalsGetByIdsRequestBody body, Context context);

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> validatePropertiesWithResponseAsync(ServicePrincipalsValidatePropertiesRequestBody body);

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> validatePropertiesAsync(ServicePrincipalsValidatePropertiesRequestBody body);

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void validateProperties(ServicePrincipalsValidatePropertiesRequestBody body);

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> validatePropertiesWithResponse(ServicePrincipalsValidatePropertiesRequestBody body, Context context);
}
