// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** currencyColumn. */
@Fluent
public final class MicrosoftGraphCurrencyColumn {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphCurrencyColumn.class);

    /*
     * Specifies the locale from which to infer the currency symbol.
     */
    @JsonProperty(value = "locale")
    private String locale;

    /*
     * currencyColumn
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the locale property: Specifies the locale from which to infer the currency symbol.
     *
     * @return the locale value.
     */
    public String locale() {
        return this.locale;
    }

    /**
     * Set the locale property: Specifies the locale from which to infer the currency symbol.
     *
     * @param locale the locale value to set.
     * @return the MicrosoftGraphCurrencyColumn object itself.
     */
    public MicrosoftGraphCurrencyColumn withLocale(String locale) {
        this.locale = locale;
        return this;
    }

    /**
     * Get the additionalProperties property: currencyColumn.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: currencyColumn.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphCurrencyColumn object itself.
     */
    public MicrosoftGraphCurrencyColumn withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
