// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** emailAddress. */
@Fluent
public final class MicrosoftGraphEmailAddress {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphEmailAddress.class);

    /*
     * The email address of the person or entity.
     */
    @JsonProperty(value = "address")
    private String address;

    /*
     * The display name of the person or entity.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * emailAddress
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the address property: The email address of the person or entity.
     *
     * @return the address value.
     */
    public String address() {
        return this.address;
    }

    /**
     * Set the address property: The email address of the person or entity.
     *
     * @param address the address value to set.
     * @return the MicrosoftGraphEmailAddress object itself.
     */
    public MicrosoftGraphEmailAddress withAddress(String address) {
        this.address = address;
        return this;
    }

    /**
     * Get the name property: The display name of the person or entity.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The display name of the person or entity.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphEmailAddress object itself.
     */
    public MicrosoftGraphEmailAddress withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the additionalProperties property: emailAddress.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: emailAddress.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphEmailAddress object itself.
     */
    public MicrosoftGraphEmailAddress withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
