// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** folderView. */
@Fluent
public final class MicrosoftGraphFolderView {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphFolderView.class);

    /*
     * The method by which the folder should be sorted.
     */
    @JsonProperty(value = "sortBy")
    private String sortBy;

    /*
     * If true, indicates that items should be sorted in descending order.
     * Otherwise, items should be sorted ascending.
     */
    @JsonProperty(value = "sortOrder")
    private String sortOrder;

    /*
     * The type of view that should be used to represent the folder.
     */
    @JsonProperty(value = "viewType")
    private String viewType;

    /*
     * folderView
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the sortBy property: The method by which the folder should be sorted.
     *
     * @return the sortBy value.
     */
    public String sortBy() {
        return this.sortBy;
    }

    /**
     * Set the sortBy property: The method by which the folder should be sorted.
     *
     * @param sortBy the sortBy value to set.
     * @return the MicrosoftGraphFolderView object itself.
     */
    public MicrosoftGraphFolderView withSortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    /**
     * Get the sortOrder property: If true, indicates that items should be sorted in descending order. Otherwise, items
     * should be sorted ascending.
     *
     * @return the sortOrder value.
     */
    public String sortOrder() {
        return this.sortOrder;
    }

    /**
     * Set the sortOrder property: If true, indicates that items should be sorted in descending order. Otherwise, items
     * should be sorted ascending.
     *
     * @param sortOrder the sortOrder value to set.
     * @return the MicrosoftGraphFolderView object itself.
     */
    public MicrosoftGraphFolderView withSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    /**
     * Get the viewType property: The type of view that should be used to represent the folder.
     *
     * @return the viewType value.
     */
    public String viewType() {
        return this.viewType;
    }

    /**
     * Set the viewType property: The type of view that should be used to represent the folder.
     *
     * @param viewType the viewType value to set.
     * @return the MicrosoftGraphFolderView object itself.
     */
    public MicrosoftGraphFolderView withViewType(String viewType) {
        this.viewType = viewType;
        return this;
    }

    /**
     * Get the additionalProperties property: folderView.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: folderView.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphFolderView object itself.
     */
    public MicrosoftGraphFolderView withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
