// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** followupFlag. */
@Fluent
public final class MicrosoftGraphFollowupFlag {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphFollowupFlag.class);

    /*
     * dateTimeTimeZone
     */
    @JsonProperty(value = "completedDateTime")
    private MicrosoftGraphDateTimeZone completedDateTime;

    /*
     * dateTimeTimeZone
     */
    @JsonProperty(value = "dueDateTime")
    private MicrosoftGraphDateTimeZone dueDateTime;

    /*
     * The flagStatus property.
     */
    @JsonProperty(value = "flagStatus")
    private MicrosoftGraphFollowupFlagStatus flagStatus;

    /*
     * dateTimeTimeZone
     */
    @JsonProperty(value = "startDateTime")
    private MicrosoftGraphDateTimeZone startDateTime;

    /*
     * followupFlag
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the completedDateTime property: dateTimeTimeZone.
     *
     * @return the completedDateTime value.
     */
    public MicrosoftGraphDateTimeZone completedDateTime() {
        return this.completedDateTime;
    }

    /**
     * Set the completedDateTime property: dateTimeTimeZone.
     *
     * @param completedDateTime the completedDateTime value to set.
     * @return the MicrosoftGraphFollowupFlag object itself.
     */
    public MicrosoftGraphFollowupFlag withCompletedDateTime(MicrosoftGraphDateTimeZone completedDateTime) {
        this.completedDateTime = completedDateTime;
        return this;
    }

    /**
     * Get the dueDateTime property: dateTimeTimeZone.
     *
     * @return the dueDateTime value.
     */
    public MicrosoftGraphDateTimeZone dueDateTime() {
        return this.dueDateTime;
    }

    /**
     * Set the dueDateTime property: dateTimeTimeZone.
     *
     * @param dueDateTime the dueDateTime value to set.
     * @return the MicrosoftGraphFollowupFlag object itself.
     */
    public MicrosoftGraphFollowupFlag withDueDateTime(MicrosoftGraphDateTimeZone dueDateTime) {
        this.dueDateTime = dueDateTime;
        return this;
    }

    /**
     * Get the flagStatus property: The flagStatus property.
     *
     * @return the flagStatus value.
     */
    public MicrosoftGraphFollowupFlagStatus flagStatus() {
        return this.flagStatus;
    }

    /**
     * Set the flagStatus property: The flagStatus property.
     *
     * @param flagStatus the flagStatus value to set.
     * @return the MicrosoftGraphFollowupFlag object itself.
     */
    public MicrosoftGraphFollowupFlag withFlagStatus(MicrosoftGraphFollowupFlagStatus flagStatus) {
        this.flagStatus = flagStatus;
        return this;
    }

    /**
     * Get the startDateTime property: dateTimeTimeZone.
     *
     * @return the startDateTime value.
     */
    public MicrosoftGraphDateTimeZone startDateTime() {
        return this.startDateTime;
    }

    /**
     * Set the startDateTime property: dateTimeTimeZone.
     *
     * @param startDateTime the startDateTime value to set.
     * @return the MicrosoftGraphFollowupFlag object itself.
     */
    public MicrosoftGraphFollowupFlag withStartDateTime(MicrosoftGraphDateTimeZone startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    /**
     * Get the additionalProperties property: followupFlag.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: followupFlag.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphFollowupFlag object itself.
     */
    public MicrosoftGraphFollowupFlag withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (completedDateTime() != null) {
            completedDateTime().validate();
        }
        if (dueDateTime() != null) {
            dueDateTime().validate();
        }
        if (startDateTime() != null) {
            startDateTime().validate();
        }
    }
}
