// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** openShiftChangeRequest. */
@Fluent
public final class MicrosoftGraphOpenShiftChangeRequest extends MicrosoftGraphScheduleChangeRequest {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphOpenShiftChangeRequest.class);

    /*
     * ID for the open shift.
     */
    @JsonProperty(value = "openShiftId")
    private String openShiftId;

    /*
     * openShiftChangeRequest
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the openShiftId property: ID for the open shift.
     *
     * @return the openShiftId value.
     */
    public String openShiftId() {
        return this.openShiftId;
    }

    /**
     * Set the openShiftId property: ID for the open shift.
     *
     * @param openShiftId the openShiftId value to set.
     * @return the MicrosoftGraphOpenShiftChangeRequest object itself.
     */
    public MicrosoftGraphOpenShiftChangeRequest withOpenShiftId(String openShiftId) {
        this.openShiftId = openShiftId;
        return this;
    }

    /**
     * Get the additionalProperties property: openShiftChangeRequest.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: openShiftChangeRequest.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOpenShiftChangeRequest object itself.
     */
    public MicrosoftGraphOpenShiftChangeRequest withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withAssignedTo(MicrosoftGraphScheduleChangeRequestActor assignedTo) {
        super.withAssignedTo(assignedTo);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withManagerActionDateTime(OffsetDateTime managerActionDateTime) {
        super.withManagerActionDateTime(managerActionDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withManagerActionMessage(String managerActionMessage) {
        super.withManagerActionMessage(managerActionMessage);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withManagerUserId(String managerUserId) {
        super.withManagerUserId(managerUserId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withSenderDateTime(OffsetDateTime senderDateTime) {
        super.withSenderDateTime(senderDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withSenderMessage(String senderMessage) {
        super.withSenderMessage(senderMessage);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withSenderUserId(String senderUserId) {
        super.withSenderUserId(senderUserId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withState(MicrosoftGraphScheduleChangeState state) {
        super.withState(state);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOpenShiftChangeRequest withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
