// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Represents an Azure Active Directory object. The directoryObject type is the base type for many other directory
 * entity types.
 */
@Fluent
public final class MicrosoftGraphServicePrincipalInner extends MicrosoftGraphDirectoryObjectInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphServicePrincipalInner.class);

    /*
     * true if the service principal account is enabled; otherwise, false.
     */
    @JsonProperty(value = "accountEnabled")
    private Boolean accountEnabled;

    /*
     * Defines custom behavior that a consuming service can use to call an app
     * in specific contexts. For example, applications that can render file
     * streams may set the addIns property for its 'FileHandler' functionality.
     * This will let services like Microsoft 365 call the application in the
     * context of a document the user is working on.
     */
    @JsonProperty(value = "addIns")
    private List<MicrosoftGraphAddIn> addIns;

    /*
     * Used to retrieve service principals by subscription, identify resource
     * group and full resource ids for managed identities.
     */
    @JsonProperty(value = "alternativeNames")
    private List<String> alternativeNames;

    /*
     * The appDescription property.
     */
    @JsonProperty(value = "appDescription")
    private String appDescription;

    /*
     * The display name exposed by the associated application.
     */
    @JsonProperty(value = "appDisplayName")
    private String appDisplayName;

    /*
     * The unique identifier for the associated application (its appId
     * property).
     */
    @JsonProperty(value = "appId")
    private String appId;

    /*
     * Unique identifier of the applicationTemplate that the servicePrincipal
     * was created from. Read-only.
     */
    @JsonProperty(value = "applicationTemplateId")
    private String applicationTemplateId;

    /*
     * Contains the tenant id where the application is registered. This is
     * applicable only to service principals backed by applications.
     */
    @JsonProperty(value = "appOwnerOrganizationId")
    private UUID appOwnerOrganizationId;

    /*
     * Specifies whether users or other service principals need to be granted
     * an app role assignment for this service principal before users can sign
     * in or apps can get tokens. The default value is false. Not nullable.
     */
    @JsonProperty(value = "appRoleAssignmentRequired")
    private Boolean appRoleAssignmentRequired;

    /*
     * The roles exposed by the application which this service principal
     * represents. For more information see the appRoles property definition on
     * the application entity. Not nullable.
     */
    @JsonProperty(value = "appRoles")
    private List<MicrosoftGraphAppRole> appRoles;

    /*
     * The description property.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The display name for the service principal.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * Home page or landing page of the application.
     */
    @JsonProperty(value = "homepage")
    private String homepage;

    /*
     * informationalUrl
     */
    @JsonProperty(value = "info")
    private MicrosoftGraphInformationalUrl info;

    /*
     * The collection of key credentials associated with the service principal.
     * Not nullable.
     */
    @JsonProperty(value = "keyCredentials")
    private List<MicrosoftGraphKeyCredentialInner> keyCredentials;

    /*
     * Specifies the URL where the service provider redirects the user to Azure
     * AD to authenticate. Azure AD uses the URL to launch the application from
     * Microsoft 365 or the Azure AD My Apps. When blank, Azure AD performs
     * IdP-initiated sign-on for applications configured with SAML-based single
     * sign-on. The user launches the application from Microsoft 365, the Azure
     * AD My Apps, or the Azure AD SSO URL.
     */
    @JsonProperty(value = "loginUrl")
    private String loginUrl;

    /*
     * Specifies the URL that will be used by Microsoft's authorization service
     * to logout an user using OpenId Connect front-channel, back-channel or
     * SAML logout protocols.
     */
    @JsonProperty(value = "logoutUrl")
    private String logoutUrl;

    /*
     * The notes property.
     */
    @JsonProperty(value = "notes")
    private String notes;

    /*
     * Specifies the list of email addresses where Azure AD sends a
     * notification when the active certificate is near the expiration date.
     * This is only for the certificates used to sign the SAML token issued for
     * Azure AD Gallery applications.
     */
    @JsonProperty(value = "notificationEmailAddresses")
    private List<String> notificationEmailAddresses;

    /*
     * The delegated permissions exposed by the application. For more
     * information see the oauth2PermissionScopes property on the application
     * entity's api property. Not nullable.
     */
    @JsonProperty(value = "oauth2PermissionScopes")
    private List<MicrosoftGraphPermissionScope> oauth2PermissionScopes;

    /*
     * The collection of password credentials associated with the service
     * principal. Not nullable.
     */
    @JsonProperty(value = "passwordCredentials")
    private List<MicrosoftGraphPasswordCredentialInner> passwordCredentials;

    /*
     * Specifies the single sign-on mode configured for this application. Azure
     * AD uses the preferred single sign-on mode to launch the application from
     * Microsoft 365 or the Azure AD My Apps. The supported values are
     * password, saml, external, and oidc.
     */
    @JsonProperty(value = "preferredSingleSignOnMode")
    private String preferredSingleSignOnMode;

    /*
     * The preferredTokenSigningKeyThumbprint property.
     */
    @JsonProperty(value = "preferredTokenSigningKeyThumbprint")
    private String preferredTokenSigningKeyThumbprint;

    /*
     * The URLs that user tokens are sent to for sign in with the associated
     * application, or the redirect URIs that OAuth 2.0 authorization codes and
     * access tokens are sent to for the associated application. Not nullable.
     */
    @JsonProperty(value = "replyUrls")
    private List<String> replyUrls;

    /*
     * samlSingleSignOnSettings
     */
    @JsonProperty(value = "samlSingleSignOnSettings")
    private MicrosoftGraphSamlSingleSignOnSettings samlSingleSignOnSettings;

    /*
     * Contains the list of identifiersUris, copied over from the associated
     * application. Additional values can be added to hybrid applications.
     * These values can be used to identify the permissions exposed by this app
     * within Azure AD. For example,Client apps can specify a resource URI
     * which is based on the values of this property to acquire an access
     * token, which is the URI returned in the 'aud' claim.The any operator is
     * required for filter expressions on multi-valued properties. Not
     * nullable.
     */
    @JsonProperty(value = "servicePrincipalNames")
    private List<String> servicePrincipalNames;

    /*
     * Identifies if the service principal represents an application or a
     * managed identity. This is set by Azure AD internally. For a service
     * principal that represents an application this is set as Application. For
     * a service principal that represent a managed identity this is set as
     * ManagedIdentity.
     */
    @JsonProperty(value = "servicePrincipalType")
    private String servicePrincipalType;

    /*
     * The signInAudience property.
     */
    @JsonProperty(value = "signInAudience")
    private String signInAudience;

    /*
     * Custom strings that can be used to categorize and identify the service
     * principal. Not nullable.
     */
    @JsonProperty(value = "tags")
    private List<String> tags;

    /*
     * Specifies the keyId of a public key from the keyCredentials collection.
     * When configured, Azure AD issues tokens for this application encrypted
     * using the key specified by this property. The application code that
     * receives the encrypted token must use the matching private key to
     * decrypt the token before it can be used for the signed-in user.
     */
    @JsonProperty(value = "tokenEncryptionKeyId")
    private UUID tokenEncryptionKeyId;

    /*
     * Principals (users, groups, and service principals) that are assigned to
     * this service principal. Read-only.
     */
    @JsonProperty(value = "appRoleAssignedTo")
    private List<MicrosoftGraphAppRoleAssignmentInner> appRoleAssignedTo;

    /*
     * Applications that this service principal is assigned to. Read-only.
     * Nullable.
     */
    @JsonProperty(value = "appRoleAssignments")
    private List<MicrosoftGraphAppRoleAssignmentInner> appRoleAssignments;

    /*
     * The claimsMappingPolicies assigned to this service principal.
     */
    @JsonProperty(value = "claimsMappingPolicies")
    private List<MicrosoftGraphClaimsMappingPolicyInner> claimsMappingPolicies;

    /*
     * Directory objects created by this service principal. Read-only.
     * Nullable.
     */
    @JsonProperty(value = "createdObjects")
    private List<MicrosoftGraphDirectoryObjectInner> createdObjects;

    /*
     * The delegatedPermissionClassifications property.
     */
    @JsonProperty(value = "delegatedPermissionClassifications")
    private List<MicrosoftGraphDelegatedPermissionClassificationInner> delegatedPermissionClassifications;

    /*
     * Endpoints available for discovery. Services like Sharepoint populate
     * this property with a tenant specific SharePoint endpoints that other
     * applications can discover and use in their experiences.
     */
    @JsonProperty(value = "endpoints")
    private List<MicrosoftGraphEndpointInner> endpoints;

    /*
     * The homeRealmDiscoveryPolicies assigned to this service principal.
     */
    @JsonProperty(value = "homeRealmDiscoveryPolicies")
    private List<MicrosoftGraphHomeRealmDiscoveryPolicyInner> homeRealmDiscoveryPolicies;

    /*
     * Roles that this service principal is a member of. HTTP Methods: GET
     * Read-only. Nullable.
     */
    @JsonProperty(value = "memberOf")
    private List<MicrosoftGraphDirectoryObjectInner> memberOf;

    /*
     * Delegated permission grants authorizing this service principal to access
     * an API on behalf of a signed-in user. Read-only. Nullable.
     */
    @JsonProperty(value = "oauth2PermissionGrants")
    private List<MicrosoftGraphOAuth2PermissionGrantInner> oauth2PermissionGrants;

    /*
     * Directory objects that are owned by this service principal. Read-only.
     * Nullable.
     */
    @JsonProperty(value = "ownedObjects")
    private List<MicrosoftGraphDirectoryObjectInner> ownedObjects;

    /*
     * Directory objects that are owners of this servicePrincipal. The owners
     * are a set of non-admin users or servicePrincipals who are allowed to
     * modify this object. Read-only. Nullable.
     */
    @JsonProperty(value = "owners")
    private List<MicrosoftGraphDirectoryObjectInner> owners;

    /*
     * The tokenIssuancePolicies assigned to this service principal.
     */
    @JsonProperty(value = "tokenIssuancePolicies")
    private List<MicrosoftGraphTokenIssuancePolicyInner> tokenIssuancePolicies;

    /*
     * The tokenLifetimePolicies assigned to this service principal.
     */
    @JsonProperty(value = "tokenLifetimePolicies")
    private List<MicrosoftGraphTokenLifetimePolicyInner> tokenLifetimePolicies;

    /*
     * The transitiveMemberOf property.
     */
    @JsonProperty(value = "transitiveMemberOf")
    private List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf;

    /*
     * Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the accountEnabled property: true if the service principal account is enabled; otherwise, false.
     *
     * @return the accountEnabled value.
     */
    public Boolean accountEnabled() {
        return this.accountEnabled;
    }

    /**
     * Set the accountEnabled property: true if the service principal account is enabled; otherwise, false.
     *
     * @param accountEnabled the accountEnabled value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAccountEnabled(Boolean accountEnabled) {
        this.accountEnabled = accountEnabled;
        return this;
    }

    /**
     * Get the addIns property: Defines custom behavior that a consuming service can use to call an app in specific
     * contexts. For example, applications that can render file streams may set the addIns property for its
     * 'FileHandler' functionality. This will let services like Microsoft 365 call the application in the context of a
     * document the user is working on.
     *
     * @return the addIns value.
     */
    public List<MicrosoftGraphAddIn> addIns() {
        return this.addIns;
    }

    /**
     * Set the addIns property: Defines custom behavior that a consuming service can use to call an app in specific
     * contexts. For example, applications that can render file streams may set the addIns property for its
     * 'FileHandler' functionality. This will let services like Microsoft 365 call the application in the context of a
     * document the user is working on.
     *
     * @param addIns the addIns value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAddIns(List<MicrosoftGraphAddIn> addIns) {
        this.addIns = addIns;
        return this;
    }

    /**
     * Get the alternativeNames property: Used to retrieve service principals by subscription, identify resource group
     * and full resource ids for managed identities.
     *
     * @return the alternativeNames value.
     */
    public List<String> alternativeNames() {
        return this.alternativeNames;
    }

    /**
     * Set the alternativeNames property: Used to retrieve service principals by subscription, identify resource group
     * and full resource ids for managed identities.
     *
     * @param alternativeNames the alternativeNames value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAlternativeNames(List<String> alternativeNames) {
        this.alternativeNames = alternativeNames;
        return this;
    }

    /**
     * Get the appDescription property: The appDescription property.
     *
     * @return the appDescription value.
     */
    public String appDescription() {
        return this.appDescription;
    }

    /**
     * Set the appDescription property: The appDescription property.
     *
     * @param appDescription the appDescription value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAppDescription(String appDescription) {
        this.appDescription = appDescription;
        return this;
    }

    /**
     * Get the appDisplayName property: The display name exposed by the associated application.
     *
     * @return the appDisplayName value.
     */
    public String appDisplayName() {
        return this.appDisplayName;
    }

    /**
     * Set the appDisplayName property: The display name exposed by the associated application.
     *
     * @param appDisplayName the appDisplayName value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAppDisplayName(String appDisplayName) {
        this.appDisplayName = appDisplayName;
        return this;
    }

    /**
     * Get the appId property: The unique identifier for the associated application (its appId property).
     *
     * @return the appId value.
     */
    public String appId() {
        return this.appId;
    }

    /**
     * Set the appId property: The unique identifier for the associated application (its appId property).
     *
     * @param appId the appId value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    /**
     * Get the applicationTemplateId property: Unique identifier of the applicationTemplate that the servicePrincipal
     * was created from. Read-only.
     *
     * @return the applicationTemplateId value.
     */
    public String applicationTemplateId() {
        return this.applicationTemplateId;
    }

    /**
     * Set the applicationTemplateId property: Unique identifier of the applicationTemplate that the servicePrincipal
     * was created from. Read-only.
     *
     * @param applicationTemplateId the applicationTemplateId value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withApplicationTemplateId(String applicationTemplateId) {
        this.applicationTemplateId = applicationTemplateId;
        return this;
    }

    /**
     * Get the appOwnerOrganizationId property: Contains the tenant id where the application is registered. This is
     * applicable only to service principals backed by applications.
     *
     * @return the appOwnerOrganizationId value.
     */
    public UUID appOwnerOrganizationId() {
        return this.appOwnerOrganizationId;
    }

    /**
     * Set the appOwnerOrganizationId property: Contains the tenant id where the application is registered. This is
     * applicable only to service principals backed by applications.
     *
     * @param appOwnerOrganizationId the appOwnerOrganizationId value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAppOwnerOrganizationId(UUID appOwnerOrganizationId) {
        this.appOwnerOrganizationId = appOwnerOrganizationId;
        return this;
    }

    /**
     * Get the appRoleAssignmentRequired property: Specifies whether users or other service principals need to be
     * granted an app role assignment for this service principal before users can sign in or apps can get tokens. The
     * default value is false. Not nullable.
     *
     * @return the appRoleAssignmentRequired value.
     */
    public Boolean appRoleAssignmentRequired() {
        return this.appRoleAssignmentRequired;
    }

    /**
     * Set the appRoleAssignmentRequired property: Specifies whether users or other service principals need to be
     * granted an app role assignment for this service principal before users can sign in or apps can get tokens. The
     * default value is false. Not nullable.
     *
     * @param appRoleAssignmentRequired the appRoleAssignmentRequired value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAppRoleAssignmentRequired(Boolean appRoleAssignmentRequired) {
        this.appRoleAssignmentRequired = appRoleAssignmentRequired;
        return this;
    }

    /**
     * Get the appRoles property: The roles exposed by the application which this service principal represents. For more
     * information see the appRoles property definition on the application entity. Not nullable.
     *
     * @return the appRoles value.
     */
    public List<MicrosoftGraphAppRole> appRoles() {
        return this.appRoles;
    }

    /**
     * Set the appRoles property: The roles exposed by the application which this service principal represents. For more
     * information see the appRoles property definition on the application entity. Not nullable.
     *
     * @param appRoles the appRoles value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAppRoles(List<MicrosoftGraphAppRole> appRoles) {
        this.appRoles = appRoles;
        return this;
    }

    /**
     * Get the description property: The description property.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     *
     * @param description the description value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the displayName property: The display name for the service principal.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name for the service principal.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the homepage property: Home page or landing page of the application.
     *
     * @return the homepage value.
     */
    public String homepage() {
        return this.homepage;
    }

    /**
     * Set the homepage property: Home page or landing page of the application.
     *
     * @param homepage the homepage value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withHomepage(String homepage) {
        this.homepage = homepage;
        return this;
    }

    /**
     * Get the info property: informationalUrl.
     *
     * @return the info value.
     */
    public MicrosoftGraphInformationalUrl info() {
        return this.info;
    }

    /**
     * Set the info property: informationalUrl.
     *
     * @param info the info value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withInfo(MicrosoftGraphInformationalUrl info) {
        this.info = info;
        return this;
    }

    /**
     * Get the keyCredentials property: The collection of key credentials associated with the service principal. Not
     * nullable.
     *
     * @return the keyCredentials value.
     */
    public List<MicrosoftGraphKeyCredentialInner> keyCredentials() {
        return this.keyCredentials;
    }

    /**
     * Set the keyCredentials property: The collection of key credentials associated with the service principal. Not
     * nullable.
     *
     * @param keyCredentials the keyCredentials value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withKeyCredentials(
        List<MicrosoftGraphKeyCredentialInner> keyCredentials) {
        this.keyCredentials = keyCredentials;
        return this;
    }

    /**
     * Get the loginUrl property: Specifies the URL where the service provider redirects the user to Azure AD to
     * authenticate. Azure AD uses the URL to launch the application from Microsoft 365 or the Azure AD My Apps. When
     * blank, Azure AD performs IdP-initiated sign-on for applications configured with SAML-based single sign-on. The
     * user launches the application from Microsoft 365, the Azure AD My Apps, or the Azure AD SSO URL.
     *
     * @return the loginUrl value.
     */
    public String loginUrl() {
        return this.loginUrl;
    }

    /**
     * Set the loginUrl property: Specifies the URL where the service provider redirects the user to Azure AD to
     * authenticate. Azure AD uses the URL to launch the application from Microsoft 365 or the Azure AD My Apps. When
     * blank, Azure AD performs IdP-initiated sign-on for applications configured with SAML-based single sign-on. The
     * user launches the application from Microsoft 365, the Azure AD My Apps, or the Azure AD SSO URL.
     *
     * @param loginUrl the loginUrl value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
        return this;
    }

    /**
     * Get the logoutUrl property: Specifies the URL that will be used by Microsoft's authorization service to logout an
     * user using OpenId Connect front-channel, back-channel or SAML logout protocols.
     *
     * @return the logoutUrl value.
     */
    public String logoutUrl() {
        return this.logoutUrl;
    }

    /**
     * Set the logoutUrl property: Specifies the URL that will be used by Microsoft's authorization service to logout an
     * user using OpenId Connect front-channel, back-channel or SAML logout protocols.
     *
     * @param logoutUrl the logoutUrl value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    /**
     * Get the notes property: The notes property.
     *
     * @return the notes value.
     */
    public String notes() {
        return this.notes;
    }

    /**
     * Set the notes property: The notes property.
     *
     * @param notes the notes value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    /**
     * Get the notificationEmailAddresses property: Specifies the list of email addresses where Azure AD sends a
     * notification when the active certificate is near the expiration date. This is only for the certificates used to
     * sign the SAML token issued for Azure AD Gallery applications.
     *
     * @return the notificationEmailAddresses value.
     */
    public List<String> notificationEmailAddresses() {
        return this.notificationEmailAddresses;
    }

    /**
     * Set the notificationEmailAddresses property: Specifies the list of email addresses where Azure AD sends a
     * notification when the active certificate is near the expiration date. This is only for the certificates used to
     * sign the SAML token issued for Azure AD Gallery applications.
     *
     * @param notificationEmailAddresses the notificationEmailAddresses value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withNotificationEmailAddresses(List<String> notificationEmailAddresses) {
        this.notificationEmailAddresses = notificationEmailAddresses;
        return this;
    }

    /**
     * Get the oauth2PermissionScopes property: The delegated permissions exposed by the application. For more
     * information see the oauth2PermissionScopes property on the application entity's api property. Not nullable.
     *
     * @return the oauth2PermissionScopes value.
     */
    public List<MicrosoftGraphPermissionScope> oauth2PermissionScopes() {
        return this.oauth2PermissionScopes;
    }

    /**
     * Set the oauth2PermissionScopes property: The delegated permissions exposed by the application. For more
     * information see the oauth2PermissionScopes property on the application entity's api property. Not nullable.
     *
     * @param oauth2PermissionScopes the oauth2PermissionScopes value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withOauth2PermissionScopes(
        List<MicrosoftGraphPermissionScope> oauth2PermissionScopes) {
        this.oauth2PermissionScopes = oauth2PermissionScopes;
        return this;
    }

    /**
     * Get the passwordCredentials property: The collection of password credentials associated with the service
     * principal. Not nullable.
     *
     * @return the passwordCredentials value.
     */
    public List<MicrosoftGraphPasswordCredentialInner> passwordCredentials() {
        return this.passwordCredentials;
    }

    /**
     * Set the passwordCredentials property: The collection of password credentials associated with the service
     * principal. Not nullable.
     *
     * @param passwordCredentials the passwordCredentials value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withPasswordCredentials(
        List<MicrosoftGraphPasswordCredentialInner> passwordCredentials) {
        this.passwordCredentials = passwordCredentials;
        return this;
    }

    /**
     * Get the preferredSingleSignOnMode property: Specifies the single sign-on mode configured for this application.
     * Azure AD uses the preferred single sign-on mode to launch the application from Microsoft 365 or the Azure AD My
     * Apps. The supported values are password, saml, external, and oidc.
     *
     * @return the preferredSingleSignOnMode value.
     */
    public String preferredSingleSignOnMode() {
        return this.preferredSingleSignOnMode;
    }

    /**
     * Set the preferredSingleSignOnMode property: Specifies the single sign-on mode configured for this application.
     * Azure AD uses the preferred single sign-on mode to launch the application from Microsoft 365 or the Azure AD My
     * Apps. The supported values are password, saml, external, and oidc.
     *
     * @param preferredSingleSignOnMode the preferredSingleSignOnMode value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withPreferredSingleSignOnMode(String preferredSingleSignOnMode) {
        this.preferredSingleSignOnMode = preferredSingleSignOnMode;
        return this;
    }

    /**
     * Get the preferredTokenSigningKeyThumbprint property: The preferredTokenSigningKeyThumbprint property.
     *
     * @return the preferredTokenSigningKeyThumbprint value.
     */
    public String preferredTokenSigningKeyThumbprint() {
        return this.preferredTokenSigningKeyThumbprint;
    }

    /**
     * Set the preferredTokenSigningKeyThumbprint property: The preferredTokenSigningKeyThumbprint property.
     *
     * @param preferredTokenSigningKeyThumbprint the preferredTokenSigningKeyThumbprint value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withPreferredTokenSigningKeyThumbprint(
        String preferredTokenSigningKeyThumbprint) {
        this.preferredTokenSigningKeyThumbprint = preferredTokenSigningKeyThumbprint;
        return this;
    }

    /**
     * Get the replyUrls property: The URLs that user tokens are sent to for sign in with the associated application, or
     * the redirect URIs that OAuth 2.0 authorization codes and access tokens are sent to for the associated
     * application. Not nullable.
     *
     * @return the replyUrls value.
     */
    public List<String> replyUrls() {
        return this.replyUrls;
    }

    /**
     * Set the replyUrls property: The URLs that user tokens are sent to for sign in with the associated application, or
     * the redirect URIs that OAuth 2.0 authorization codes and access tokens are sent to for the associated
     * application. Not nullable.
     *
     * @param replyUrls the replyUrls value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withReplyUrls(List<String> replyUrls) {
        this.replyUrls = replyUrls;
        return this;
    }

    /**
     * Get the samlSingleSignOnSettings property: samlSingleSignOnSettings.
     *
     * @return the samlSingleSignOnSettings value.
     */
    public MicrosoftGraphSamlSingleSignOnSettings samlSingleSignOnSettings() {
        return this.samlSingleSignOnSettings;
    }

    /**
     * Set the samlSingleSignOnSettings property: samlSingleSignOnSettings.
     *
     * @param samlSingleSignOnSettings the samlSingleSignOnSettings value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withSamlSingleSignOnSettings(
        MicrosoftGraphSamlSingleSignOnSettings samlSingleSignOnSettings) {
        this.samlSingleSignOnSettings = samlSingleSignOnSettings;
        return this;
    }

    /**
     * Get the servicePrincipalNames property: Contains the list of identifiersUris, copied over from the associated
     * application. Additional values can be added to hybrid applications. These values can be used to identify the
     * permissions exposed by this app within Azure AD. For example,Client apps can specify a resource URI which is
     * based on the values of this property to acquire an access token, which is the URI returned in the 'aud' claim.The
     * any operator is required for filter expressions on multi-valued properties. Not nullable.
     *
     * @return the servicePrincipalNames value.
     */
    public List<String> servicePrincipalNames() {
        return this.servicePrincipalNames;
    }

    /**
     * Set the servicePrincipalNames property: Contains the list of identifiersUris, copied over from the associated
     * application. Additional values can be added to hybrid applications. These values can be used to identify the
     * permissions exposed by this app within Azure AD. For example,Client apps can specify a resource URI which is
     * based on the values of this property to acquire an access token, which is the URI returned in the 'aud' claim.The
     * any operator is required for filter expressions on multi-valued properties. Not nullable.
     *
     * @param servicePrincipalNames the servicePrincipalNames value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withServicePrincipalNames(List<String> servicePrincipalNames) {
        this.servicePrincipalNames = servicePrincipalNames;
        return this;
    }

    /**
     * Get the servicePrincipalType property: Identifies if the service principal represents an application or a managed
     * identity. This is set by Azure AD internally. For a service principal that represents an application this is set
     * as Application. For a service principal that represent a managed identity this is set as ManagedIdentity.
     *
     * @return the servicePrincipalType value.
     */
    public String servicePrincipalType() {
        return this.servicePrincipalType;
    }

    /**
     * Set the servicePrincipalType property: Identifies if the service principal represents an application or a managed
     * identity. This is set by Azure AD internally. For a service principal that represents an application this is set
     * as Application. For a service principal that represent a managed identity this is set as ManagedIdentity.
     *
     * @param servicePrincipalType the servicePrincipalType value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withServicePrincipalType(String servicePrincipalType) {
        this.servicePrincipalType = servicePrincipalType;
        return this;
    }

    /**
     * Get the signInAudience property: The signInAudience property.
     *
     * @return the signInAudience value.
     */
    public String signInAudience() {
        return this.signInAudience;
    }

    /**
     * Set the signInAudience property: The signInAudience property.
     *
     * @param signInAudience the signInAudience value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withSignInAudience(String signInAudience) {
        this.signInAudience = signInAudience;
        return this;
    }

    /**
     * Get the tags property: Custom strings that can be used to categorize and identify the service principal. Not
     * nullable.
     *
     * @return the tags value.
     */
    public List<String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: Custom strings that can be used to categorize and identify the service principal. Not
     * nullable.
     *
     * @param tags the tags value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the tokenEncryptionKeyId property: Specifies the keyId of a public key from the keyCredentials collection.
     * When configured, Azure AD issues tokens for this application encrypted using the key specified by this property.
     * The application code that receives the encrypted token must use the matching private key to decrypt the token
     * before it can be used for the signed-in user.
     *
     * @return the tokenEncryptionKeyId value.
     */
    public UUID tokenEncryptionKeyId() {
        return this.tokenEncryptionKeyId;
    }

    /**
     * Set the tokenEncryptionKeyId property: Specifies the keyId of a public key from the keyCredentials collection.
     * When configured, Azure AD issues tokens for this application encrypted using the key specified by this property.
     * The application code that receives the encrypted token must use the matching private key to decrypt the token
     * before it can be used for the signed-in user.
     *
     * @param tokenEncryptionKeyId the tokenEncryptionKeyId value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withTokenEncryptionKeyId(UUID tokenEncryptionKeyId) {
        this.tokenEncryptionKeyId = tokenEncryptionKeyId;
        return this;
    }

    /**
     * Get the appRoleAssignedTo property: Principals (users, groups, and service principals) that are assigned to this
     * service principal. Read-only.
     *
     * @return the appRoleAssignedTo value.
     */
    public List<MicrosoftGraphAppRoleAssignmentInner> appRoleAssignedTo() {
        return this.appRoleAssignedTo;
    }

    /**
     * Set the appRoleAssignedTo property: Principals (users, groups, and service principals) that are assigned to this
     * service principal. Read-only.
     *
     * @param appRoleAssignedTo the appRoleAssignedTo value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAppRoleAssignedTo(
        List<MicrosoftGraphAppRoleAssignmentInner> appRoleAssignedTo) {
        this.appRoleAssignedTo = appRoleAssignedTo;
        return this;
    }

    /**
     * Get the appRoleAssignments property: Applications that this service principal is assigned to. Read-only.
     * Nullable.
     *
     * @return the appRoleAssignments value.
     */
    public List<MicrosoftGraphAppRoleAssignmentInner> appRoleAssignments() {
        return this.appRoleAssignments;
    }

    /**
     * Set the appRoleAssignments property: Applications that this service principal is assigned to. Read-only.
     * Nullable.
     *
     * @param appRoleAssignments the appRoleAssignments value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAppRoleAssignments(
        List<MicrosoftGraphAppRoleAssignmentInner> appRoleAssignments) {
        this.appRoleAssignments = appRoleAssignments;
        return this;
    }

    /**
     * Get the claimsMappingPolicies property: The claimsMappingPolicies assigned to this service principal.
     *
     * @return the claimsMappingPolicies value.
     */
    public List<MicrosoftGraphClaimsMappingPolicyInner> claimsMappingPolicies() {
        return this.claimsMappingPolicies;
    }

    /**
     * Set the claimsMappingPolicies property: The claimsMappingPolicies assigned to this service principal.
     *
     * @param claimsMappingPolicies the claimsMappingPolicies value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withClaimsMappingPolicies(
        List<MicrosoftGraphClaimsMappingPolicyInner> claimsMappingPolicies) {
        this.claimsMappingPolicies = claimsMappingPolicies;
        return this;
    }

    /**
     * Get the createdObjects property: Directory objects created by this service principal. Read-only. Nullable.
     *
     * @return the createdObjects value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> createdObjects() {
        return this.createdObjects;
    }

    /**
     * Set the createdObjects property: Directory objects created by this service principal. Read-only. Nullable.
     *
     * @param createdObjects the createdObjects value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withCreatedObjects(
        List<MicrosoftGraphDirectoryObjectInner> createdObjects) {
        this.createdObjects = createdObjects;
        return this;
    }

    /**
     * Get the delegatedPermissionClassifications property: The delegatedPermissionClassifications property.
     *
     * @return the delegatedPermissionClassifications value.
     */
    public List<MicrosoftGraphDelegatedPermissionClassificationInner> delegatedPermissionClassifications() {
        return this.delegatedPermissionClassifications;
    }

    /**
     * Set the delegatedPermissionClassifications property: The delegatedPermissionClassifications property.
     *
     * @param delegatedPermissionClassifications the delegatedPermissionClassifications value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withDelegatedPermissionClassifications(
        List<MicrosoftGraphDelegatedPermissionClassificationInner> delegatedPermissionClassifications) {
        this.delegatedPermissionClassifications = delegatedPermissionClassifications;
        return this;
    }

    /**
     * Get the endpoints property: Endpoints available for discovery. Services like Sharepoint populate this property
     * with a tenant specific SharePoint endpoints that other applications can discover and use in their experiences.
     *
     * @return the endpoints value.
     */
    public List<MicrosoftGraphEndpointInner> endpoints() {
        return this.endpoints;
    }

    /**
     * Set the endpoints property: Endpoints available for discovery. Services like Sharepoint populate this property
     * with a tenant specific SharePoint endpoints that other applications can discover and use in their experiences.
     *
     * @param endpoints the endpoints value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withEndpoints(List<MicrosoftGraphEndpointInner> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    /**
     * Get the homeRealmDiscoveryPolicies property: The homeRealmDiscoveryPolicies assigned to this service principal.
     *
     * @return the homeRealmDiscoveryPolicies value.
     */
    public List<MicrosoftGraphHomeRealmDiscoveryPolicyInner> homeRealmDiscoveryPolicies() {
        return this.homeRealmDiscoveryPolicies;
    }

    /**
     * Set the homeRealmDiscoveryPolicies property: The homeRealmDiscoveryPolicies assigned to this service principal.
     *
     * @param homeRealmDiscoveryPolicies the homeRealmDiscoveryPolicies value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withHomeRealmDiscoveryPolicies(
        List<MicrosoftGraphHomeRealmDiscoveryPolicyInner> homeRealmDiscoveryPolicies) {
        this.homeRealmDiscoveryPolicies = homeRealmDiscoveryPolicies;
        return this;
    }

    /**
     * Get the memberOf property: Roles that this service principal is a member of. HTTP Methods: GET Read-only.
     * Nullable.
     *
     * @return the memberOf value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> memberOf() {
        return this.memberOf;
    }

    /**
     * Set the memberOf property: Roles that this service principal is a member of. HTTP Methods: GET Read-only.
     * Nullable.
     *
     * @param memberOf the memberOf value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withMemberOf(List<MicrosoftGraphDirectoryObjectInner> memberOf) {
        this.memberOf = memberOf;
        return this;
    }

    /**
     * Get the oauth2PermissionGrants property: Delegated permission grants authorizing this service principal to access
     * an API on behalf of a signed-in user. Read-only. Nullable.
     *
     * @return the oauth2PermissionGrants value.
     */
    public List<MicrosoftGraphOAuth2PermissionGrantInner> oauth2PermissionGrants() {
        return this.oauth2PermissionGrants;
    }

    /**
     * Set the oauth2PermissionGrants property: Delegated permission grants authorizing this service principal to access
     * an API on behalf of a signed-in user. Read-only. Nullable.
     *
     * @param oauth2PermissionGrants the oauth2PermissionGrants value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withOauth2PermissionGrants(
        List<MicrosoftGraphOAuth2PermissionGrantInner> oauth2PermissionGrants) {
        this.oauth2PermissionGrants = oauth2PermissionGrants;
        return this;
    }

    /**
     * Get the ownedObjects property: Directory objects that are owned by this service principal. Read-only. Nullable.
     *
     * @return the ownedObjects value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> ownedObjects() {
        return this.ownedObjects;
    }

    /**
     * Set the ownedObjects property: Directory objects that are owned by this service principal. Read-only. Nullable.
     *
     * @param ownedObjects the ownedObjects value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withOwnedObjects(List<MicrosoftGraphDirectoryObjectInner> ownedObjects) {
        this.ownedObjects = ownedObjects;
        return this;
    }

    /**
     * Get the owners property: Directory objects that are owners of this servicePrincipal. The owners are a set of
     * non-admin users or servicePrincipals who are allowed to modify this object. Read-only. Nullable.
     *
     * @return the owners value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> owners() {
        return this.owners;
    }

    /**
     * Set the owners property: Directory objects that are owners of this servicePrincipal. The owners are a set of
     * non-admin users or servicePrincipals who are allowed to modify this object. Read-only. Nullable.
     *
     * @param owners the owners value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withOwners(List<MicrosoftGraphDirectoryObjectInner> owners) {
        this.owners = owners;
        return this;
    }

    /**
     * Get the tokenIssuancePolicies property: The tokenIssuancePolicies assigned to this service principal.
     *
     * @return the tokenIssuancePolicies value.
     */
    public List<MicrosoftGraphTokenIssuancePolicyInner> tokenIssuancePolicies() {
        return this.tokenIssuancePolicies;
    }

    /**
     * Set the tokenIssuancePolicies property: The tokenIssuancePolicies assigned to this service principal.
     *
     * @param tokenIssuancePolicies the tokenIssuancePolicies value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withTokenIssuancePolicies(
        List<MicrosoftGraphTokenIssuancePolicyInner> tokenIssuancePolicies) {
        this.tokenIssuancePolicies = tokenIssuancePolicies;
        return this;
    }

    /**
     * Get the tokenLifetimePolicies property: The tokenLifetimePolicies assigned to this service principal.
     *
     * @return the tokenLifetimePolicies value.
     */
    public List<MicrosoftGraphTokenLifetimePolicyInner> tokenLifetimePolicies() {
        return this.tokenLifetimePolicies;
    }

    /**
     * Set the tokenLifetimePolicies property: The tokenLifetimePolicies assigned to this service principal.
     *
     * @param tokenLifetimePolicies the tokenLifetimePolicies value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withTokenLifetimePolicies(
        List<MicrosoftGraphTokenLifetimePolicyInner> tokenLifetimePolicies) {
        this.tokenLifetimePolicies = tokenLifetimePolicies;
        return this;
    }

    /**
     * Get the transitiveMemberOf property: The transitiveMemberOf property.
     *
     * @return the transitiveMemberOf value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf() {
        return this.transitiveMemberOf;
    }

    /**
     * Set the transitiveMemberOf property: The transitiveMemberOf property.
     *
     * @param transitiveMemberOf the transitiveMemberOf value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withTransitiveMemberOf(
        List<MicrosoftGraphDirectoryObjectInner> transitiveMemberOf) {
        this.transitiveMemberOf = transitiveMemberOf;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an Azure Active Directory object. The directoryObject type is
     * the base type for many other directory entity types.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphServicePrincipalInner object itself.
     */
    public MicrosoftGraphServicePrincipalInner withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphServicePrincipalInner withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphServicePrincipalInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (addIns() != null) {
            addIns().forEach(e -> e.validate());
        }
        if (appRoles() != null) {
            appRoles().forEach(e -> e.validate());
        }
        if (info() != null) {
            info().validate();
        }
        if (keyCredentials() != null) {
            keyCredentials().forEach(e -> e.validate());
        }
        if (oauth2PermissionScopes() != null) {
            oauth2PermissionScopes().forEach(e -> e.validate());
        }
        if (passwordCredentials() != null) {
            passwordCredentials().forEach(e -> e.validate());
        }
        if (samlSingleSignOnSettings() != null) {
            samlSingleSignOnSettings().validate();
        }
        if (appRoleAssignedTo() != null) {
            appRoleAssignedTo().forEach(e -> e.validate());
        }
        if (appRoleAssignments() != null) {
            appRoleAssignments().forEach(e -> e.validate());
        }
        if (claimsMappingPolicies() != null) {
            claimsMappingPolicies().forEach(e -> e.validate());
        }
        if (createdObjects() != null) {
            createdObjects().forEach(e -> e.validate());
        }
        if (delegatedPermissionClassifications() != null) {
            delegatedPermissionClassifications().forEach(e -> e.validate());
        }
        if (endpoints() != null) {
            endpoints().forEach(e -> e.validate());
        }
        if (homeRealmDiscoveryPolicies() != null) {
            homeRealmDiscoveryPolicies().forEach(e -> e.validate());
        }
        if (memberOf() != null) {
            memberOf().forEach(e -> e.validate());
        }
        if (oauth2PermissionGrants() != null) {
            oauth2PermissionGrants().forEach(e -> e.validate());
        }
        if (ownedObjects() != null) {
            ownedObjects().forEach(e -> e.validate());
        }
        if (owners() != null) {
            owners().forEach(e -> e.validate());
        }
        if (tokenIssuancePolicies() != null) {
            tokenIssuancePolicies().forEach(e -> e.validate());
        }
        if (tokenLifetimePolicies() != null) {
            tokenLifetimePolicies().forEach(e -> e.validate());
        }
        if (transitiveMemberOf() != null) {
            transitiveMemberOf().forEach(e -> e.validate());
        }
    }
}
