// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookFilter. */
@Fluent
public final class MicrosoftGraphWorkbookFilter extends MicrosoftGraphEntity {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MicrosoftGraphWorkbookFilter.class);

    /*
     * workbookFilterCriteria
     */
    @JsonProperty(value = "criteria")
    private MicrosoftGraphWorkbookFilterCriteria criteria;

    /*
     * workbookFilter
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the criteria property: workbookFilterCriteria.
     *
     * @return the criteria value.
     */
    public MicrosoftGraphWorkbookFilterCriteria criteria() {
        return this.criteria;
    }

    /**
     * Set the criteria property: workbookFilterCriteria.
     *
     * @param criteria the criteria value to set.
     * @return the MicrosoftGraphWorkbookFilter object itself.
     */
    public MicrosoftGraphWorkbookFilter withCriteria(MicrosoftGraphWorkbookFilterCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookFilter.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookFilter.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookFilter object itself.
     */
    public MicrosoftGraphWorkbookFilter withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookFilter withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (criteria() != null) {
            criteria().validate();
        }
    }
}
