// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for ServicePrincipalsSelect. */
public final class ServicePrincipalsSelect extends ExpandableStringEnum<ServicePrincipalsSelect> {
    /** Static value id for ServicePrincipalsSelect. */
    public static final ServicePrincipalsSelect ID = fromString("id");

    /** Static value deletedDateTime for ServicePrincipalsSelect. */
    public static final ServicePrincipalsSelect DELETED_DATE_TIME = fromString("deletedDateTime");

    /** Static value appRoleId for ServicePrincipalsSelect. */
    public static final ServicePrincipalsSelect APP_ROLE_ID = fromString("appRoleId");

    /** Static value createdDateTime for ServicePrincipalsSelect. */
    public static final ServicePrincipalsSelect CREATED_DATE_TIME = fromString("createdDateTime");

    /** Static value principalDisplayName for ServicePrincipalsSelect. */
    public static final ServicePrincipalsSelect PRINCIPAL_DISPLAY_NAME = fromString("principalDisplayName");

    /** Static value principalId for ServicePrincipalsSelect. */
    public static final ServicePrincipalsSelect PRINCIPAL_ID = fromString("principalId");

    /** Static value principalType for ServicePrincipalsSelect. */
    public static final ServicePrincipalsSelect PRINCIPAL_TYPE = fromString("principalType");

    /** Static value resourceDisplayName for ServicePrincipalsSelect. */
    public static final ServicePrincipalsSelect RESOURCE_DISPLAY_NAME = fromString("resourceDisplayName");

    /** Static value resourceId for ServicePrincipalsSelect. */
    public static final ServicePrincipalsSelect RESOURCE_ID = fromString("resourceId");

    /**
     * Creates or finds a ServicePrincipalsSelect from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ServicePrincipalsSelect.
     */
    @JsonCreator
    public static ServicePrincipalsSelect fromString(String name) {
        return fromString(name, ServicePrincipalsSelect.class);
    }

    /** @return known ServicePrincipalsSelect values. */
    public static Collection<ServicePrincipalsSelect> values() {
        return values(ServicePrincipalsSelect.class);
    }
}
