// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.ContactsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject0AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject1AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObjectAutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject0AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject1AutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObjectAutoGenerated2;
import com.azure.resourcemanager.authorization.fluent.models.ContactsCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsGetAvailableExtensionPropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsGetByIdsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContactsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.ContactsSelect;
import com.azure.resourcemanager.authorization.fluent.models.ContactsValidatePropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.Get1ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOrgContactInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ContactsClient. */
public final class ContactsClientImpl implements ContactsClient {
    private final ClientLogger logger = new ClientLogger(ContactsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final ContactsService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of ContactsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ContactsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = RestProxy.create(ContactsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientContacts to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface ContactsService {
        @Headers({"Content-Type: application/json"})
        @Get("/contacts/{orgContact-id}/directReports")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObjectAutoGenerated2>> listDirectReports(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/contacts/{orgContact-id}/directReports/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObjectAutoGenerated2>> listRefDirectReports(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts/{orgContact-id}/directReports/$ref")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Map<String, Object>>> createRefDirectReports(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/contacts/{orgContact-id}/manager")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryObjectInner>> getManager(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/contacts/{orgContact-id}/manager/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<String>> getRefManager(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put("/contacts/{orgContact-id}/manager/$ref")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> setRefManager(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete("/contacts/{orgContact-id}/manager/$ref")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> deleteRefManager(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @HeaderParam("If-Match") String ifMatch,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/contacts/{orgContact-id}/memberOf")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject0AutoGenerated2>> listMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/contacts/{orgContact-id}/memberOf/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject0AutoGenerated2>> listRefMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts/{orgContact-id}/memberOf/$ref")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Map<String, Object>>> createRefMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts/{orgContact-id}/microsoft.graph.checkMemberGroups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> checkMemberGroups(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @BodyParam("application/json") ContactsCheckMemberGroupsRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts/{orgContact-id}/microsoft.graph.checkMemberObjects")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> checkMemberObjects(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @BodyParam("application/json") ContactsCheckMemberObjectsRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts/{orgContact-id}/microsoft.graph.getMemberGroups")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> getMemberGroups(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @BodyParam("application/json") ContactsGetMemberGroupsRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts/{orgContact-id}/microsoft.graph.getMemberObjects")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<String>>> getMemberObjects(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @BodyParam("application/json") ContactsGetMemberObjectsRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts/{orgContact-id}/microsoft.graph.restore")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryObjectInner>> restore(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/contacts/{orgContact-id}/transitiveMemberOf")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject1AutoGenerated2>> listTransitiveMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/contacts/{orgContact-id}/transitiveMemberOf/$ref")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject1AutoGenerated2>> listRefTransitiveMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @QueryParam("$top") Integer top,
            @QueryParam("$skip") Integer skip,
            @QueryParam("$search") String search,
            @QueryParam("$filter") String filter,
            @QueryParam("$count") Boolean count,
            @QueryParam("$orderby") String orderby,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts/{orgContact-id}/transitiveMemberOf/$ref")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Map<String, Object>>> createRefTransitiveMemberOf(
            @HostParam("$host") String endpoint,
            @PathParam("orgContact-id") String orgContactId,
            @BodyParam("application/json") Map<String, Object> body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("/contacts/microsoft.graph.delta()")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<MicrosoftGraphOrgContactInner>>> delta(
            @HostParam("$host") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts/microsoft.graph.getAvailableExtensionProperties")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionProperties(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") ContactsGetAvailableExtensionPropertiesRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts/microsoft.graph.getByIds")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIds(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") ContactsGetByIdsRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post("/contacts/microsoft.graph.validateProperties")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> validateProperties(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") ContactsValidatePropertiesRequestBody body,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObjectAutoGenerated2>> listMore(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObjectAutoGenerated2>> listRefDirectReportsNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject0AutoGenerated2>> listMemberOfNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject0AutoGenerated2>> listRefMemberOfNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfDirectoryObject1AutoGenerated2>> listTransitiveMemberOfNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);

        @Headers({"Accept: application/json", "Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<CollectionOfLinksOfDirectoryObject1AutoGenerated2>> listRefTransitiveMemberOfNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, Context context);
    }

    /**
     * Get directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDirectReportsSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listDirectReports(
                            this.client.getEndpoint(),
                            orgContactId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDirectReportsSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listDirectReports(
                this.client.getEndpoint(),
                orgContactId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDirectReportsAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listDirectReportsSinglePageAsync(
                    orgContactId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDirectReportsAsync(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        final List<ContactsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listDirectReportsSinglePageAsync(
                    orgContactId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMoreSinglePageAsync(nextLink));
    }

    /**
     * Get directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listDirectReportsAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listDirectReportsSinglePageAsync(
                    orgContactId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMoreSinglePageAsync(nextLink, context));
    }

    /**
     * Get directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDirectReports(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        final List<ContactsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listDirectReportsAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDirectReports(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listDirectReportsAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Get ref of directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefDirectReportsSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRefDirectReports(
                            this.client.getEndpoint(),
                            orgContactId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefDirectReportsSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRefDirectReports(
                this.client.getEndpoint(),
                orgContactId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get ref of directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefDirectReportsAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby) {
        return new PagedFlux<>(
            () -> listRefDirectReportsSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby),
            nextLink -> listRefDirectReportsNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefDirectReportsAsync(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        return new PagedFlux<>(
            () -> listRefDirectReportsSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby),
            nextLink -> listRefDirectReportsNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefDirectReportsAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        Context context) {
        return new PagedFlux<>(
            () -> listRefDirectReportsSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, context),
            nextLink -> listRefDirectReportsNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefDirectReports(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        return new PagedIterable<>(listRefDirectReportsAsync(orgContactId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of directReports from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of directReports from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefDirectReports(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        Context context) {
        return new PagedIterable<>(
            listRefDirectReportsAsync(orgContactId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to directReports for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefDirectReportsWithResponseAsync(
        String orgContactId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.createRefDirectReports(this.client.getEndpoint(), orgContactId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property ref to directReports for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefDirectReportsWithResponseAsync(
        String orgContactId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefDirectReports(this.client.getEndpoint(), orgContactId, body, accept, context);
    }

    /**
     * Create new navigation property ref to directReports for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefDirectReportsAsync(String orgContactId, Map<String, Object> body) {
        return createRefDirectReportsWithResponseAsync(orgContactId, body)
            .flatMap(
                (Response<Map<String, Object>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property ref to directReports for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> createRefDirectReports(String orgContactId, Map<String, Object> body) {
        return createRefDirectReportsAsync(orgContactId, body).block();
    }

    /**
     * Create new navigation property ref to directReports for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefDirectReportsWithResponse(
        String orgContactId, Map<String, Object> body, Context context) {
        return createRefDirectReportsWithResponseAsync(orgContactId, body, context).block();
    }

    /**
     * Get manager from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manager from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getManagerWithResponseAsync(
        String orgContactId, List<Get1ItemsItem> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getManager(
                            this.client.getEndpoint(), orgContactId, selectConverted, expandConverted, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get manager from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manager from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getManagerWithResponseAsync(
        String orgContactId, List<Get1ItemsItem> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .getManager(this.client.getEndpoint(), orgContactId, selectConverted, expandConverted, accept, context);
    }

    /**
     * Get manager from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manager from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getManagerAsync(
        String orgContactId, List<Get1ItemsItem> select, List<String> expand) {
        return getManagerWithResponseAsync(orgContactId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get manager from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manager from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> getManagerAsync(String orgContactId) {
        final List<Get1ItemsItem> select = null;
        final List<String> expand = null;
        return getManagerWithResponseAsync(orgContactId, select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get manager from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manager from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner getManager(String orgContactId) {
        final List<Get1ItemsItem> select = null;
        final List<String> expand = null;
        return getManagerAsync(orgContactId, select, expand).block();
    }

    /**
     * Get manager from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return manager from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> getManagerWithResponse(
        String orgContactId, List<Get1ItemsItem> select, List<String> expand, Context context) {
        return getManagerWithResponseAsync(orgContactId, select, expand, context).block();
    }

    /**
     * Get ref of manager from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of manager from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<String>> getRefManagerWithResponseAsync(String orgContactId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getRefManager(this.client.getEndpoint(), orgContactId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of manager from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of manager from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<String>> getRefManagerWithResponseAsync(String orgContactId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getRefManager(this.client.getEndpoint(), orgContactId, accept, context);
    }

    /**
     * Get ref of manager from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of manager from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<String> getRefManagerAsync(String orgContactId) {
        return getRefManagerWithResponseAsync(orgContactId)
            .flatMap(
                (Response<String> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get ref of manager from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of manager from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public String getRefManager(String orgContactId) {
        return getRefManagerAsync(orgContactId).block();
    }

    /**
     * Get ref of manager from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of manager from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<String> getRefManagerWithResponse(String orgContactId, Context context) {
        return getRefManagerWithResponseAsync(orgContactId, context).block();
    }

    /**
     * Update the ref of navigation property manager in contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> setRefManagerWithResponseAsync(String orgContactId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.setRefManager(this.client.getEndpoint(), orgContactId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update the ref of navigation property manager in contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> setRefManagerWithResponseAsync(
        String orgContactId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.setRefManager(this.client.getEndpoint(), orgContactId, body, accept, context);
    }

    /**
     * Update the ref of navigation property manager in contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> setRefManagerAsync(String orgContactId, Map<String, Object> body) {
        return setRefManagerWithResponseAsync(orgContactId, body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update the ref of navigation property manager in contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void setRefManager(String orgContactId, Map<String, Object> body) {
        setRefManagerAsync(orgContactId, body).block();
    }

    /**
     * Update the ref of navigation property manager in contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> setRefManagerWithResponse(String orgContactId, Map<String, Object> body, Context context) {
        return setRefManagerWithResponseAsync(orgContactId, body, context).block();
    }

    /**
     * Delete ref of navigation property manager for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRefManagerWithResponseAsync(String orgContactId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.deleteRefManager(this.client.getEndpoint(), orgContactId, ifMatch, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Delete ref of navigation property manager for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteRefManagerWithResponseAsync(
        String orgContactId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteRefManager(this.client.getEndpoint(), orgContactId, ifMatch, accept, context);
    }

    /**
     * Delete ref of navigation property manager for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param ifMatch ETag.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteRefManagerAsync(String orgContactId, String ifMatch) {
        return deleteRefManagerWithResponseAsync(orgContactId, ifMatch).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete ref of navigation property manager for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteRefManagerAsync(String orgContactId) {
        final String ifMatch = null;
        return deleteRefManagerWithResponseAsync(orgContactId, ifMatch).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete ref of navigation property manager for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteRefManager(String orgContactId) {
        final String ifMatch = null;
        deleteRefManagerAsync(orgContactId, ifMatch).block();
    }

    /**
     * Delete ref of navigation property manager for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param ifMatch ETag.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteRefManagerWithResponse(String orgContactId, String ifMatch, Context context) {
        return deleteRefManagerWithResponseAsync(orgContactId, ifMatch, context).block();
    }

    /**
     * Get memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listMemberOf(
                            this.client.getEndpoint(),
                            orgContactId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listMemberOf(
                this.client.getEndpoint(),
                orgContactId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () -> listMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        final List<ContactsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () -> listMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listMemberOfSinglePageAsync(
                    orgContactId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listMemberOfNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        final List<ContactsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Get ref of memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRefMemberOf(
                            this.client.getEndpoint(),
                            orgContactId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRefMemberOf(
                this.client.getEndpoint(),
                orgContactId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get ref of memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefMemberOfAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby) {
        return new PagedFlux<>(
            () -> listRefMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby),
            nextLink -> listRefMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefMemberOfAsync(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        return new PagedFlux<>(
            () -> listRefMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby),
            nextLink -> listRefMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefMemberOfAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        Context context) {
        return new PagedFlux<>(
            () -> listRefMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby, context),
            nextLink -> listRefMemberOfNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefMemberOf(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        return new PagedIterable<>(listRefMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of memberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of memberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefMemberOf(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        Context context) {
        return new PagedIterable<>(
            listRefMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to memberOf for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(
        String orgContactId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createRefMemberOf(this.client.getEndpoint(), orgContactId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property ref to memberOf for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(
        String orgContactId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefMemberOf(this.client.getEndpoint(), orgContactId, body, accept, context);
    }

    /**
     * Create new navigation property ref to memberOf for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefMemberOfAsync(String orgContactId, Map<String, Object> body) {
        return createRefMemberOfWithResponseAsync(orgContactId, body)
            .flatMap(
                (Response<Map<String, Object>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property ref to memberOf for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> createRefMemberOf(String orgContactId, Map<String, Object> body) {
        return createRefMemberOfAsync(orgContactId, body).block();
    }

    /**
     * Create new navigation property ref to memberOf for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefMemberOfWithResponse(
        String orgContactId, Map<String, Object> body, Context context) {
        return createRefMemberOfWithResponseAsync(orgContactId, body, context).block();
    }

    /**
     * Invoke action checkMemberGroups.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(
        String orgContactId, ContactsCheckMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.checkMemberGroups(this.client.getEndpoint(), orgContactId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action checkMemberGroups.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(
        String orgContactId, ContactsCheckMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkMemberGroups(this.client.getEndpoint(), orgContactId, body, accept, context);
    }

    /**
     * Invoke action checkMemberGroups.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> checkMemberGroupsAsync(String orgContactId, ContactsCheckMemberGroupsRequestBody body) {
        return checkMemberGroupsWithResponseAsync(orgContactId, body)
            .flatMap(
                (Response<List<String>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action checkMemberGroups.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> checkMemberGroups(String orgContactId, ContactsCheckMemberGroupsRequestBody body) {
        return checkMemberGroupsAsync(orgContactId, body).block();
    }

    /**
     * Invoke action checkMemberGroups.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of Post200ApplicationJsonItemsItem.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> checkMemberGroupsWithResponse(
        String orgContactId, ContactsCheckMemberGroupsRequestBody body, Context context) {
        return checkMemberGroupsWithResponseAsync(orgContactId, body, context).block();
    }

    /**
     * Invoke action checkMemberObjects.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(
        String orgContactId, ContactsCheckMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.checkMemberObjects(this.client.getEndpoint(), orgContactId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action checkMemberObjects.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(
        String orgContactId, ContactsCheckMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.checkMemberObjects(this.client.getEndpoint(), orgContactId, body, accept, context);
    }

    /**
     * Invoke action checkMemberObjects.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> checkMemberObjectsAsync(String orgContactId, ContactsCheckMemberObjectsRequestBody body) {
        return checkMemberObjectsWithResponseAsync(orgContactId, body)
            .flatMap(
                (Response<List<String>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action checkMemberObjects.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> checkMemberObjects(String orgContactId, ContactsCheckMemberObjectsRequestBody body) {
        return checkMemberObjectsAsync(orgContactId, body).block();
    }

    /**
     * Invoke action checkMemberObjects.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> checkMemberObjectsWithResponse(
        String orgContactId, ContactsCheckMemberObjectsRequestBody body, Context context) {
        return checkMemberObjectsWithResponseAsync(orgContactId, body, context).block();
    }

    /**
     * Invoke action getMemberGroups.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(
        String orgContactId, ContactsGetMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getMemberGroups(this.client.getEndpoint(), orgContactId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action getMemberGroups.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(
        String orgContactId, ContactsGetMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getMemberGroups(this.client.getEndpoint(), orgContactId, body, accept, context);
    }

    /**
     * Invoke action getMemberGroups.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> getMemberGroupsAsync(String orgContactId, ContactsGetMemberGroupsRequestBody body) {
        return getMemberGroupsWithResponseAsync(orgContactId, body)
            .flatMap(
                (Response<List<String>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action getMemberGroups.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> getMemberGroups(String orgContactId, ContactsGetMemberGroupsRequestBody body) {
        return getMemberGroupsAsync(orgContactId, body).block();
    }

    /**
     * Invoke action getMemberGroups.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> getMemberGroupsWithResponse(
        String orgContactId, ContactsGetMemberGroupsRequestBody body, Context context) {
        return getMemberGroupsWithResponseAsync(orgContactId, body, context).block();
    }

    /**
     * Invoke action getMemberObjects.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(
        String orgContactId, ContactsGetMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getMemberObjects(this.client.getEndpoint(), orgContactId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action getMemberObjects.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(
        String orgContactId, ContactsGetMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getMemberObjects(this.client.getEndpoint(), orgContactId, body, accept, context);
    }

    /**
     * Invoke action getMemberObjects.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> getMemberObjectsAsync(String orgContactId, ContactsGetMemberObjectsRequestBody body) {
        return getMemberObjectsWithResponseAsync(orgContactId, body)
            .flatMap(
                (Response<List<String>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action getMemberObjects.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> getMemberObjects(String orgContactId, ContactsGetMemberObjectsRequestBody body) {
        return getMemberObjectsAsync(orgContactId, body).block();
    }

    /**
     * Invoke action getMemberObjects.
     *
     * @param orgContactId key: id of orgContact.
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of String.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> getMemberObjectsWithResponse(
        String orgContactId, ContactsGetMemberObjectsRequestBody body, Context context) {
        return getMemberObjectsWithResponseAsync(orgContactId, body, context).block();
    }

    /**
     * Invoke action restore.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String orgContactId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.restore(this.client.getEndpoint(), orgContactId, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action restore.
     *
     * @param orgContactId key: id of orgContact.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(
        String orgContactId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.restore(this.client.getEndpoint(), orgContactId, accept, context);
    }

    /**
     * Invoke action restore.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String orgContactId) {
        return restoreWithResponseAsync(orgContactId)
            .flatMap(
                (Response<MicrosoftGraphDirectoryObjectInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action restore.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner restore(String orgContactId) {
        return restoreAsync(orgContactId).block();
    }

    /**
     * Invoke action restore.
     *
     * @param orgContactId key: id of orgContact.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents an Azure Active Directory object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String orgContactId, Context context) {
        return restoreWithResponseAsync(orgContactId, context).block();
    }

    /**
     * Get transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listTransitiveMemberOf(
                            this.client.getEndpoint(),
                            orgContactId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            selectConverted,
                            expandConverted,
                            accept,
                            context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listTransitiveMemberOf(
                this.client.getEndpoint(),
                orgContactId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                selectConverted,
                expandConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand) {
        return new PagedFlux<>(
            () ->
                listTransitiveMemberOfSinglePageAsync(
                    orgContactId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listTransitiveMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        final List<ContactsSelect> select = null;
        final List<String> expand = null;
        return new PagedFlux<>(
            () ->
                listTransitiveMemberOfSinglePageAsync(
                    orgContactId, top, skip, search, filter, count, orderby, select, expand),
            nextLink -> listTransitiveMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedFlux<>(
            () ->
                listTransitiveMemberOfSinglePageAsync(
                    orgContactId, top, skip, search, filter, count, orderby, select, expand, context),
            nextLink -> listTransitiveMemberOfNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        final List<ContactsSelect> select = null;
        final List<String> expand = null;
        return new PagedIterable<>(
            listTransitiveMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby, select, expand));
    }

    /**
     * Get transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        List<ContactsSelect> select,
        List<String> expand,
        Context context) {
        return new PagedIterable<>(
            listTransitiveMemberOfAsync(
                orgContactId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    /**
     * Get ref of transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listRefTransitiveMemberOf(
                            this.client.getEndpoint(),
                            orgContactId,
                            top,
                            skip,
                            search,
                            filter,
                            count,
                            orderbyConverted,
                            accept,
                            context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get ref of transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        final String accept = "application/json";
        String orderbyConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service
            .listRefTransitiveMemberOf(
                this.client.getEndpoint(),
                orgContactId,
                top,
                skip,
                search,
                filter,
                count,
                orderbyConverted,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get ref of transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMemberOfAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby) {
        return new PagedFlux<>(
            () -> listRefTransitiveMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby),
            nextLink -> listRefTransitiveMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        return new PagedFlux<>(
            () -> listRefTransitiveMemberOfSinglePageAsync(orgContactId, top, skip, search, filter, count, orderby),
            nextLink -> listRefTransitiveMemberOfNextSinglePageAsync(nextLink));
    }

    /**
     * Get ref of transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<String> listRefTransitiveMemberOfAsync(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        Context context) {
        return new PagedFlux<>(
            () ->
                listRefTransitiveMemberOfSinglePageAsync(
                    orgContactId, top, skip, search, filter, count, orderby, context),
            nextLink -> listRefTransitiveMemberOfNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get ref of transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMemberOf(String orgContactId) {
        final Integer top = null;
        final Integer skip = null;
        final String search = null;
        final String filter = null;
        final Boolean count = null;
        final List<ContactsOrderby> orderby = null;
        return new PagedIterable<>(
            listRefTransitiveMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby));
    }

    /**
     * Get ref of transitiveMemberOf from contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param top Show only the first n items.
     * @param skip Skip the first n items.
     * @param search Search items by search phrases.
     * @param filter Filter items by property values.
     * @param count Include count of items.
     * @param orderby Order items by property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return ref of transitiveMemberOf from contacts.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> listRefTransitiveMemberOf(
        String orgContactId,
        Integer top,
        Integer skip,
        String search,
        String filter,
        Boolean count,
        List<ContactsOrderby> orderby,
        Context context) {
        return new PagedIterable<>(
            listRefTransitiveMemberOfAsync(orgContactId, top, skip, search, filter, count, orderby, context));
    }

    /**
     * Create new navigation property ref to transitiveMemberOf for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(
        String orgContactId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.createRefTransitiveMemberOf(this.client.getEndpoint(), orgContactId, body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Create new navigation property ref to transitiveMemberOf for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(
        String orgContactId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (orgContactId == null) {
            return Mono.error(new IllegalArgumentException("Parameter orgContactId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createRefTransitiveMemberOf(this.client.getEndpoint(), orgContactId, body, accept, context);
    }

    /**
     * Create new navigation property ref to transitiveMemberOf for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Map<String, Object>> createRefTransitiveMemberOfAsync(String orgContactId, Map<String, Object> body) {
        return createRefTransitiveMemberOfWithResponseAsync(orgContactId, body)
            .flatMap(
                (Response<Map<String, Object>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Create new navigation property ref to transitiveMemberOf for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Map<String, Object> createRefTransitiveMemberOf(String orgContactId, Map<String, Object> body) {
        return createRefTransitiveMemberOfAsync(orgContactId, body).block();
    }

    /**
     * Create new navigation property ref to transitiveMemberOf for contacts.
     *
     * @param orgContactId key: id of orgContact.
     * @param body New navigation property ref value.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return dictionary of &lt;any&gt;.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Map<String, Object>> createRefTransitiveMemberOfWithResponse(
        String orgContactId, Map<String, Object> body, Context context) {
        return createRefTransitiveMemberOfWithResponseAsync(orgContactId, body, context).block();
    }

    /**
     * Invoke function delta.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphOrgContactInner>>> deltaWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delta(this.client.getEndpoint(), accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke function delta.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphOrgContactInner>>> deltaWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delta(this.client.getEndpoint(), accept, context);
    }

    /**
     * Invoke function delta.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphOrgContactInner>> deltaAsync() {
        return deltaWithResponseAsync()
            .flatMap(
                (Response<List<MicrosoftGraphOrgContactInner>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke function delta.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<MicrosoftGraphOrgContactInner> delta() {
        return deltaAsync().block();
    }

    /**
     * Invoke function delta.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<MicrosoftGraphOrgContactInner>> deltaWithResponse(Context context) {
        return deltaWithResponseAsync(context).block();
    }

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(
        ContactsGetAvailableExtensionPropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getAvailableExtensionProperties(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(
        ContactsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAvailableExtensionProperties(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesAsync(
        ContactsGetAvailableExtensionPropertiesRequestBody body) {
        return getAvailableExtensionPropertiesWithResponseAsync(body)
            .flatMap(
                (Response<List<MicrosoftGraphExtensionPropertyInner>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<MicrosoftGraphExtensionPropertyInner> getAvailableExtensionProperties(
        ContactsGetAvailableExtensionPropertiesRequestBody body) {
        return getAvailableExtensionPropertiesAsync(body).block();
    }

    /**
     * Invoke action getAvailableExtensionProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesWithResponse(
        ContactsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        return getAvailableExtensionPropertiesWithResponseAsync(body, context).block();
    }

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(
        ContactsGetByIdsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getByIds(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(
        ContactsGetByIdsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByIds(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<MicrosoftGraphDirectoryObjectInner>> getByIdsAsync(ContactsGetByIdsRequestBody body) {
        return getByIdsWithResponseAsync(body)
            .flatMap(
                (Response<List<MicrosoftGraphDirectoryObjectInner>> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<MicrosoftGraphDirectoryObjectInner> getByIds(ContactsGetByIdsRequestBody body) {
        return getByIdsAsync(body).block();
    }

    /**
     * Invoke action getByIds.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of microsoft.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<MicrosoftGraphDirectoryObjectInner>> getByIdsWithResponse(
        ContactsGetByIdsRequestBody body, Context context) {
        return getByIdsWithResponseAsync(body, context).block();
    }

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> validatePropertiesWithResponseAsync(ContactsValidatePropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.validateProperties(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> validatePropertiesWithResponseAsync(
        ContactsValidatePropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.validateProperties(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> validatePropertiesAsync(ContactsValidatePropertiesRequestBody body) {
        return validatePropertiesWithResponseAsync(body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void validateProperties(ContactsValidatePropertiesRequestBody body) {
        validatePropertiesAsync(body).block();
    }

    /**
     * Invoke action validateProperties.
     *
     * @param body Action parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> validatePropertiesWithResponse(ContactsValidatePropertiesRequestBody body, Context context) {
        return validatePropertiesWithResponseAsync(body, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMore(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMore(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefDirectReportsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRefDirectReportsNext(nextLink, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefDirectReportsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRefDirectReportsNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listMemberOfNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listMemberOfNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRefMemberOfNext(nextLink, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRefMemberOfNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(
        String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listTransitiveMemberOfNext(nextLink, context))
            .<PagedResponse<MicrosoftGraphDirectoryObjectInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listTransitiveMemberOfNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.listRefTransitiveMemberOfNext(nextLink, context))
            .<PagedResponse<String>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of links of directoryObject.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .listRefTransitiveMemberOfNext(nextLink, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().odataNextLink(),
                        null));
    }
}
