// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.resourcemanager.authorization.fluent.DirectoryDirectoriesClient;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryDirectoryExpand;
import com.azure.resourcemanager.authorization.fluent.models.Get0ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import java.util.List;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in DirectoryDirectoriesClient. */
public final class DirectoryDirectoriesClientImpl implements DirectoryDirectoriesClient {
    private final ClientLogger logger = new ClientLogger(DirectoryDirectoriesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final DirectoryDirectoriesService service;

    /** The service client containing this operation class. */
    private final MicrosoftGraphClientImpl client;

    /**
     * Initializes an instance of DirectoryDirectoriesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    DirectoryDirectoriesClientImpl(MicrosoftGraphClientImpl client) {
        this.service =
            RestProxy
                .create(DirectoryDirectoriesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for MicrosoftGraphClientDirectoryDirectories to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "MicrosoftGraphClient")
    private interface DirectoryDirectoriesService {
        @Headers({"Content-Type: application/json"})
        @Get("/directory")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<MicrosoftGraphDirectoryInner>> getDirectory(
            @HostParam("$host") String endpoint,
            @QueryParam("$select") String select,
            @QueryParam("$expand") String expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch("/directory")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(OdataErrorMainException.class)
        Mono<Response<Void>> updateDirectory(
            @HostParam("$host") String endpoint,
            @BodyParam("application/json") MicrosoftGraphDirectoryInner body,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Get directory.
     *
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryInner>> getDirectoryWithResponseAsync(
        List<Get0ItemsItem> select, List<DirectoryDirectoryExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil
            .withContext(
                context ->
                    service.getDirectory(this.client.getEndpoint(), selectConverted, expandConverted, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get directory.
     *
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryInner>> getDirectoryWithResponseAsync(
        List<Get0ItemsItem> select, List<DirectoryDirectoryExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        String selectConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted =
            JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return service.getDirectory(this.client.getEndpoint(), selectConverted, expandConverted, accept, context);
    }

    /**
     * Get directory.
     *
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryInner> getDirectoryAsync(
        List<Get0ItemsItem> select, List<DirectoryDirectoryExpand> expand) {
        return getDirectoryWithResponseAsync(select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get directory.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryInner> getDirectoryAsync() {
        final List<Get0ItemsItem> select = null;
        final List<DirectoryDirectoryExpand> expand = null;
        return getDirectoryWithResponseAsync(select, expand)
            .flatMap(
                (Response<MicrosoftGraphDirectoryInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get directory.
     *
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MicrosoftGraphDirectoryInner getDirectory() {
        final List<Get0ItemsItem> select = null;
        final List<DirectoryDirectoryExpand> expand = null;
        return getDirectoryAsync(select, expand).block();
    }

    /**
     * Get directory.
     *
     * @param select Select properties to be returned.
     * @param expand Expand related entities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return directory.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryInner> getDirectoryWithResponse(
        List<Get0ItemsItem> select, List<DirectoryDirectoryExpand> expand, Context context) {
        return getDirectoryWithResponseAsync(select, expand, context).block();
    }

    /**
     * Update directory.
     *
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> updateDirectoryWithResponseAsync(MicrosoftGraphDirectoryInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateDirectory(this.client.getEndpoint(), body, accept, context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Update directory.
     *
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> updateDirectoryWithResponseAsync(MicrosoftGraphDirectoryInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateDirectory(this.client.getEndpoint(), body, accept, context);
    }

    /**
     * Update directory.
     *
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> updateDirectoryAsync(MicrosoftGraphDirectoryInner body) {
        return updateDirectoryWithResponseAsync(body).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Update directory.
     *
     * @param body New property values.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void updateDirectory(MicrosoftGraphDirectoryInner body) {
        updateDirectoryAsync(body).block();
    }

    /**
     * Update directory.
     *
     * @param body New property values.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws OdataErrorMainException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> updateDirectoryWithResponse(MicrosoftGraphDirectoryInner body, Context context) {
        return updateDirectoryWithResponseAsync(body, context).block();
    }
}
